/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import com.orocube.orocust.OroCustMessages;
import java.util.Date;

public class TicketListTableModel
extends PaginatedTableModel {
    public TicketListTableModel() {
        super(new String[]{OroCustMessages.getString("TicketListTableModel.1"), OroCustMessages.getString("TicketListTableModel.2"), OroCustMessages.getString("TicketListTableModel.3"), OroCustMessages.getString("TicketListTableModel.4"), OroCustMessages.getString("TicketListTableModel.5"), OroCustMessages.getString("TicketListTableModel.6"), OroCustMessages.getString("TicketListTableModel.7"), OroCustMessages.getString("TicketListTableModel.8"), OroCustMessages.getString("TicketListTableModel.9"), OroCustMessages.getString("TicketListTableModel.10")});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Ticket ticket = (Ticket)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ticket.getTokenNo();
            }
            case 1: {
                String customerZipCode = ticket.getProperty("CUSTOMER_ZIP_CODE");
                if (customerZipCode == null) {
                    return "";
                }
                return customerZipCode;
            }
            case 2: {
                String customerName = ticket.getProperty("CUSTOMER_NAME");
                if (customerName != null && !customerName.equals("")) {
                    return customerName;
                }
                return "";
            }
            case 3: {
                String customerMobile = ticket.getProperty("CUSTOMER_MOBILE");
                if (customerMobile != null) {
                    return customerMobile;
                }
                return "";
            }
            case 4: {
                return ticket.getDeliveryAddress();
            }
            case 5: {
                String status = "";
                status = ticket.isPaid() != false ? OroCustMessages.getString("TicketListView.8") : OroCustMessages.getString("TicketListView.9");
                if (ticket.isVoided().booleanValue()) {
                    status = OroCustMessages.getString("TicketListView.12");
                } else if (ticket.isClosed().booleanValue()) {
                    status = OroCustMessages.getString("TicketListView.13");
                }
                return status;
            }
            case 6: {
                Date deliveryDate = ticket.getDeliveryDate();
                if (deliveryDate == null) {
                    return "";
                }
                if (DateUtil.isToday(deliveryDate)) {
                    return DateUtil.formatAsTodayDate(deliveryDate);
                }
                return DateUtil.formatFullDateAndTimeAsString(deliveryDate);
            }
            case 7: {
                return ticket.getDueAmount();
            }
            case 8: {
                return ticket.getProperty("OUT_AT");
            }
            case 9: {
                if (ticket.isCustomerWillPickup().booleanValue()) {
                    return OroCustMessages.getString("TicketListTableModel.14");
                }
                if (ticket.getAssignedDriver() != null) {
                    return ticket.getAssignedDriver().getFullName();
                }
                return "";
            }
        }
        return null;
    }
}

