/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdesktop.swingx.JXTable;

public class AssignDriverDialog
extends JDialog {
    private JTextField tfRecipientName;
    private JTextField tfDeliveryDate;
    private Ticket ticket;
    private JTextArea tfDeliveryAddress;
    private JTextArea tfExtraInstruction;
    private JXTable driverTable;
    private PosSmallButton btnCancel;
    private PosSmallButton btnSave;
    protected boolean canceled = true;

    public AssignDriverDialog(Frame parent) {
        super(parent, OroCustMessages.getString("AssignDriverDialog.0"), true);
        this.createUI();
        this.setDefaultCloseOperation(2);
    }

    private void createUI() {
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][60px,grow,shrink 0][60px,shrink 0][grow][shrink 0]"));
        JLabel lblRecipientName = new JLabel(OroCustMessages.getString("AssignDriverDialog.4"));
        this.getContentPane().add((Component)lblRecipientName, "cell 0 0,alignx trailing");
        this.tfRecipientName = new JTextField();
        this.tfRecipientName.setEnabled(true);
        this.tfRecipientName.setEditable(false);
        this.tfRecipientName.setFocusable(false);
        this.getContentPane().add((Component)this.tfRecipientName, "cell 1 0,growx");
        this.tfRecipientName.setColumns(10);
        JLabel lblDeliveryDate = new JLabel(OroCustMessages.getString("AssignDriverDialog.7"));
        this.getContentPane().add((Component)lblDeliveryDate, "cell 0 1,alignx trailing");
        this.tfDeliveryDate = new JTextField();
        this.tfDeliveryDate.setEnabled(true);
        this.tfDeliveryDate.setEditable(false);
        this.tfDeliveryDate.setFocusable(false);
        this.getContentPane().add((Component)this.tfDeliveryDate, "cell 1 1,growx");
        this.tfDeliveryDate.setColumns(10);
        JLabel lblDeliveryAddress = new JLabel(OroCustMessages.getString("AssignDriverDialog.10"));
        this.getContentPane().add((Component)lblDeliveryAddress, "cell 0 2,aligny top");
        this.tfDeliveryAddress = new JTextArea();
        this.tfDeliveryAddress.setEnabled(true);
        this.tfDeliveryAddress.setEditable(false);
        this.tfDeliveryAddress.setFocusable(false);
        this.tfDeliveryAddress.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.tfDeliveryAddress.setRows(4);
        this.getContentPane().add((Component)this.tfDeliveryAddress, "cell 1 2,grow");
        JLabel lblExtraInstruction = new JLabel(OroCustMessages.getString("AssignDriverDialog.13"));
        this.getContentPane().add((Component)lblExtraInstruction, "cell 0 3,aligny top");
        this.tfExtraInstruction = new JTextArea();
        this.tfExtraInstruction.setEnabled(true);
        this.tfExtraInstruction.setEditable(false);
        this.tfExtraInstruction.setFocusable(true);
        this.tfExtraInstruction.setBorder(new LineBorder(Color.LIGHT_GRAY));
        this.tfExtraInstruction.setRows(4);
        this.getContentPane().add((Component)this.tfExtraInstruction, "cell 1 3,grow");
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "cell 0 4 2 1,grow");
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "Center");
        this.driverTable = new JXTable();
        scrollPane.setViewportView((Component)this.driverTable);
        JPanel panel_1 = new JPanel();
        this.getContentPane().add((Component)panel_1, "cell 0 5 2 1,grow");
        this.btnCancel = new PosSmallButton();
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignDriverDialog.this.canceled = true;
                AssignDriverDialog.this.dispose();
            }
        });
        this.btnCancel.setText(OroCustMessages.getString("AssignDriverDialog.18"));
        panel_1.add(this.btnCancel);
        this.btnSave = new PosSmallButton();
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignDriverDialog.this.saveTicket();
            }
        });
        this.btnSave.setText(OroCustMessages.getString("AssignDriverDialog.19"));
        panel_1.add(this.btnSave);
        this.driverTable.setModel((TableModel)new DriverTableModel());
        this.driverTable.setFocusable(false);
        this.driverTable.setRowHeight(35);
        this.driverTable.getSelectionModel().setSelectionMode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveTicket() {
        int selectedRow = this.driverTable.getSelectedRow();
        if (selectedRow < 0) {
            POSMessageDialog.showError(OroCustMessages.getString("AssignDriverDialog.20"));
            return;
        }
        DriverTableModel model = (DriverTableModel)this.driverTable.getModel();
        User driver = model.getDriver(selectedRow);
        this.ticket.setAssignedDriver(driver);
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)this.ticket);
            transaction.commit();
            this.canceled = false;
            this.dispose();
        }
    }

    public void setData(Ticket ticket, List<User> drivers) {
        this.ticket = ticket;
        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
            this.tfRecipientName.setText(ticket.getProperty("CUSTOMER_NAME"));
        }
        if (ticket.getDeliveryDate() != null) {
            this.tfDeliveryDate.setText(ticket.getDeliveryDate().toString());
        }
        this.tfDeliveryAddress.setText(ticket.getDeliveryAddress());
        this.tfExtraInstruction.setText(ticket.getExtraDeliveryInfo());
        this.driverTable.setModel((TableModel)new DriverTableModel(drivers));
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    class DriverTableModel
    extends AbstractTableModel {
        private final String[] columns = new String[]{OroCustMessages.getString("AssignDriverDialog.21"), OroCustMessages.getString("AssignDriverDialog.22"), OroCustMessages.getString("AssignDriverDialog.23")};
        private List<User> drivers;

        public DriverTableModel() {
        }

        public DriverTableModel(List<User> customers) {
            this.drivers = customers;
        }

        @Override
        public int getRowCount() {
            if (this.drivers == null) {
                return 0;
            }
            return this.drivers.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.drivers == null) {
                return null;
            }
            User driver = this.drivers.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return driver.getPhoneNo();
                }
                case 1: {
                    return driver.getFirstName() + " " + driver.getLastName();
                }
                case 2: {
                    return driver.isAvailableForDelivery() != false ? OroCustMessages.getString("AssignDriverDialog.25") : OroCustMessages.getString("AssignDriverDialog.26");
                }
            }
            return null;
        }

        public List<User> getDrivers() {
            return this.drivers;
        }

        public User getDriver(int index) {
            if (this.drivers == null) {
                return null;
            }
            if (index < 0 || index >= this.drivers.size()) {
                return null;
            }
            return this.drivers.get(index);
        }
    }
}

