/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class CallerIdCustomerSelectionDialog
extends POSDialog {
    private JPanel buttonsPanel;
    private Customer selectedCustomer;
    private TitlePanel titlePane;

    public CallerIdCustomerSelectionDialog(List<Customer> customers) {
        super((Frame)Application.getPosWindow(), OroCustMessages.getString("CallerIdCustomerSelectionDialog.0"));
        this.initComponent();
        this.rendererCustomers(customers);
    }

    private void initComponent() {
        JPanel contentPanel = new JPanel(new BorderLayout(5, 5));
        contentPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.setLayout(new BorderLayout());
        this.buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill,aligny top,wrap 3", "sg,fill,grow", ""));
        this.titlePane = new TitlePanel();
        this.add((Component)this.titlePane, "North");
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null));
        contentPanel.add((Component)scrollPane, "Center");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.add((Component)new JSeparator(), "North");
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallerIdCustomerSelectionDialog.this.setCanceled(true);
                CallerIdCustomerSelectionDialog.this.dispose();
            }
        });
        btnCancel.setBorder(null);
        footerPanel.add((Component)btnCancel, "South");
        this.add((Component)footerPanel, "South");
        this.add((Component)contentPanel, "Center");
    }

    private void rendererCustomers(List<Customer> customers) {
        try {
            Dimension size = PosUIManager.getSize(150, 80);
            for (int i = 0; i < 10; ++i) {
                for (Customer customer : customers) {
                    CustomerButton btnCustomer = new CustomerButton(customer);
                    btnCustomer.setMinimumSize(size);
                    this.buttonsPanel.add((Component)btnCustomer, "grow");
                }
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    public void setTitlePaneText(String title) {
        this.titlePane.setTitle(title);
    }

    public Customer getSelectedCustomer() {
        return this.selectedCustomer;
    }

    private class CustomerButton
    extends PosButton
    implements ActionListener {
        private Customer customer;

        CustomerButton(Customer customer) {
            this.customer = customer;
            this.setFont(this.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
            this.setText("<html><body><center>" + customer.getName() + "<br>" + customer.getAddress() + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallerIdCustomerSelectionDialog.this.selectedCustomer = this.customer;
            CallerIdCustomerSelectionDialog.this.setCanceled(false);
            CallerIdCustomerSelectionDialog.this.dispose();
        }
    }
}

