/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.dao.DeliveryInstructionDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class DeliveryInstructionSelectionDialog
extends POSDialog {
    private JList<DeliveryInstruction> list;
    private DefaultListModel<DeliveryInstruction> listModel;
    private DeliveryInstruction selectedDeliveryInstruction;
    private JPanel centerPanel;
    Customer customer;

    public DeliveryInstructionSelectionDialog(Customer customer) {
        this.customer = customer;
        this.initComponent();
        for (DeliveryInstruction deliveryInstruction : customer.getDeliveryInstructions()) {
            if (deliveryInstruction.getNotes().isEmpty()) continue;
            this.listModel.addElement(deliveryInstruction);
        }
    }

    private void initComponent() {
        this.setLayout(new BorderLayout(5, 5));
        this.centerPanel = new JPanel(new BorderLayout(5, 5));
        this.centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.listModel = new DefaultListModel();
        JScrollPane scrollPane = new JScrollPane();
        this.list = new JList<DeliveryInstruction>(this.listModel);
        this.list.setFixedCellHeight(60);
        this.list.setFocusable(true);
        scrollPane.setViewportView(this.list);
        this.centerPanel.add((Component)scrollPane, "Center");
        this.add(this.centerPanel);
        this.addButtonPanel();
    }

    private void addButtonPanel() {
        PosButton addButton = new PosButton(OroCustMessages.getString("DeliveryInstructionSelectionDialog.0"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String address = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)OroCustMessages.getString("DeliveryInstructionSelectionDialog.1"));
                    if (address == null) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("DeliveryInstructionSelectionDialog.2"));
                        return;
                    }
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        PosButton selectButton = new PosButton(OroCustMessages.getString("DeliveryInstructionSelectionDialog.3"));
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DeliveryInstructionSelectionDialog.this.selectedDeliveryInstruction = (DeliveryInstruction)DeliveryInstructionSelectionDialog.this.list.getSelectedValue();
                    if (DeliveryInstructionSelectionDialog.this.selectedDeliveryInstruction == null) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), OroCustMessages.getString("SelectAnInstruction"));
                        return;
                    }
                    DeliveryInstructionSelectionDialog.this.setCanceled(false);
                    DeliveryInstructionSelectionDialog.this.dispose();
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        PosButton deleteButton = new PosButton(POSConstants.DELETE.toUpperCase());
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DeliveryInstructionSelectionDialog.this.selectedDeliveryInstruction = (DeliveryInstruction)DeliveryInstructionSelectionDialog.this.list.getSelectedValue();
                    if (POSMessageDialog.showYesNoQuestionDialog(DeliveryInstructionSelectionDialog.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    DeliveryInstructionDAO dao = new DeliveryInstructionDAO();
                    dao.delete(DeliveryInstructionSelectionDialog.this.selectedDeliveryInstruction);
                    DeliveryInstructionSelectionDialog.this.listModel.removeElement(DeliveryInstructionSelectionDialog.this.selectedDeliveryInstruction);
                }
                catch (Exception x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        PosButton cancelButton = new PosButton(POSConstants.CANCEL.toUpperCase());
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeliveryInstructionSelectionDialog.this.setCanceled(true);
                DeliveryInstructionSelectionDialog.this.dispose();
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(selectButton);
        panel.add(cancelButton);
        this.centerPanel.add((Component)panel, "South");
    }

    public DeliveryInstruction getSelectedInstruction() {
        return this.selectedDeliveryInstruction;
    }
}

