/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.view.CustomerGroupDetailForm;
import com.orocube.orocust.ui.view.CustomerGroupForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class CustomerGroupExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<CustomerGroup> tableModel;

    public CustomerGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(CustomerGroup.class);
        this.tableModel.addColumn(OroCustMessages.getString("CustomerGroupExplorer.0"), "name");
        this.tableModel.addColumn(OroCustMessages.getString("CustomerGroupExplorer.1"), "code");
        this.tableModel.addColumn(OroCustMessages.getString("CustomerGroupExplorer.2"), "description");
        this.tableModel.addRows(CustomerGroupDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    CustomerGroupExplorer.this.editSelectedRow();
                }
            }
        });
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton detailButton = new JButton(POSConstants.DETAILS);
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        detailButton.addActionListener(e -> this.openCustomerList(true));
        addButton.addActionListener(e -> this.doAddCustomerGroup());
        editButton.addActionListener(e -> this.editSelectedRow());
        deleteButton.addActionListener(e -> this.doDeleteCustomerGroup());
        TransparentPanel panel = new TransparentPanel();
        panel.add(detailButton);
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            CustomerGroup customerGroup = this.tableModel.getRow(index);
            customerGroup = CustomerGroupDAO.getInstance().load(customerGroup.getId());
            this.tableModel.setRow(index, customerGroup);
            CustomerGroupForm editor = new CustomerGroupForm(customerGroup);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(500, 550));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void openCustomerList(boolean viewMode) {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToShowDetails"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            CustomerGroup customerGroup = this.tableModel.getRow(index);
            CustomerGroupDetailForm editor = new CustomerGroupDetailForm(customerGroup);
            editor.setEditable(!viewMode);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            if (viewMode) {
                dialog.getButtonPanel().remove(0);
            }
            dialog.openWithScale(650, 600);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doAddCustomerGroup() {
        try {
            CustomerGroupForm editor = new CustomerGroupForm(new CustomerGroup());
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(500, 550));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            CustomerGroup customerGroup = (CustomerGroup)editor.getBean();
            this.tableModel.addRow(customerGroup);
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteCustomerGroup() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(Messages.getString("SelectToDelete"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            CustomerGroup customerGroup = this.tableModel.getRow(index);
            CustomerGroupDAO customerGroupDAO = CustomerGroupDAO.getInstance();
            if (StringUtils.isNotBlank((String)customerGroup.getId())) {
                customerGroupDAO.delete(customerGroup.getId());
            }
            this.tableModel.removeRow(index);
        }
        catch (PosException x) {
            DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
            dialog.open();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

