/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.PosException;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.orocust.OroCustMessages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DriverTicketListView
extends JPanel {
    private ScrollableFlowPanel buttonsPanel;
    private List<Ticket> addedTicketListModel = new ArrayList<Ticket>();
    private User user;
    private JScrollPane scrollPane;

    public DriverTicketListView(User driver) {
        this.user = driver;
        this.initComponent();
    }

    protected void setUser(User user) {
        this.user = user;
    }

    protected void setTickets(List<Ticket> tickets) {
        this.reset();
        ArrayList<Ticket> deliveryTicketList = new ArrayList<Ticket>();
        for (Ticket ticket : tickets) {
            if (!ticket.getOrderType().isDelivery().booleanValue() || ticket.isCustomerWillPickup().booleanValue() || ticket.isClosed().booleanValue()) continue;
            deliveryTicketList.add(ticket);
        }
        ArrayList<Ticket> driverTickets = new ArrayList<Ticket>();
        if (this.user.isDriver().booleanValue()) {
            for (Ticket ticket : deliveryTicketList) {
                User ticketUser = ticket.getAssignedDriver();
                if (ticketUser == null || !ticketUser.getId().equals(this.user.getId())) continue;
                driverTickets.add(ticket);
            }
        } else {
            driverTickets.addAll(deliveryTicketList);
        }
        if (!driverTickets.isEmpty()) {
            this.rendererTickets(driverTickets);
        }
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    private void reset() {
        this.addedTicketListModel.clear();
        this.buttonsPanel.getContentPane().removeAll();
    }

    private void initComponent() {
        this.setLayout(new BorderLayout(5, 5));
        this.buttonsPanel = new ScrollableFlowPanel(3);
        this.scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        this.scrollPane.setBorder(null);
        this.add((Component)this.scrollPane, "Center");
    }

    private void rendererTickets(List<Ticket> tickets) {
        Collections.sort(tickets, new Comparator<Ticket>(){

            @Override
            public int compare(Ticket o1, Ticket o2) {
                String zipCode1 = o1.getProperty("CUSTOMER_ZIP_CODE");
                String zipCode2 = o2.getProperty("CUSTOMER_ZIP_CODE");
                if (zipCode1 == null) {
                    zipCode1 = "";
                }
                if (zipCode2 == null) {
                    zipCode2 = "";
                }
                return zipCode1.compareTo(zipCode2);
            }
        });
        Collections.sort(tickets, new Comparator<Ticket>(){

            @Override
            public int compare(Ticket o1, Ticket o2) {
                Date deliveryDate1 = o1.getDeliveryDate();
                Date deliveryDate2 = o2.getDeliveryDate();
                if (deliveryDate1 == null || deliveryDate2 == null) {
                    return -1;
                }
                return deliveryDate2.compareTo(deliveryDate1);
            }
        });
        try {
            for (Ticket ticket : tickets) {
                if (ticket.getDueAmount() <= 0.0) continue;
                TicketButton btnTicket = new TicketButton(ticket);
                btnTicket.setBackground(Color.white);
                btnTicket.setPreferredSize(PosUIManager.getSize(198, 162));
                this.buttonsPanel.add(btnTicket);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    public void doOk() {
        if (this.addedTicketListModel.isEmpty()) {
            POSMessageDialog.showMessage(OroCustMessages.getString("TicketSelectionDialog.5"));
            return;
        }
    }

    public void doCancel() {
        this.addedTicketListModel.clear();
    }

    public List<Ticket> getSelectedTickets() {
        return this.addedTicketListModel;
    }

    private class TicketButton
    extends POSToggleButton
    implements ActionListener {
        private Ticket ticket;

        TicketButton(Ticket ticket) {
            String customerAddress;
            String customerZipCode;
            String customerMobile;
            this.ticket = ticket;
            String customerName = ticket.getProperty("CUSTOMER_NAME");
            if (customerName == null) {
                customerName = "";
            }
            if ((customerMobile = ticket.getProperty("CUSTOMER_MOBILE")) == null) {
                customerMobile = "";
            }
            if ((customerZipCode = ticket.getProperty("CUSTOMER_ZIP_CODE")) == null) {
                customerZipCode = "";
            }
            if ((customerAddress = ticket.getDeliveryAddress()) == null) {
                customerAddress = "";
            }
            Date deliveryDate = ticket.getDeliveryDate() != null ? ticket.getDeliveryDate() : new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            String date = dateFormat.format(deliveryDate);
            if (DateUtil.isToday(deliveryDate)) {
                date = DateUtil.formatAsTodayDate(deliveryDate);
            }
            this.setText("<html><body><center><h3>" + ticket.getNumberToDisplay() + "<br>" + customerZipCode + "</h3>" + customerName + "<br>" + customerMobile + "</br><br>" + customerAddress + "<br><h4>" + OroCustMessages.getString("DriverTicketListView.8") + date.replaceAll("TODAY", "") + "</h4></center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isSelected()) {
                DriverTicketListView.this.addedTicketListModel.add(this.ticket);
            } else {
                DriverTicketListView.this.addedTicketListModel.remove(this.ticket);
            }
        }
    }
}

