/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.orocust.ui.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.orocust.OroCustMessages;
import com.orocube.orocust.ui.view.DriverTicketListView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class DriverView
extends ViewPanel {
    public static final String VIEW_NAME = "DRIVER_VIEW";
    private DriverTicketListView ticketListPanel;
    private static DriverView instance;
    private PosButton btnDriverIn;
    private PosButton btnDriverOut;
    private PosButton btnClose;
    private PosButton btnQuickCash;

    public DriverView() {
        this.setLayout(new BorderLayout());
        this.initComponent();
    }

    private void initComponent() {
        this.ticketListPanel = new DriverTicketListView(Application.getCurrentUser());
        this.ticketListPanel.setBorder(new TitledBorder(null, OroCustMessages.getString("DriverView.1"), 2, 2));
        this.add((Component)this.ticketListPanel, "Center");
        JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1", "sg,fill", ""));
        actionButtonPanel.setBorder(new TitledBorder(null, "-", 2, 2));
        this.btnDriverOut = new PosButton(OroCustMessages.getString("DriverView.6"));
        this.btnDriverOut.setMinimumSize(PosUIManager.getSize(100, 0));
        this.btnDriverOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DriverView.this.ticketListPanel.getSelectedTickets().isEmpty()) {
                    POSMessageDialog.showMessage(OroCustMessages.getString("DriverView.7"));
                    return;
                }
                if (!Application.getCurrentUser().isAvailableForDelivery().booleanValue()) {
                    POSMessageDialog.showMessage(OroCustMessages.getString("DriverView.2"));
                    return;
                }
                DriverView.this.doAssignTicketsForDriverOut();
            }
        });
        actionButtonPanel.add(this.btnDriverOut);
        this.btnDriverIn = new PosButton(OroCustMessages.getString("DriverView.8"));
        this.btnDriverIn.setMinimumSize(PosUIManager.getSize(100, 0));
        this.btnDriverIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Application.getCurrentUser().isDriver().booleanValue()) {
                    new ClockInOutAction().performDriverIn(Application.getCurrentUser());
                    DriverView.this.updateButton();
                }
            }
        });
        actionButtonPanel.add(this.btnDriverIn);
        this.btnQuickCash = new PosButton(OroCustMessages.getString("DriverView.9"));
        this.btnQuickCash.setMinimumSize(PosUIManager.getSize(100, 0));
        this.btnQuickCash.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DriverView.this.settleTickets();
            }
        });
        actionButtonPanel.add(this.btnQuickCash);
        this.btnClose = new PosButton(POSConstants.CLOSE.toUpperCase() + OroCustMessages.getString("DriverView.10"));
        this.btnClose.setMinimumSize(PosUIManager.getSize(100, 0));
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DriverView.this.closeTickets();
            }
        });
        actionButtonPanel.add(this.btnClose);
        this.add((Component)actionButtonPanel, "East");
    }

    protected void settleTickets() {
        try {
            List<Ticket> tickets = this.ticketListPanel.getSelectedTickets();
            if (tickets.isEmpty()) {
                POSMessageDialog.showError(POSConstants.SELECT_A_TICKET_FROM_THE_OPEN_TICKET_LIST);
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), OroCustMessages.getString("DriverView.11"), OroCustMessages.getString("DriverView.0")) == 1) {
                return;
            }
            for (Ticket ticket : tickets) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                PosTransaction transaction = PaymentType.CASH.createTransaction();
                transaction.setTicket(ticket);
                transaction.setCaptured(true);
                transaction.setTenderAmount(ticket.getDueAmount());
                transaction.setAmount(ticket.getDueAmount());
                PosTransactionService transactionService = PosTransactionService.getInstance();
                transactionService.settleTicket(ticket, transaction, Application.getCurrentUser());
            }
            POSMessageDialog.showMessage(OroCustMessages.getString("DriverView.13"));
        }
        catch (Exception ex) {
            PosLog.error(this.getClass(), ex);
        }
        this.updateTicketList();
    }

    private void doAssignTicketsForDriverOut() {
        try {
            List<Ticket> tickets = this.ticketListPanel.getSelectedTickets();
            ArrayList<User> drivers = new ArrayList<User>();
            TicketDAO.getInstance().doDriverOut(tickets, drivers);
            for (Ticket ticket : tickets) {
                Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                ReceiptPrintService.printTicket(fullTicket, "Customer Copy");
                ReceiptPrintService.printTicket(fullTicket, "Driver Copy");
            }
            if (!Application.getCurrentUser().isDriver().booleanValue()) {
                for (User driver : drivers) {
                    new ClockInOutAction().performDriverOut(driver);
                }
            } else {
                new ClockInOutAction().performDriverOut(Application.getCurrentUser());
            }
            tickets.clear();
            this.updateTicketList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, OroCustMessages.getString("DriverView.3"), e);
        }
    }

    private void closeTickets() {
        try {
            List<Ticket> tickets = this.ticketListPanel.getSelectedTickets();
            if (tickets.isEmpty()) {
                POSMessageDialog.showError(POSConstants.SELECT_A_TICKET_FROM_THE_OPEN_TICKET_LIST);
                return;
            }
            ArrayList<Ticket> selectedTickets = new ArrayList<Ticket>();
            for (Ticket ticket : tickets) {
                if (ticket.getDueAmount() > 0.0) {
                    int option = JOptionPane.showOptionDialog(Application.getPosWindow(), OroCustMessages.getString("SwitchboardView.6") + ticket.getId() + OroCustMessages.getString("DriverView.14"), OroCustMessages.getString("OrderWithCustomerService.9"), 2, 1, null, null, null);
                    if (option != 0) continue;
                    if (!POSUtil.checkDrawerAssignment()) {
                        return;
                    }
                    ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                    SettleTicketDialog posDialog = new SettleTicketDialog(ticket, Application.getCurrentUser());
                    posDialog.setSize(Application.getPosWindow().getSize());
                    posDialog.setDefaultCloseOperation(2);
                    posDialog.openUndecoratedFullScreen();
                    if (posDialog.isCanceled() || !ticket.isPaid().booleanValue()) continue;
                    selectedTickets.add(ticket);
                    continue;
                }
                selectedTickets.add(ticket);
            }
            TicketDAO.closeOrders(selectedTickets.toArray(new Ticket[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateTicketList();
    }

    private void updateTicketList() {
        List<Ticket> tickets = TicketDAO.getInstance().findOpenTickets();
        this.ticketListPanel.setUser(Application.getCurrentUser());
        this.ticketListPanel.setTickets(tickets);
        this.updateButton();
    }

    private void updateButton() {
        User currentUser = Application.getCurrentUser();
        this.btnDriverIn.setEnabled(currentUser.isDriver() != false && currentUser.isAvailableForDelivery() == false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public static DriverView getInstance() {
        if (instance == null) {
            instance = new DriverView();
        }
        return instance;
    }

    @Override
    public void refresh() {
        DriverView.getInstance().updateTicketList();
    }
}

