/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory;

import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.inventory.versioning.InventoryVersionInfo;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.about.AboutPluginAction;
import com.orocube.common.util.ProductInfo;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.action.InventoryAverageUnitCostReportAction;
import com.orostock.inventory.action.InventoryConfigurationAction;
import com.orostock.inventory.action.InventoryItemBrowserAction;
import com.orostock.inventory.action.InventoryLocationEntryAction;
import com.orostock.inventory.action.InventoryOnHandReportAction;
import com.orostock.inventory.action.InventoryOnHandReportNewAction;
import com.orostock.inventory.action.InventoryPrintLabelAction;
import com.orostock.inventory.action.InventoryStockEntryAction;
import com.orostock.inventory.action.InventoryTransactionEntryAction;
import com.orostock.inventory.action.InventoryTransactionReportAction;
import com.orostock.inventory.action.InventoryUnisExplorerAction;
import com.orostock.inventory.action.InventoryVendorEntryAction;
import com.orostock.inventory.action.PackagingUnitFormAction;
import com.orostock.inventory.action.PurchaseOrderExplorerAction;
import com.orostock.inventory.action.ShoppingListAction;
import com.orostock.inventory.action.StockCountExplorerAction;
import com.orostock.inventory.ui.InventoryUnitForm;
import com.orostock.inventory.ui.MenuItemPackagingUnitBrowser;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;

@PluginImplementation
public class OrocubeInventoryPlugin
extends InventoryPlugin
implements ProductInfo {
    public void initUI(PosWindow posWindow) {
    }

    public void addRecepieView(JTabbedPane tabbedPane) {
    }

    public void addStockUnitView(JTabbedPane tabbedPane, MenuItem menuItem) {
        tabbedPane.addTab(InvMessages.getString("IVOIO.0"), new MenuItemPackagingUnitBrowser(menuItem));
    }

    public void showInventoryUnitEntryDialog(InventoryUnit unit) {
        InventoryUnitForm editor = new InventoryUnitForm(unit);
        BeanEditorDialog dialog = new BeanEditorDialog(editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
    }

    public Recepie showRecipeDialog(MenuItem menuItem) {
        try {
            RecipeEntryForm editor = new RecipeEntryForm(new Recepie());
            editor.setMenuItem(menuItem);
            editor.setRecipeName(menuItem + InvMessages.getString("IVOIO.1"));
            editor.setShowOptionalButtons(false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(700, 650);
            if (dialog.isCanceled()) {
                return null;
            }
            return (Recepie)editor.getBean();
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), x.getMessage(), x);
            return null;
        }
    }

    public Recepie editRecipe(Recepie recepie) {
        try {
            RecipeEntryForm editor = new RecipeEntryForm(recepie);
            editor.setShowOptionalButtons(false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(700, 650);
            if (dialog.isCanceled()) {
                return null;
            }
            return (Recepie)editor.getBean();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
            return null;
        }
    }

    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu inventoryMenu = new JMenu(InvMessages.getString("IVOIO.2"));
        inventoryMenu.add(new InventoryItemBrowserAction());
        inventoryMenu.add(new InventoryStockEntryAction());
        inventoryMenu.add(new InventoryTransactionEntryAction());
        inventoryMenu.add(new ShoppingListAction());
        inventoryMenu.add(new PurchaseOrderExplorerAction());
        inventoryMenu.add(new StockCountExplorerAction());
        inventoryMenu.add(new InventoryVendorEntryAction());
        inventoryMenu.add(new InventoryLocationEntryAction());
        inventoryMenu.add(new InventoryUnisExplorerAction());
        inventoryMenu.add(new PackagingUnitFormAction());
        inventoryMenu.add(new InventoryPrintLabelAction());
        inventoryMenu.add(new InventoryConfigurationAction());
        inventoryMenu.add(new JSeparator());
        inventoryMenu.add(new InventoryOnHandReportAction());
        inventoryMenu.add(new InventoryTransactionReportAction());
        inventoryMenu.add(new InventoryAverageUnitCostReportAction());
        inventoryMenu.add(new InventoryOnHandReportNewAction());
        menuBar.add(inventoryMenu);
    }

    public void initAboutMenu(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu inventoryMenu = new JMenu(InvMessages.getString("IVOIO.2"));
        inventoryMenu.add((Action)new AboutPluginAction((LicenseSelectionListener)this, this.getLicense(), (Component)POSUtil.getBackOfficeWindow(), (ProductInfo)this));
        menuBar.add(inventoryMenu);
    }

    public String getId() {
        return String.valueOf(InvMessages.getString("IVOIO.3").hashCode());
    }

    public void initConfigurationView(JDialog dialog) {
    }

    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    public void restartPOS(boolean restart) {
        if (restart) {
            try {
                ProcessUtil.restart();
            }
            catch (Exception e) {
                PosLog.error(((Object)((Object)this)).getClass(), e);
            }
        }
    }

    public Component getParent() {
        return POSUtil.getFocusedWindow();
    }

    public boolean isActivated() {
        return true;
    }

    public boolean requireLicense() {
        return false;
    }

    public String getProductName() {
        return InventoryVersionInfo.getAppName();
    }

    public String getProductVersion() {
        return InventoryVersionInfo.getVersion();
    }

    public Integer getProductNumericVersion() {
        return InventoryVersionInfo.getNumericVersion();
    }

    public URL getChangeLogURL() {
        return ((Object)((Object)this)).getClass().getResource("/inv-change.log.xml");
    }

    public String getUpdateServerURL() {
        String updateUrl = TerminalConfig.getPluginUpdateServerURL("inventory");
        if (StringUtils.isEmpty((String)updateUrl)) {
            updateUrl = "https://orodev.net/update/inventory";
        }
        return updateUrl;
    }

    public int getMinParentNumericVersion() {
        return 1105;
    }

    public String getMinParentVersion() {
        return "1.4.135.55";
    }

    public boolean isEmbedded() {
        return true;
    }
}

