/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.PosException;
import com.floreantpos.model.dao.InventoryClosingBalanceDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryClosingBalanceDialog
extends OkCancelOptionDialog {
    private JComboBox<String> cbMonth;
    private JComboBox<Integer> cbYear = new JComboBox();
    private String[] months = new String[]{"Jan", "Feb", "March", "April", "May", "June", "July", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public InventoryClosingBalanceDialog() {
        this.setCaption(InvMessages.getString("IVCBA.0"));
        this.cbMonth = new JComboBox<String>(this.months);
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(new Date());
        this.populateYearData(currentDate);
        this.cbMonth.setSelectedItem(this.months[currentDate.get(2)]);
        this.cbYear.setSelectedItem(currentDate.get(1));
        JPanel inputPanel = new JPanel((LayoutManager)new MigLayout("wrap 3,fillx", "[][grow][]", ""));
        inputPanel.add(new JLabel(InvMessages.getString("IVCBD.16")));
        inputPanel.add(this.cbMonth, "growx");
        inputPanel.add(this.cbYear, "");
        this.getContentPanel().add(inputPanel);
    }

    private void populateYearData(Calendar currentDate) {
        Date transactionStartDate = InventoryClosingBalanceDAO.getInstance().getFirstInventoryTransactionDate();
        if (transactionStartDate == null) {
            transactionStartDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(transactionStartDate);
        for (int i = c.get(1); i < currentDate.get(1) + 1; ++i) {
            this.cbYear.addItem(i);
        }
        if (currentDate.get(2) == 11) {
            this.cbYear.addItem(currentDate.get(1) + 1);
        }
    }

    @Override
    public void doOk() {
        try {
            int month = this.cbMonth.getSelectedIndex();
            Calendar c = Calendar.getInstance();
            c.set(2, month);
            c.set(1, (Integer)this.cbYear.getSelectedItem());
            Date closingMonth = DateUtil.startOfMonth(c.getTime());
            c.set(2, month + 1);
            Date closingdate = DateUtil.startOfMonth(c.getTime());
            InventoryClosingBalanceDAO dao = new InventoryClosingBalanceDAO();
            dao.closeStock(closingMonth, closingdate);
            this.dispose();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVCBD.19") + new SimpleDateFormat("MMM, yyyy").format(closingMonth.getTime()) + InvMessages.getString("IVCBD.21"));
        }
        catch (PosException e) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

