/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryVendorEntryForm
extends BeanEditor<InventoryVendor> {
    private JCheckBox chkVisible;
    private FixedLengthTextField tfName;
    private JTextArea tfAddress;
    private FixedLengthTextField tfCity;
    private FixedLengthTextField tfState;
    private FixedLengthTextField tfZip;
    private FixedLengthTextField tfCountry;
    private FixedLengthTextField tfPhone;
    private FixedLengthTextField tfFax;
    private FixedLengthTextField tfEmail;
    private JList<InventoryVendorItems> listVendorItems;
    private JButton btnAdd;
    private JButton btnRemove;
    private JLabel lblNumberOfItem;
    private JButton btnBack;
    private JButton btnForward;
    private boolean checkUpdate = false;
    private List<InventoryVendorItems> removeList = new ArrayList<InventoryVendorItems>();
    private PaginatedListModel<InventoryVendorItems> model = new PaginatedListModel();

    public InventoryVendorEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    public InventoryVendorEntryForm(InventoryVendor ig) {
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(ig);
        this.vendorItemsPagination();
    }

    private void createUI() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 2"));
        TitledBorder centerBorder = BorderFactory.createTitledBorder(InvMessages.getString("IVVEF.1"));
        centerBorder.setTitleJustification(2);
        panel.setBorder(centerBorder);
        this.listVendorItems = new JList();
        this.listVendorItems.setSelectionMode(0);
        this.listVendorItems.setModel(this.model);
        this.listVendorItems.setCellRenderer(new ListCellRenderer());
        JLabel lblName = new JLabel(InvMessages.getString("IVVEF.2"));
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(60);
        this.chkVisible = new JCheckBox(InvMessages.getString("IVVEF.3"), true);
        JLabel addressLabel = new JLabel(InvMessages.getString("IVVEF.4"));
        this.tfAddress = new JTextArea(4, 4);
        this.tfAddress.setLineWrap(true);
        JLabel cityLabel = new JLabel(InvMessages.getString("IVVEF.5"));
        this.tfCity = new FixedLengthTextField();
        this.tfCity.setLength(60);
        JLabel stateLabel = new JLabel(InvMessages.getString("IVVEF.6"));
        this.tfState = new FixedLengthTextField();
        this.tfState.setLength(60);
        JLabel zipLabel = new JLabel(InvMessages.getString("IVVEF.7"));
        this.tfZip = new FixedLengthTextField();
        this.tfZip.setLength(60);
        JLabel countryLabel = new JLabel(InvMessages.getString("IVVEF.8"));
        this.tfCountry = new FixedLengthTextField();
        this.tfCountry.setLength(60);
        JLabel emailLabel = new JLabel(InvMessages.getString("IVVEF.9"));
        this.tfEmail = new FixedLengthTextField();
        this.tfEmail.setLength(60);
        JLabel phoneLabel = new JLabel(InvMessages.getString("IVVEF.10"));
        this.tfPhone = new FixedLengthTextField();
        this.tfPhone.setLength(60);
        JLabel faxLabel = new JLabel(InvMessages.getString("IVVEF.11"));
        this.tfFax = new FixedLengthTextField();
        this.tfFax.setLength(60);
        panel.add((Component)lblName, "alignx trailing");
        panel.add((Component)this.tfName, "growx,span");
        panel.add((Component)addressLabel, "alignx trailing");
        panel.add((Component)new JScrollPane(this.tfAddress), "growx");
        panel.add((Component)cityLabel, "alignx trailing");
        panel.add((Component)this.tfCity, "growx");
        panel.add((Component)stateLabel, "alignx trailing");
        panel.add((Component)this.tfState, "growx");
        panel.add((Component)zipLabel, "alignx trailing");
        panel.add((Component)this.tfZip, "growx");
        panel.add((Component)countryLabel, "alignx trailing");
        panel.add((Component)this.tfCountry, "growx");
        panel.add((Component)emailLabel, "alignx trailing");
        panel.add((Component)this.tfEmail, "growx");
        panel.add((Component)phoneLabel, "alignx trailing");
        panel.add((Component)this.tfPhone, "growx");
        panel.add((Component)faxLabel, "alignx trailing");
        panel.add((Component)this.tfFax, "growx");
        panel.add((Component)this.chkVisible, "skip 1");
        this.add((Component)panel, "West");
        JPanel rightPanel = this.rightPanel();
        this.add((Component)rightPanel, "East");
    }

    private JPanel rightPanel() {
        JPanel btnPanel = new JPanel();
        this.btnAdd = new JButton(InvMessages.getString("IVVEF.31"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorEntryForm.this.doAddMenuItem();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                    return;
                }
            }
        });
        this.btnRemove = new JButton(InvMessages.getString("IVVEF.32"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorEntryForm.this.doRemoveItem(e);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVVEF.33"));
                    return;
                }
            }
        });
        this.btnForward = new JButton(InvMessages.getString("IVVEF.34"));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (InventoryVendorEntryForm.this.checkUpdate) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVVEF.35"));
                        return;
                    }
                    InventoryVendorEntryForm.this.vendorItemsPagination(InventoryVendorEntryForm.this.model.getNextRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                    return;
                }
            }
        });
        this.btnBack = new JButton(InvMessages.getString("IVVEF.36"));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (InventoryVendorEntryForm.this.checkUpdate) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVVEF.37"));
                        return;
                    }
                    InventoryVendorEntryForm.this.vendorItemsPagination(InventoryVendorEntryForm.this.model.getPreviousRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                    return;
                }
            }
        });
        this.lblNumberOfItem = new JLabel();
        btnPanel.add(this.btnAdd);
        btnPanel.add(this.btnRemove);
        btnPanel.add(this.lblNumberOfItem);
        btnPanel.add(this.btnBack);
        btnPanel.add(this.btnForward);
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout());
        TitledBorder centerBorder = BorderFactory.createTitledBorder(InvMessages.getString("IVVEF.38"));
        centerBorder.setTitleJustification(2);
        rightPanel.setBorder(centerBorder);
        JScrollPane pane = new JScrollPane(this.listVendorItems, 20, 30);
        pane.setPreferredSize(PosUIManager.getSize(400, 800));
        rightPanel.setPreferredSize(PosUIManager.getSize(350, 190));
        rightPanel.add((Component)pane, "grow,wrap");
        rightPanel.add((Component)btnPanel, "center");
        return rightPanel;
    }

    private void vendorItemsPagination() {
        this.vendorItemsPagination(0);
    }

    private void vendorItemsPagination(int items) {
        int totalNumber;
        this.model.setCurrentRowIndex(items);
        InventoryVendor vendor = (InventoryVendor)this.getBean();
        if (vendor != null && vendor.getId() != null) {
            InventoryVendorItemsDAO.getInstance().loadVendorItems(this.model, vendor);
        }
        int startNumber = this.model.getCurrentRowIndex() + 1;
        int endNumber = this.model.getNextRowIndex();
        if (endNumber > (totalNumber = this.model.getNumRows())) {
            endNumber = totalNumber;
        }
        if (this.model.getNumRows() == 0) {
            startNumber = 0;
        }
        if (vendor.getId() == null) {
            startNumber = 0;
            endNumber = 0;
            totalNumber = 0;
            this.btnBack.setEnabled(false);
            this.btnForward.setEnabled(false);
        }
        String text = String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber);
        this.lblNumberOfItem.setText(text);
        if (vendor.getId() != null) {
            this.btnBack.setEnabled(this.model.hasPrevious());
            this.btnForward.setEnabled(this.model.hasNext());
        }
    }

    private List<MenuItem> openMenuItemSelectionWindow() {
        MenuItemSelectionDialog dialog = MenuItemSelectionDialog.getInstance();
        dialog.setSelectionMode(1);
        dialog.setSize(PosUIManager.getSize(800, 600));
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        List<MenuItem> selectedItems = dialog.getSelectedItems();
        return selectedItems;
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfState.setEnabled(enable);
        this.tfZip.setEnabled(enable);
        this.tfCountry.setEnabled(enable);
        this.tfEmail.setEnabled(enable);
        this.tfPhone.setEnabled(enable);
        this.tfFax.setEnabled(enable);
        this.chkVisible.setEnabled(enable);
        this.btnAdd.setEnabled(enable);
        this.btnRemove.setEnabled(enable);
        this.listVendorItems.setEnabled(enable);
    }

    @Override
    public void cancel() {
        this.updateView();
        this.checkUpdate = false;
    }

    @Override
    public void updateView() {
        InventoryVendor vendor = (InventoryVendor)this.getBean();
        if (vendor == null) {
            return;
        }
        this.displayVendorItems(vendor);
        this.vendorItemsPagination(this.model.getPreviousRowIndex());
        this.tfName.setText(vendor.getName());
        this.tfAddress.setText(vendor.getAddress());
        this.tfCity.setText(vendor.getCity());
        this.tfCountry.setText(vendor.getCountry());
        this.tfFax.setText(vendor.getFax());
        this.tfPhone.setText(vendor.getPhone());
        this.tfState.setText(vendor.getState());
        this.tfZip.setText(vendor.getZip());
        this.tfEmail.setText(vendor.getEmail());
        if (vendor.getId() != null) {
            this.chkVisible.setSelected(POSUtil.getBoolean(vendor.isVisible()));
        }
    }

    @Override
    public void createNew() {
        this.setBean(new InventoryVendor());
        this.clearFields();
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfAddress.setText("");
        this.tfCity.setText("");
        this.tfCountry.setText("");
        this.tfFax.setText("");
        this.tfPhone.setText("");
        this.tfState.setText("");
        this.tfZip.setText("");
        this.tfEmail.setText("");
        this.chkVisible.setSelected(false);
    }

    @Override
    public boolean updateModel() {
        List<InventoryVendor> existingVendorsWithSameName;
        InventoryVendor model = (InventoryVendor)this.getBean();
        String nameString = this.tfName.getText();
        String addressString = this.tfAddress.getText();
        String cityString = this.tfCity.getText();
        String stateString = this.tfState.getText();
        String zipString = this.tfZip.getText();
        String countryString = this.tfCountry.getText();
        String emailString = this.tfEmail.getText();
        String phoneString = this.tfPhone.getText();
        String faxString = this.tfFax.getText();
        if (StringUtils.isEmpty((String)nameString)) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVVEF.51"));
            return false;
        }
        if (StringUtils.isEmpty((String)model.getId()) && (existingVendorsWithSameName = InventoryVendorDAO.getInstance().findByName(nameString)) != null && !existingVendorsWithSameName.isEmpty()) {
            String message = InvMessages.getString("InventoryVendorEntryForm.0");
            String title = InvMessages.getString("InventoryVendorEntryForm.1");
            int responseCode = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title);
            if (responseCode != 0) {
                return false;
            }
        }
        model.setName(nameString);
        model.setAddress(addressString);
        model.setCity(cityString);
        model.setState(stateString);
        model.setZip(zipString);
        model.setCountry(countryString);
        model.setEmail(emailString);
        model.setPhone(phoneString);
        model.setFax(faxString);
        model.setVisible(this.chkVisible.isSelected());
        return true;
    }

    @Override
    public String getDisplayText() {
        return InvMessages.getString("IVVEF.52");
    }

    @Override
    public boolean delete() {
        try {
            InventoryVendor inventoryVendor = (InventoryVendor)this.getBean();
            if (inventoryVendor == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("IVVEF.53"), InvMessages.getString("IVVEF.54"));
            if (option != 0) {
                return false;
            }
            InventoryVendorDAO.getInstance().delete(inventoryVendor);
            this.clearFields();
            this.displayVendorItems(inventoryVendor);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryVendor bean = (InventoryVendor)this.getBean();
            Matcher matcher = this.emailValidation(bean);
            if (!StringUtils.isEmpty((String)this.tfEmail.getText()) && !matcher.matches()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVVEF.55"));
                return false;
            }
            InventoryVendorDAO.getInstance().saveOrUpdate(bean);
            for (int i = 0; i < this.model.getSize(); ++i) {
                InventoryVendorItems vendorItem = (InventoryVendorItems)this.model.getElementAt(i);
                InventoryVendorItemsDAO.getInstance().saveOrUpdate(vendorItem);
                this.checkUpdate = false;
            }
            if (this.removeList != null) {
                Iterator<InventoryVendorItems> iterator = this.removeList.iterator();
                while (iterator.hasNext()) {
                    InventoryVendorItems inventoryVendorItems = iterator.next();
                    InventoryVendorItemsDAO.getInstance().delete(inventoryVendorItems);
                    iterator.remove();
                }
            }
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    private Matcher emailValidation(InventoryVendor bean) {
        String regex = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
        String email = bean.getEmail();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(email);
        return matcher;
    }

    public void displayVendorItems(InventoryVendor vendor) {
        block3: {
            try {
                List<InventoryVendorItems> vendorItems = InventoryVendorItemsDAO.getInstance().findByVendor(vendor);
                this.model.getDataList().clear();
                if (vendorItems == null) break block3;
                for (InventoryVendorItems inventoryVendorItem : vendorItems) {
                    if (inventoryVendorItem.getItem() == null || inventoryVendorItem.getId() == null) continue;
                    this.model.addElement(inventoryVendorItem);
                    if (this.model.getSize() != 10) continue;
                    break;
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            }
        }
    }

    private void doAddMenuItem() {
        List<MenuItem> selectedMenuItems = this.openMenuItemSelectionWindow();
        if (selectedMenuItems == null) {
            return;
        }
        InventoryVendor vendor = (InventoryVendor)this.getBean();
        InventoryVendorItems vendorItems = null;
        ArrayList<MenuItem> alreadyAddedItems = new ArrayList<MenuItem>();
        for (int i = 0; i < this.listVendorItems.getModel().getSize(); ++i) {
            InventoryVendorItems inventoryVendorItems = this.listVendorItems.getModel().getElementAt(i);
            MenuItem modelsMenuItem = inventoryVendorItems.getItem();
            for (MenuItem listOfMenuItem : selectedMenuItems) {
                if (!modelsMenuItem.getName().equals(listOfMenuItem.getName())) continue;
                alreadyAddedItems.add(listOfMenuItem);
            }
        }
        if (vendor.getId() != null) {
            for (MenuItem selectedMenuItem : selectedMenuItems) {
                vendorItems = InventoryVendorItemsDAO.getInstance().findByItemAndVendor(selectedMenuItem, vendor);
                if (vendorItems == null) continue;
                alreadyAddedItems.add(selectedMenuItem);
            }
        }
        ArrayList<MenuItem> allMenuItems = new ArrayList<MenuItem>(selectedMenuItems);
        allMenuItems.addAll(alreadyAddedItems);
        ArrayList<MenuItem> subtractDuplicateItems = new ArrayList<MenuItem>(selectedMenuItems);
        subtractDuplicateItems.retainAll(alreadyAddedItems);
        allMenuItems.removeAll(subtractDuplicateItems);
        if (allMenuItems != null) {
            for (MenuItem uniqueItem : allMenuItems) {
                vendorItems = new InventoryVendorItems();
                vendorItems.setItem(uniqueItem);
                vendorItems.setVendor(vendor);
                this.model.addElement(vendorItems);
                this.checkUpdate = true;
            }
        }
    }

    private void doRemoveItem(ActionEvent e) {
        int selectedIndex = this.listVendorItems.getSelectedIndex();
        if (selectedIndex < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVVEF.57"));
            return;
        }
        if (selectedIndex != -1) {
            InventoryVendorItems vendorItems = (InventoryVendorItems)this.model.getElementAt(selectedIndex);
            this.model.remove(selectedIndex);
            this.listVendorItems.setSelectedIndex(-1);
            this.checkUpdate = true;
            if (vendorItems.getId() != null) {
                this.removeList.add(vendorItems);
            }
        }
    }

    public class ListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            JLabel label = null;
            if (value instanceof InventoryVendorItems) {
                InventoryVendorItems inventoryVendorItems = (InventoryVendorItems)value;
                label = (JLabel)c;
                MenuItem menuItem = inventoryVendorItems.getItem();
                if (menuItem != null && menuItem.getId() != null) {
                    label.setText(menuItem.getName());
                    return label;
                }
            }
            return c;
        }
    }
}

