/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui;

import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.dao.InventoryDAO;
import com.orostock.inventory.ui.InventoryVendorEntryForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class InventoryVendorsBrowser
extends ModelBrowser<InventoryVendor> {
    private int selectedRow = -1;
    private BeanTableModel<InventoryVendor> tableModel = new BeanTableModel(InventoryVendor.class);
    private JButton btnNext;
    private JLabel lblTextDisplay;
    private JButton btnPrev;
    private JTextField tfName;

    public InventoryVendorsBrowser() {
        super(new InventoryVendorEntryForm(new InventoryVendor()));
        this.tableModel.addColumn(InvMessages.getString("IVVB.0"), InventoryVendor.PROP_NAME);
        this.tableModel.setPageSize(20);
        this.init(this.tableModel);
        JScrollPane pane = new JScrollPane((Component)this.browserTable, 20, 30);
        this.browserPanel.add(pane);
        this.beanPanel.setBorder(BorderFactory.createTitledBorder(InvMessages.getString("IVVB.1")));
        JPanel vendorListPanel = new JPanel(new BorderLayout());
        vendorListPanel.setBorder(BorderFactory.createTitledBorder(InvMessages.getString("IVVB.2")));
        vendorListPanel.add((Component)this.buildSearchPanel(), "North");
        vendorListPanel.add((Component)this.browserPanel, "Center");
        vendorListPanel.add((Component)this.builPaginationPanel(), "South");
        this.add((Component)vendorListPanel, "West");
        this.add(this.beanPanel);
        this.refreshTable();
        this.displayVendor();
    }

    private JPanel builPaginationPanel() {
        JPanel panel = new JPanel();
        this.btnPrev = new JButton(InvMessages.getString("IVVB.3"));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorsBrowser.this.displayVendor(InventoryVendorsBrowser.this.tableModel.getPreviousRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        this.btnNext = new JButton(InvMessages.getString("IVVB.4"));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorsBrowser.this.displayVendor(InventoryVendorsBrowser.this.tableModel.getNextRowIndex());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        this.lblTextDisplay = new JLabel();
        panel.add(this.lblTextDisplay);
        panel.add(this.btnPrev);
        panel.add(this.btnNext);
        return panel;
    }

    private JPanel buildSearchPanel() {
        JLabel lblName = new JLabel(InvMessages.getString("IVVB.5"));
        this.tfName = new JTextField();
        this.tfName.addKeyListener(this.typeListener());
        this.tfName.addActionListener(this.pressEnter());
        JButton searchButton = new JButton(InvMessages.getString("IVIS.22"));
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorsBrowser.this.displayVendor();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        searchPanel.setBorder(BorderFactory.createTitledBorder(InvMessages.getString("IVVB.8")));
        searchPanel.add((Component)lblName, "align label,split 3");
        searchPanel.add((Component)this.tfName, "grow");
        searchPanel.add(searchButton);
        return searchPanel;
    }

    private Action pressEnter() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InventoryVendorsBrowser.this.displayVendor();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        };
        return action;
    }

    private KeyAdapter typeListener() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String searchItem = InventoryVendorsBrowser.this.tfName.getText();
                if (StringUtils.isNotEmpty((String)searchItem) && searchItem.length() > 3) {
                    try {
                        InventoryVendorsBrowser.this.displayVendor();
                    }
                    catch (Exception exception) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                    }
                }
            }
        };
    }

    private void displayVendor() {
        this.displayVendor(0);
    }

    private void displayVendor(int rowIndex) {
        this.tableModel.setCurrentRowIndex(rowIndex);
        String txName = this.tfName.getText();
        InventoryDAO.getInstance().loadVendors(this.tableModel, txName);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        String text = "<html><center>" + String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber + "</center></html>");
        this.lblTextDisplay.setText(text);
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
    }

    @Override
    public void refreshTable() {
        List<InventoryVendor> locations = InventoryVendorDAO.getInstance().findAll();
        BeanTableModel tableModel = (BeanTableModel)this.browserTable.getModel();
        this.browserTable.getColumn(0).setPreferredWidth(PosUIManager.getSize(300));
        tableModel.removeAll();
        tableModel.addRows(locations);
        this.browserTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InventoryVendorsBrowser.this.selectedRow = e.getFirstIndex();
            }
        });
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (InventoryVendorsBrowser.this.selectedRow >= 0) {
                            // empty if block
                        }
                    }
                });
            }
        });
    }
}

