/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeItemTable;
import com.orostock.inventory.ui.recepie.RecipeSelectionDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class RecipeEntryForm
extends BeanEditor<Recepie>
implements ChangeListener {
    private RecipeItemTable table;
    private JButton btnAddItem = new JButton(InvMessages.getString("IVREF.0"));
    private JButton btnDeleteItem = new JButton(InvMessages.getString("IVREF.1"));
    private DoubleTextField tfTotalCost;
    private FixedLengthTextField tfRecepieName = new FixedLengthTextField();
    private FixedLengthTextField tfCode = new FixedLengthTextField();
    private DoubleTextField tfPortion = new DoubleTextField(6);
    private DoubleTextField tfCookingMinute = new DoubleTextField(4);
    private DoubleTextField tfYield = new DoubleTextField(6);
    private JTextArea taInstruction = new JTextArea(4, 4);
    private JRadioButton rbBatchProcess = new JRadioButton(InvMessages.getString("IVREF.2"));
    private JRadioButton rbContinuousProcess = new JRadioButton(InvMessages.getString("IVREF.3"));
    private DoubleTextField tfAdjustment = new DoubleTextField(8);
    private DoubleTextField tfLaborCost = new DoubleTextField(8);
    private JComboBox cbPortionUnits = new JComboBox();
    private JComboBox cbYieldUnits = new JComboBox();
    private FixedLengthTextField tfMenuItemName = new FixedLengthTextField();
    private MenuItem selectedMenuItem;
    private JButton btnAddMenuItem;
    private JButton btnSelectFromExistingRecipe;

    public RecipeEntryForm(Recepie recepie) {
        this.initComponents();
        this.cbYieldUnits.setModel(new ComboBoxModel());
        this.cbYieldUnits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IUnit unit = (IUnit)RecipeEntryForm.this.cbYieldUnits.getSelectedItem();
                if (unit != null) {
                    if (unit instanceof InventoryStockUnit) {
                        InventoryStockUnit stockUnit = (InventoryStockUnit)unit;
                        RecipeEntryForm.this.tfPortion.setText(String.valueOf(stockUnit.getConversionValue()));
                    } else {
                        RecipeEntryForm.this.tfPortion.setText("1");
                    }
                }
            }
        });
        this.cbPortionUnits.setModel(new ComboBoxModel());
        this.setBean(recepie);
    }

    private void renderUnits() {
        if (this.selectedMenuItem != null) {
            MenuItemDAO.getInstance().initialize(this.selectedMenuItem);
            ArrayList<InventoryUnit> itemUnits = new ArrayList<InventoryUnit>();
            itemUnits.add(this.selectedMenuItem.getUnit());
            ArrayList<TimedModel> yieldUnits = new ArrayList<TimedModel>();
            yieldUnits.add(this.selectedMenuItem.getUnit());
            if (this.selectedMenuItem.getStockUnits() != null) {
                yieldUnits.addAll(this.selectedMenuItem.getStockUnits());
            }
            ComboBoxModel yieldModel = (ComboBoxModel)this.cbYieldUnits.getModel();
            yieldModel.setDataList(yieldUnits);
            ComboBoxModel portionModel = (ComboBoxModel)this.cbPortionUnits.getModel();
            portionModel.setDataList(itemUnits);
            this.cbPortionUnits.setSelectedIndex(0);
            this.cbYieldUnits.setSelectedIndex(0);
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        this.selectedMenuItem = menuItem;
        this.tfMenuItemName.setText(this.selectedMenuItem.getName());
        this.renderUnits();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 2", "[][grow]", ""));
        JLabel lblRecipeTableName = new JLabel(InvMessages.getString("IVREF.8"));
        this.tfMenuItemName.setLength(128);
        this.tfMenuItemName.setEditable(false);
        topPanel.add((Component)lblRecipeTableName, "");
        topPanel.add((Component)this.tfMenuItemName, "growx,split 2");
        this.btnAddMenuItem = new JButton(InvMessages.getString("IVREF.11"));
        this.btnAddItem.setVisible(true);
        this.btnAddMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
                dialog.setSelectionMode(0);
                dialog.setSize(PosUIManager.getSize(600, 515));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                RecipeEntryForm.this.setMenuItem(dialog.getSelectedRowData());
            }
        });
        topPanel.add((Component)this.btnAddMenuItem, "");
        JLabel lblRecepieName = new JLabel(InvMessages.getString("IVREF.13"));
        this.tfRecepieName.setLength(128);
        this.tfCode.setLength(16);
        topPanel.add((Component)new JLabel(InvMessages.getString("IVREF.14")), "");
        topPanel.add((Component)this.tfCode, "growx,wrap");
        topPanel.add((Component)lblRecepieName, "");
        topPanel.add((Component)this.tfRecepieName, "growx,split 2");
        this.btnSelectFromExistingRecipe = new JButton(InvMessages.getString("IVREF.19"));
        this.btnSelectFromExistingRecipe.setVisible(true);
        this.btnSelectFromExistingRecipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RecipeEntryForm.this.selectedMenuItem == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVREF.20"));
                    return;
                }
                ArrayList<Recepie> recipes = new ArrayList<Recepie>();
                RecipeSelectionDialog dialog = new RecipeSelectionDialog(recipes, false);
                dialog.setSelectionMode(0);
                dialog.setSize(PosUIManager.getSize(600, 515));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                try {
                    Recepie recipe = (Recepie)CopyUtil.deepCopy(dialog.getSelectedRowData());
                    recipe.setId(null);
                    recipe.setMenuItem(RecipeEntryForm.this.selectedMenuItem);
                    List<RecepieItem> recepieItems = recipe.getRecepieItems();
                    if (recepieItems != null) {
                        for (RecepieItem item : recepieItems) {
                            item.setId(null);
                            item.setRecepie(recipe);
                        }
                    }
                    recipe.setPortion(1.0);
                    RecipeEntryForm.this.setBean(recipe);
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(e1.getMessage());
                }
            }
        });
        topPanel.add((Component)this.btnSelectFromExistingRecipe, "wrap");
        topPanel.add((Component)new JLabel(InvMessages.getString("IVREF.22")), "right");
        topPanel.add((Component)this.tfYield, "split 5");
        topPanel.add(this.cbYieldUnits);
        this.tfYield.setEditable(false);
        topPanel.add(new JLabel(InvMessages.getString("IVREF.25")));
        this.tfPortion.setEditable(false);
        topPanel.add(this.tfPortion);
        topPanel.add(this.cbPortionUnits);
        topPanel.add((Component)new JLabel(InvMessages.getString("IVREF.26")), "right");
        topPanel.add((Component)new JScrollPane(this.taInstruction), "growx");
        JPanel timePanel = new JPanel((LayoutManager)new MigLayout("left"));
        timePanel.setBorder(new TitledBorder(InvMessages.getString("IVREF.30")));
        timePanel.add((Component)this.rbBatchProcess, "split 2");
        timePanel.add(this.rbContinuousProcess);
        timePanel.add((Component)new JLabel(InvMessages.getString("IVREF.32")), "gapleft 20,split 3");
        timePanel.add(this.tfCookingMinute);
        timePanel.add(new JLabel(InvMessages.getString("IVREF.34")));
        topPanel.add((Component)timePanel, "skip 1,growx");
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbBatchProcess);
        group.add(this.rbContinuousProcess);
        this.rbBatchProcess.setSelected(true);
        this.tfPortion.setHorizontalAlignment(4);
        this.tfYield.setHorizontalAlignment(4);
        this.taInstruction.setLineWrap(true);
        this.add((Component)topPanel, "North");
        this.table = new RecipeItemTable(new ArrayList<RecepieItem>());
        this.table.setValueChangeListener(this);
        JPanel recipeItemPanel = new JPanel(new BorderLayout());
        recipeItemPanel.add(new JScrollPane(this.table));
        JPanel buttonPanel1 = new JPanel((LayoutManager)new MigLayout("fillx,ins 5 5 5 0", "[][grow]", ""));
        buttonPanel1.add((Component)this.btnAddItem, "split 2");
        buttonPanel1.add(this.btnDeleteItem);
        JLabel lblCost = new JLabel(InvMessages.getString("IVREF.40"));
        this.tfTotalCost = new DoubleTextField(8);
        this.tfTotalCost.setEditable(false);
        this.tfTotalCost.setHorizontalAlignment(4);
        recipeItemPanel.add((Component)buttonPanel1, "South");
        buttonPanel1.add((Component)new JLabel(InvMessages.getString("IVREF.41")), "split 2,span,right");
        buttonPanel1.add((Component)this.tfLaborCost, "wrap");
        buttonPanel1.add((Component)new JLabel(InvMessages.getString("IVREF.44")), "split 2,span,right");
        buttonPanel1.add((Component)this.tfAdjustment, "wrap");
        this.tfLaborCost.setHorizontalAlignment(4);
        this.tfAdjustment.setHorizontalAlignment(4);
        this.tfAdjustment.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RecipeEntryForm.this.stateChanged(null);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        buttonPanel1.add((Component)lblCost, "split 2,span,right");
        buttonPanel1.add(this.tfTotalCost);
        JPanel container = new JPanel((LayoutManager)new MigLayout("fillx,wrap 1", "", "[grow]"));
        container.add((Component)recipeItemPanel, "grow");
        this.add(container);
        this.btnAddItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeEntryForm.this.addInventoryItem();
            }
        });
        this.btnDeleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int selectedRow = RecipeEntryForm.this.table.getSelectedRow();
                    if (selectedRow < 0) {
                        return;
                    }
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    RecipeEntryForm.this.table.removeItem(selectedRow);
                    RecipeEntryForm.this.stateChanged(null);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
    }

    protected void addInventoryItem() {
        HashMap<String, RecepieItem> itemMap = new HashMap<String, RecepieItem>();
        ArrayList<MenuItem> inventoryItems = new ArrayList<MenuItem>();
        Collection<? extends RecepieItem> rows = this.table.getRows();
        if (rows != null) {
            for (RecepieItem recepieItem : rows) {
                inventoryItems.add(recepieItem.getInventoryItem());
                itemMap.put(recepieItem.getInventoryItem().getId(), recepieItem);
            }
        }
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(inventoryItems, true);
        dialog.setSize(600, 500);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        List<MenuItem> list = dialog.getSelectedItems();
        if (list != null) {
            for (MenuItem menuItem : list) {
                if (menuItem.equals(this.selectedMenuItem)) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), InvMessages.getString("IVREF.52"));
                    return;
                }
                RecepieItem recepieItem = (RecepieItem)itemMap.get(menuItem.getId());
                if (recepieItem != null) continue;
                MenuItemDAO.getInstance().initialize(menuItem);
                recepieItem = new RecepieItem();
                recepieItem.setInventoryItem(menuItem);
                recepieItem.setQuantity(1.0);
                InventoryUnit unit = menuItem.getUnit();
                recepieItem.setUnit(unit);
                if (unit != null) {
                    recepieItem.setUnitCode(unit.getCode());
                }
                itemMap.put(menuItem.getId(), recepieItem);
            }
        }
        this.table.setItems(new ArrayList<RecepieItem>(itemMap.values()));
        this.stateChanged(null);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Recepie bean = (Recepie)this.getBean();
            Recepie existingRecipe = RecepieDAO.getInstance().findByName(bean.getName(), bean.getId());
            if (existingRecipe != null && existingRecipe.isDeleted().booleanValue()) {
                bean.setId(existingRecipe.getId());
                bean.setVersion(existingRecipe.getVersion());
            }
            RecepieDAO.getInstance().saveOrUpdate(bean);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    protected void updateView() {
        ComboBoxModel model;
        String portionUnit;
        ComboBoxModel model2;
        Recepie bean = (Recepie)this.getBean();
        if (bean == null) {
            this.tfPortion.setText("1.00");
            this.tfYield.setText("1.00");
            this.tfTotalCost.setText("0.00");
            return;
        }
        List<RecepieItem> recepieItems = bean.getRecepieItems();
        if (recepieItems != null) {
            for (RecepieItem recepieItem : recepieItems) {
                MenuItemDAO.getInstance().initialize(recepieItem.getInventoryItem());
            }
        }
        this.tfMenuItemName.setText(this.selectedMenuItem == null ? "" : bean.getName());
        this.tfCode.setText(bean.getCode());
        this.tfRecepieName.setText(bean.getName());
        this.selectedMenuItem = bean.getMenuItem();
        this.renderUnits();
        if (this.selectedMenuItem != null) {
            this.table.setParentMenuItem(this.selectedMenuItem);
            this.tfMenuItemName.setText(this.selectedMenuItem.getDisplayName());
        }
        this.tfPortion.setText(String.valueOf(bean.getPortion()));
        this.tfYield.setText(String.valueOf(bean.getYield()));
        this.taInstruction.setText(bean.getDescription());
        this.tfAdjustment.setText(NumberUtil.formatNumber(bean.getAdjustmentAmount()));
        this.tfLaborCost.setText(NumberUtil.formatNumber(bean.getLaborCost()));
        this.rbContinuousProcess.setSelected(bean.isBatchProcess() == false);
        this.rbBatchProcess.setSelected(bean.isBatchProcess());
        String yieldUnit = bean.getYieldUnit();
        if (StringUtils.isNotEmpty((String)yieldUnit) && (model2 = (ComboBoxModel)this.cbYieldUnits.getModel()).getSize() > 0) {
            for (IUnit packagingUnit : model2.getDataList()) {
                if (packagingUnit == null || !packagingUnit.getUniqueCode().equals(yieldUnit)) continue;
                this.cbYieldUnits.setSelectedItem(packagingUnit);
            }
        }
        if (StringUtils.isNotEmpty((String)(portionUnit = bean.getPortionUnit())) && (model = (ComboBoxModel)this.cbPortionUnits.getModel()).getSize() > 0) {
            for (IUnit packagingUnit : model.getDataList()) {
                if (packagingUnit == null || !packagingUnit.getUniqueCode().equals(portionUnit)) continue;
                this.cbPortionUnits.setSelectedItem(packagingUnit);
            }
        }
        this.setTimeFieldsValue(bean.getCookingTime());
        this.table.setItems(recepieItems);
        this.stateChanged(null);
    }

    public void setTimeFieldsValue(int timeInSeconds) {
        int hours = timeInSeconds / 3600;
        int secondsLeft = timeInSeconds - hours * 3600;
        int minutes = secondsLeft / 60;
        this.tfCookingMinute.setText(String.valueOf(minutes));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Recepie bean = (Recepie)this.getBean();
        String name = this.tfRecepieName.getText();
        if (this.selectedMenuItem == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVREF.56"));
            return false;
        }
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVREF.57"));
            return false;
        }
        if (this.table.getRowCount() <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVREF.58"));
            return false;
        }
        bean.setCode(this.tfCode.getText());
        bean.setName(name);
        bean.setPortion(this.tfPortion.getDoubleOrZero());
        bean.setYield(this.tfYield.getDoubleOrZero());
        bean.setDescription(this.taInstruction.getText());
        ArrayList<RecepieItem> rows = new ArrayList<RecepieItem>(this.table.getRows());
        for (RecepieItem recepieItem : rows) {
            recepieItem.setRecepie(bean);
        }
        int seconds = (int)(this.tfCookingMinute.getDoubleOrZero() * 60.0);
        bean.setCookingTime(seconds);
        bean.setRecepieItems(rows);
        bean.setBatchProcess(this.rbBatchProcess.isSelected());
        bean.setAdjustmentAmount(this.tfAdjustment.getDoubleOrZero());
        bean.setLaborCost(this.tfLaborCost.getDoubleOrZero());
        bean.setMenuItem(this.selectedMenuItem);
        IUnit yieldUnit = (IUnit)this.cbYieldUnits.getSelectedItem();
        if (yieldUnit != null) {
            bean.setYieldUnit(yieldUnit.getUniqueCode());
        } else {
            bean.setYieldUnit(null);
        }
        IUnit portionUnit = (IUnit)this.cbPortionUnits.getSelectedItem();
        if (portionUnit != null) {
            bean.setPortionUnit(portionUnit.getUniqueCode());
        } else {
            bean.setPortionUnit(null);
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return ((Recepie)this.getBean()).getId() == null ? InvMessages.getString("IVREF.59") : InvMessages.getString("IVREF.60");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        double totalRecipeItemCost = 0.0;
        Collection<? extends RecepieItem> rows = this.table.getRows();
        if (rows != null) {
            for (RecepieItem recepieItem : rows) {
                recepieItem.calculatePercentage();
                totalRecipeItemCost += recepieItem.getCost();
            }
        }
        this.tfTotalCost.setText(NumberUtil.formatNumber(totalRecipeItemCost + this.tfAdjustment.getDoubleOrZero()));
    }

    public void setRecipeName(String recipeName) {
        this.tfRecepieName.setText(recipeName);
    }

    public void setShowOptionalButtons(boolean invisible) {
        this.btnSelectFromExistingRecipe.setVisible(invisible);
        this.btnAddMenuItem.setVisible(invisible);
    }
}

