/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTable;

public class RecipeItemExplorer
extends TransparentPanel {
    private MenuItemExplorerTable menuItemExplorerTable;
    private BeanTableModel<MenuItem> tableModel;
    private JTextField tfName;
    private JLabel lblItem;
    private JComboBox<Object> cbItem;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox<Object> cbGroup;
    private boolean variant;

    public RecipeItemExplorer() {
        this(false);
    }

    public RecipeItemExplorer(boolean variant) {
        this.variant = variant;
        this.init();
        this.showMenuItems();
    }

    private void init() {
        this.tableModel = new BeanTableModel(MenuItem.class, 20);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "displayName");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME.toUpperCase(), "translatedName");
        this.tableModel.addColumn(InvMessages.getString("RecipeItemExplorer.0"), "barcode");
        this.tableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.tableModel.addColumn(InvMessages.getString("MenuItemExplorer.14"), "availableUnit");
        this.tableModel.addColumn(InvMessages.getString("MenuItemExplorer.26"), "unitOnHand");
        this.tableModel.addColumn(POSConstants.VISIBLE.toUpperCase(), "visible");
        this.tableModel.addColumn(InvMessages.getString("RecipeItemExplorer.1"), "taxGroup");
        this.tableModel.addColumn(InvMessages.getString("MenuItemExplorer.21"), "sortOrder", BeanTableModel.EditMode.EDITABLE);
        this.tableModel.addColumn(InvMessages.getString("MenuItemExplorer.23"), "buttonColor");
        this.tableModel.addColumn(InvMessages.getString("MenuItemExplorer.25"), "textColor");
        this.tableModel.addColumn(POSConstants.IMAGE.toUpperCase(), "image");
        this.btnBack = new JButton("<<< " + InvMessages.getString("RecipeItemExplorer.4"));
        this.btnForward = new JButton(InvMessages.getString("RecipeItemExplorer.5") + ">>>");
        this.lblNumberOfItem = new JLabel();
        this.menuItemExplorerTable = new MenuItemExplorerTable(this.tableModel);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setSelectionMode(0);
        this.menuItemExplorerTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        IntegerTextField tfEditField = new IntegerTextField();
        tfEditField.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.menuItemExplorerTable.setDefaultEditor(this.menuItemExplorerTable.getColumnClass(8), editor);
        this.menuItemExplorerTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemExplorerTable.setRowHeight(PosUIManager.getSize(30));
        this.menuItemExplorerTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    RecipeItemExplorer.this.editSelectedRow();
                }
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.tableModel.setCurrentRowIndex(RecipeItemExplorer.this.tableModel.getPreviousRowIndex());
                RecipeItemExplorer.this.showMenuItems();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.tableModel.setCurrentRowIndex(RecipeItemExplorer.this.tableModel.getNextRowIndex());
                RecipeItemExplorer.this.showMenuItems();
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)((Object)this.menuItemExplorerTable)));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)((Object)this.menuItemExplorerTable));
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        JLabel lblName = new JLabel(InvMessages.getString("MenuItemExplorer.0"));
        JLabel lblGroup = new JLabel(InvMessages.getString("MenuItemExplorer.1"));
        this.cbGroup = new JComboBox();
        this.cbGroup.addItem(InvMessages.getString("MenuItemExplorer.5"));
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup group : groups) {
            this.cbGroup.addItem(group);
        }
        this.tfName = new JTextField(15);
        this.lblItem = new JLabel(InvMessages.getString("MenuItemExplorer.13"));
        this.cbItem = new JComboBox();
        try {
            this.cbItem.addItem(InvMessages.getString("MenuItemExplorer.2"));
            this.cbItem.addItem("InventoryItem");
            JButton searchBttn = new JButton("");
            panel.add((Component)lblName, "align label");
            panel.add(this.tfName);
            panel.add(lblGroup);
            panel.add(this.cbGroup);
            panel.add(this.lblItem);
            panel.add(this.cbItem);
            panel.add(searchBttn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, "");
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBttn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecipeItemExplorer.this.showMenuItems();
                }
            });
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RecipeItemExplorer.this.showMenuItems();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showMenuItems() {
        String txName = this.tfName.getText();
        Boolean showAll = this.cbItem.getSelectedIndex() == 0;
        Object selectedGroup = this.cbGroup.getSelectedItem();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        this.tableModel.setNumRows(MenuItemDAO.getInstance().rowCount(showAll, group, txName, null, this.variant, false));
        MenuItemDAO.getInstance().loadMenuItems(this.tableModel, showAll, group, txName, null, this.variant, false);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(InvMessages.getString("RecipeItemExplorer.8"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    private JPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.setText(InvMessages.getString("MenuItemExplorer.17"));
        editButton.setText(InvMessages.getString("MenuItemExplorer.18"));
        deleteButton.setText(InvMessages.getString("MenuItemExplorer.19"));
        JButton updateStockAmount = new JButton(InvMessages.getString("RecipeItemExplorer.9"));
        updateStockAmount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doUpdateStockAmount();
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.editSelectedRow();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doCreateNewMenuItem();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doDeleteMenuItem();
            }
        });
        JButton btnDuplicate = new JButton(InvMessages.getString("RecipeItemExplorer.10"));
        btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = RecipeItemExplorer.this.menuItemExplorerTable.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = RecipeItemExplorer.this.menuItemExplorerTable.convertRowIndexToModel(index);
                    MenuItem existingMenuItem = (MenuItem)RecipeItemExplorer.this.tableModel.getRow(index);
                    MenuItemDAO.getInstance().initialize(existingMenuItem);
                    MenuItem newMenuItem = existingMenuItem.clone();
                    MenuItemForm editor = new MenuItemForm(newMenuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(900, 600);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuItem menuItem = (MenuItem)editor.getBean();
                    RecipeItemExplorer.this.tableModel.addRow(menuItem);
                    RecipeItemExplorer.this.menuItemExplorerTable.getSelectionModel().addSelectionInterval(RecipeItemExplorer.this.tableModel.getRowCount() - 1, RecipeItemExplorer.this.tableModel.getRowCount() - 1);
                    RecipeItemExplorer.this.menuItemExplorerTable.scrollRowToVisible(RecipeItemExplorer.this.tableModel.getRowCount() - 1);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        if (!this.variant) {
            actionButtonPanel.add(addButton);
        }
        actionButtonPanel.add(editButton);
        actionButtonPanel.add(updateStockAmount);
        if (!this.variant) {
            actionButtonPanel.add(deleteButton);
            actionButtonPanel.add(btnDuplicate);
        }
        this.addInventoryButtonActions(actionButtonPanel);
        bottomPanel.add((Component)actionButtonPanel, "");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        bottomPanel.add((Component)navigationPanel, "grow");
        return bottomPanel;
    }

    private void addInventoryButtonActions(JPanel panel) {
        JButton inTransactionButton = new JButton(InvMessages.getString("RecipeItemExplorer.15"));
        JButton outTransactionButton = new JButton(InvMessages.getString("RecipeItemExplorer.16"));
        JButton transferTransactionButton = new JButton(InvMessages.getString("RecipeItemExplorer.17"));
        inTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doShowStockInDialog(InventoryTransactionType.IN);
            }
        });
        outTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doAdjustStock(InventoryTransactionType.OUT, false);
            }
        });
        transferTransactionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeItemExplorer.this.doAdjustStock(InventoryTransactionType.UNCHANGED, true);
            }
        });
        panel.add(inTransactionButton);
        panel.add(outTransactionButton);
        panel.add(transferTransactionButton);
    }

    private boolean doAdjustStock(InventoryTransactionType type, boolean transfer) {
        int index = this.menuItemExplorerTable.getSelectedRow();
        if (index < 0) {
            return false;
        }
        MenuItem menuItem = this.tableModel.getRow(index);
        MenuItemDAO.getInstance().initialize(menuItem);
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        if (transfer) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        dialog.setPreferredSize(PosUIManager.getSize(500, 500));
        dialog.open();
        return !dialog.isCanceled();
    }

    private boolean doShowStockInDialog(InventoryTransactionType type) {
        int index = this.menuItemExplorerTable.getSelectedRow();
        MenuItem menuItem = null;
        if (index >= 0) {
            menuItem = this.tableModel.getRow(index);
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(type);
        InventoryStockInForm editor = null;
        if (menuItem == null) {
            editor = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            InventoryUnit unit = menuItem.getUnit();
            if (unit == null) {
                POSMessageDialog.showError(this, InvMessages.getString("RecipeItemExplorer.18"));
                return false;
            }
            Double replenishLevel = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(replenishLevel);
            Double cost = menuItem.getCost();
            inventoryTransaction.setUnitCost(cost);
            inventoryTransaction.setTotal(replenishLevel * cost);
            editor = new InventoryStockInForm(inventoryTransaction);
        }
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.openWithScale(830, 630);
        if (dialog.isCanceled()) {
            return false;
        }
        this.showMenuItems();
        return true;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth(this.getColumnWidth().get(column));
        }
    }

    private List<Integer> getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(180);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(80);
        columnWidth.add(80);
        columnWidth.add(50);
        columnWidth.add(140);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(200);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            MenuItem menuItem = this.tableModel.getRow(index);
            MenuItemDAO.getInstance().initialize(menuItem);
            this.tableModel.setRow(index, menuItem);
            if (!this.variant) {
                MenuItemForm editor = new MenuItemForm(menuItem);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                dialog.openWithScale(1024, 700);
                if (!dialog.isCanceled()) {
                    menuItem = MenuItemDAO.getInstance().loadInitialized(menuItem.getId());
                    this.tableModel.setRow(index, menuItem);
                }
            } else {
                VariantForm editor = new VariantForm(menuItem);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                dialog.openWithScale(1024, 700);
                if (!dialog.isCanceled()) {
                    this.tableModel.fireTableRowsUpdated(index, index);
                }
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doUpdateStockAmount() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), InvMessages.getString("MenuItemExplorer.7"));
                return;
            }
            MenuItem menuItem = this.tableModel.getRow(index);
            String amountString = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), InvMessages.getString("MenuItemExplorer.8"), menuItem.getAvailableUnit());
            if (amountString == null || amountString.equals("")) {
                return;
            }
            double stockAmount = Double.parseDouble(amountString);
            if (stockAmount < 0.0) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("MenuItemExplorer.10"));
                return;
            }
            menuItem.setAvailableUnit(stockAmount);
            MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            this.menuItemExplorerTable.repaint();
        }
        catch (NumberFormatException e1) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), InvMessages.getString("MenuItemExplorer.11"));
            return;
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, e2);
            return;
        }
    }

    private void doCreateNewMenuItem() {
        try {
            MenuItem menuItem = new MenuItem();
            MenuItemForm editor = new MenuItemForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(1024, 700);
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem foodItem = (MenuItem)editor.getBean();
            this.tableModel.addRow(foodItem);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteMenuItem() {
        try {
            int index = this.menuItemExplorerTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.menuItemExplorerTable.convertRowIndexToModel(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItem item = this.tableModel.getRow(index);
            MenuItemDAO foodItemDAO = new MenuItemDAO();
            foodItemDAO.releaseParentAndDelete(item);
            this.tableModel.removeRow(index);
        }
        catch (ConstraintViolationException ex) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("RecipeItemExplorer.19"));
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private class MenuItemExplorerTable
    extends JXTable {
        public MenuItemExplorerTable(TableModel dm) {
            super(dm);
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            super.changeSelection(row, column, toggle, extend);
            RecipeItemExplorer.this.menuItemExplorerTable.editCellAt(row, column);
            DefaultCellEditor editor = (DefaultCellEditor)RecipeItemExplorer.this.menuItemExplorerTable.getCellEditor(row, column);
            if (editor.getComponent() instanceof IntegerTextField) {
                IntegerTextField textField = (IntegerTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }
        }

        public void setValueAt(Object sortOrderString, int row, int column) {
            MenuItem menuItem = (MenuItem)RecipeItemExplorer.this.tableModel.getRow(row);
            String receiveStr = (String)sortOrderString;
            if (receiveStr.isEmpty()) {
                return;
            }
            Integer sOrder = Integer.parseInt(receiveStr);
            super.setValueAt((Object)sOrder, row, column);
            if (column == 8) {
                menuItem.setSortOrder(sOrder);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

