/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.RecipeEntryForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class RecipeSelectionView
extends JPanel {
    private JXTable table;
    private BeanTableModel<Recepie> tableModel;
    private JTextField tfName;
    private Recepie parentRecepie;
    private PosButton btnNext;
    private PosButton btnPrev;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton btnSearch;
    private JPanel searchPanel;
    private Map<String, Recepie> addedRecepieMap = new HashMap<String, Recepie>();
    private JCheckBox chkShowSelected;
    private boolean subRecipeOnly;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;

    public RecipeSelectionView(List<Recepie> addedRecepies, boolean inventoryItemOnly) {
        this.subRecipeOnly = inventoryItemOnly;
        this.initComponents();
        this.tableModel.setCurrentRowIndex(0);
        this.setRecepies(addedRecepies);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(Recepie.class);
        this.tableModel.addColumn("", "visible");
        this.tableModel.addColumn(POSConstants.NAME, Recepie.PROP_NAME);
        this.tableModel.addColumn(InvMessages.getString("RecipeSelectionView.0"), Recepie.PROP_YIELD);
        this.tableModel.addColumn(InvMessages.getString("RecipeSelectionView.1"), Recepie.PROP_YIELD_UNIT);
        this.tableModel.addColumn(InvMessages.getString("RecipeSelectionView.2"), Recepie.PROP_PORTION);
        this.tableModel.addColumn(InvMessages.getString("RecipeSelectionView.3"), Recepie.PROP_PORTION_UNIT);
        this.tableModel.setPageSize(10);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    RecipeSelectionView.this.editSelectedRow();
                } else {
                    RecipeSelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox(InvMessages.getString("IVRSV.5"));
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeSelectionView.this.updateView();
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == RecipeSelectionView.this.btnPrev) {
                        RecipeSelectionView.this.scrollUp();
                    } else if (source == RecipeSelectionView.this.btnNext) {
                        RecipeSelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void updateView() {
        if (this.chkShowSelected.isSelected()) {
            this.tableModel.setRows(new ArrayList<Recepie>(this.addedRecepieMap.values()));
            this.updateRecepieSelection();
            this.chkShowSelected.setText(InvMessages.getString("RecipeSelectionView.4") + " (" + this.addedRecepieMap.values().size() + ")");
            this.lblNumberOfItem.setText("");
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.table.repaint();
        }
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.lblName = new JLabel(POSConstants.NAME + InvMessages.getString("IVRSV.16"));
        this.tfName = new JTextField(15);
        this.btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "growx");
        this.searchPanel.add(this.btnSearch);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeSelectionView.this.tableModel.setCurrentRowIndex(0);
                RecipeSelectionView.this.doSearchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeSelectionView.this.tableModel.setCurrentRowIndex(0);
                RecipeSelectionView.this.doSearchItem();
            }
        });
        return this.searchPanel;
    }

    private void updateRecepieSelection() {
        List<Recepie> menuItems = this.tableModel.getRows();
        if (menuItems == null) {
            return;
        }
        Iterator<Recepie> iterator = menuItems.iterator();
        while (iterator.hasNext()) {
            Recepie menuItem;
            Recepie item = this.addedRecepieMap.get((menuItem = iterator.next()).getId());
            menuItem.setVisible(item != null);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(InvMessages.getString("RecipeSelectionView.7"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.chkShowSelected.setText(InvMessages.getString("RecipeSelectionView.4") + " (" + this.addedRecepieMap.values().size() + ")");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecipeSelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Recepie menuItem = new Recepie();
                    RecipeEntryForm editor = new RecipeEntryForm(menuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Recepie foodItem = (Recepie)editor.getBean();
                    RecipeSelectionView.this.tableModel.addRow(foodItem);
                    RecipeSelectionView.this.tableModel.setNumRows(RecipeSelectionView.this.tableModel.getNumRows() + 1);
                    RecipeSelectionView.this.updateButton();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(50);
        columnWidth.add(220);
        columnWidth.add(50);
        columnWidth.add(70);
        columnWidth.add(50);
        columnWidth.add(90);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Recepie menuItem = this.tableModel.getRow(index);
            this.tableModel.setRow(index, menuItem);
            RecipeEntryForm editor = new RecipeEntryForm(menuItem);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Recepie> getSelectedRecepieList() {
        return new ArrayList<Recepie>(this.addedRecepieMap.values());
    }

    public void setRecepies(List<Recepie> menuItems) {
        if (menuItems != null) {
            for (Recepie item : menuItems) {
                this.addedRecepieMap.put(item.getId(), item);
                this.tableModel.addRow(item);
            }
        }
    }

    public void setParentRecepie(Recepie selectedRecepie, boolean editMode) {
        this.parentRecepie = selectedRecepie;
        if (editMode) {
            this.chkShowSelected.setSelected(true);
            this.updateView();
        } else {
            this.doSearchItem();
        }
    }

    private void doSearchItem() {
        this.tableModel.setNumRows(RecepieDAO.getInstance().rowCount(this.tfName.getText(), this.isSubRecipeOnly()));
        RecepieDAO.getInstance().loadRecepies(this.tableModel, this.tfName.getText(), this.isSubRecipeOnly());
        this.updateButton();
        this.updateRecepieSelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        this.doSearchItem();
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        this.doSearchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        Recepie item = this.tableModel.getRow(selectedRow);
        if (this.parentRecepie != null && this.parentRecepie.getId() != null && this.parentRecepie.getId().equals(item.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRSV.0"));
            return;
        }
        item.setVisible(item.isVisible() == false);
        if (item.isVisible().booleanValue()) {
            this.addedRecepieMap.put(item.getId(), item);
        } else {
            this.addedRecepieMap.remove(item.getId());
        }
        this.chkShowSelected.setText(InvMessages.getString("RecipeSelectionView.4") + " (" + this.addedRecepieMap.values().size() + ")");
        this.table.repaint();
    }

    public BeanTableModel<Recepie> getModel() {
        return this.tableModel;
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSelectionMode(int selectionMode) {
        this.chkShowSelected.setVisible(selectionMode == 1);
        TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
        columnModel.getColumnExt(0).setVisible(selectionMode == 1);
        this.doSearchItem();
    }

    public void setEnableSearch(boolean enableSearch) {
        this.tfName.setVisible(enableSearch);
        this.lblName.setVisible(enableSearch);
        this.btnSearch.setVisible(enableSearch);
    }

    public boolean isSubRecipeOnly() {
        return this.subRecipeOnly;
    }

    public void setSubRecipeOnly(boolean subRecipeOnly) {
        this.subRecipeOnly = subRecipeOnly;
    }
}

