/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie.template;

import com.floreantpos.model.Recepie;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orostock.inventory.InvMessages;
import com.orostock.inventory.ui.recepie.template.RecipePreparationExplorer;
import java.util.List;

public class RecipePreparationEntryForm
extends OkCancelOptionDialog {
    RecipePreparationExplorer explorer;

    public RecipePreparationEntryForm() {
        this.setCaption(InvMessages.getString("IVRPEF.0"));
        this.explorer = new RecipePreparationExplorer();
        this.getContentPanel().add(this.explorer);
    }

    @Override
    public void doOk() {
        try {
            List<Recepie> recipes = this.explorer.getRows();
            if (recipes == null || recipes.size() <= 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRPEF.1"));
                return;
            }
            for (Recepie recepie : recipes) {
                Double actualYieldValue = recepie.getYield();
                Double cookingYield = recepie.getCookingYield();
                recepie.setPortion(cookingYield / actualYieldValue * recepie.getPortion());
            }
            RecepieDAO.getInstance().adjustInventory(1.0, recipes);
            this.setCanceled(false);
            this.dispose();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), InvMessages.getString("IVRPEF.2"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }
}

