/*
 * Decompiled with CFR 0.152.
 */
package com.orostock.inventory.ui.recepie.template;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RecipeReportModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"itemGroup", "items", "name", "unit", "quantity", "cost", "onhandvalue", "group", "rcp", "yieldQty", "yieldUnit", "additionalInfo"};
    private List<RecepieItem> items;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        RecepieItem recipeItem = this.items.get(rowIndex);
        MenuItem item = recipeItem.getInventoryItem();
        Recepie recepie = recipeItem.getRecepie();
        switch (columnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return recipeItem.getGroupName();
            }
            case 2: {
                return item.getDisplayName();
            }
            case 3: {
                return item.getUnit().getUniqueCode();
            }
            case 4: {
                return recipeItem.getQuantity();
            }
            case 5: {
                return item.getCost();
            }
            case 6: {
                return recipeItem.getQuantity() * item.getCost();
            }
            case 7: {
                return recipeItem.getGroupId();
            }
            case 8: {
                return recepie.getCode();
            }
            case 9: {
                return NumberUtil.trimDecilamIfNotNeeded(recepie.getCookingYield());
            }
            case 10: {
                return recepie.getYieldUnit();
            }
            case 11: {
                int cookingMin = recepie.getCookingMin();
                if (cookingMin > 0) {
                    return cookingMin + "m";
                }
                return "";
            }
        }
        return null;
    }

    public void setItems(List<Recepie> recipes) {
        if (recipes == null || recipes.size() == 0) {
            return;
        }
        this.items = this.buildItemMapForInventoryAdjustment(recipes);
        if (this.items.size() > 0) {
            for (RecepieItem item : this.items) {
                MenuItemDAO.getInstance().initialize(item.getInventoryItem());
            }
        }
    }

    private List<RecepieItem> buildItemMapForInventoryAdjustment(List<Recepie> items) {
        ArrayList<RecepieItem> recipeItems = new ArrayList<RecepieItem>();
        for (Recepie recepie : items) {
            HashMap<String, RecepieItem> itemMap = new HashMap<String, RecepieItem>();
            recepie.populateRecipeItems(itemMap, recepie.getCookingYield() / recepie.getYield(), recepie, false);
            if (itemMap.size() <= 0) continue;
            recipeItems.addAll(new ArrayList<RecepieItem>(itemMap.values()));
        }
        HashMap<String, RecepieItem> summaryMap = new HashMap<String, RecepieItem>();
        for (Recepie recipe : items) {
            recipe.populateRecipeItems(summaryMap, recipe.getCookingYield() / recipe.getYield(), recipe, true);
        }
        Collections.sort(recipeItems, new Comparator<RecepieItem>(){

            @Override
            public int compare(RecepieItem o1, RecepieItem o2) {
                return o1.getGroupName().compareTo(o2.getGroupName());
            }
        });
        if (summaryMap.size() > 0) {
            ArrayList arrayList = new ArrayList(summaryMap.values());
            for (RecepieItem recipeItem : arrayList) {
                try {
                    RecepieItem summaryRecipeItem = (RecepieItem)CopyUtil.deepCopy(recipeItem);
                    summaryRecipeItem.setGroupName("Summary");
                    summaryRecipeItem.setGroupId("");
                    recipeItems.add(summaryRecipeItem);
                }
                catch (Exception exception) {}
            }
        }
        return recipeItems;
    }
}

