/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.ForHereToGoSelectionDialog;
import org.apache.commons.lang.StringUtils;

public class ForHereToGoAction
extends PosAction {
    private Ticket ticket;
    private User currentUser;
    private boolean isPerformed;

    public ForHereToGoAction(Ticket ticket) {
        this.ticket = ticket;
    }

    public ForHereToGoAction(Ticket ticket, User user) {
        this.ticket = ticket;
        this.currentUser = user;
    }

    @Override
    public void execute() {
        try {
            if (!this.hasPermissionToAccessTicket(this.ticket)) {
                return;
            }
            this.isPerformed = this.performForHereToGo();
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public boolean performForHereToGo() {
        try {
            OrderType orderType = this.ticket.getOrderType();
            if (orderType.isHasForHereAndToGo().booleanValue() && !(this.ticket.getPaidAmount() > 0.0)) {
                ForHereToGoSelectionDialog dialog = new ForHereToGoSelectionDialog();
                dialog.open();
                if (dialog.isCanceled()) {
                    return false;
                }
                String forHereOrToGo = dialog.getSelectedOrderType();
                String toGoPickupTime = dialog.getPickupTime();
                Customer customer = this.ticket.getCustomer();
                if (forHereOrToGo != null) {
                    SubOrderType subOrderType = SubOrderType.valueOf(forHereOrToGo);
                    this.ticket.addProperty("ticket.sub_order_type", subOrderType.getName());
                    if (customer == null || !customer.isTaxExempt().booleanValue()) {
                        if (subOrderType == SubOrderType.FOR_HERE) {
                            this.ticket.setTaxExempt(Boolean.valueOf(orderType.getProperty("for_here_tax_applicable")) == false);
                            if (this.ticket.hasProperty("togo_pickup_time")) {
                                this.ticket.removeProperty("togo_pickup_time");
                            }
                        } else {
                            this.ticket.setTaxExempt(Boolean.valueOf(orderType.getProperty("togo_tax_applicable")) == false);
                            if (StringUtils.isNotBlank((String)toGoPickupTime)) {
                                this.ticket.addProperty("togo_pickup_time", toGoPickupTime);
                            }
                        }
                    }
                    this.ticket.calculatePrice();
                }
            }
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        return true;
    }

    @Override
    protected User getCurrentUser() {
        if (this.currentUser == null) {
            return Application.getCurrentUser();
        }
        return this.currentUser;
    }

    public boolean isPerformed() {
        return this.isPerformed;
    }
}

