/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardActivateView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;

public class GiftCardAddBalanceAction
extends PosAction {
    private GiftCardProcessor giftCardProcessor;

    public GiftCardAddBalanceAction(boolean showIcon) {
        if (showIcon) {
            this.putValue("SmallIcon", IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CARD_GIFTCARD, (float)PosUIManager.getSize(32)));
        }
    }

    @Override
    public void execute() {
        GiftCardPaymentPlugin paymentGateway = GiftCardConfig.getPaymentGateway();
        this.giftCardProcessor = paymentGateway.getProcessor();
        if (paymentGateway != null && this.giftCardProcessor.supportActivation()) {
            GiftCard giftCard = this.getGiftCard();
            if (giftCard == null) {
                return;
            }
            this.addBalance(giftCard);
        }
    }

    private void addBalance(GiftCard giftCard) {
        if (giftCard == null) {
            POSMessageDialog.showMessage(Messages.getString("GiftCardAddBalanceView.16"));
            return;
        }
        double balance = NumberSelectionDialog2.takeDoubleInput(Messages.getString("GiftCardAddBalanceAction.0"), Messages.getString("GiftCardAddBalanceAction.0"), 0.0);
        if (Double.isNaN(balance)) {
            return;
        }
        if (balance <= 0.0) {
            POSMessageDialog.showMessage(Messages.getString("GiftCardAddBalanceAction.2"));
            return;
        }
        OrderView instance = OrderView.getInstance();
        Ticket ticket = instance.getCurrentTicket();
        OrderType orderType = ticket.getOrderType();
        if (orderType == null) {
            POSMessageDialog.showMessage(Messages.getString("GiftCardAddBalanceView.5"));
            return;
        }
        TerminalConfig.setGiftOrdertype(orderType.getId());
        ticket.setHasGiftCard(true);
        ticket.setShouldIncludeInSales(false);
        if (orderType.getSalesArea() != null) {
            ticket.setSalesArea(orderType.getSalesArea());
        } else if (DataProvider.get().getCurrentTerminal().getSalesArea() != null) {
            ticket.setSalesArea(DataProvider.get().getCurrentTerminal().getSalesArea());
        }
        MenuItem giftCardMenuItem = MenuItemDAO.getInstance().findByName("Gift Card");
        TicketItem ticketItem = null;
        if (giftCardMenuItem != null) {
            ticketItem = giftCardMenuItem.convertToTicketItem(ticket, 1.0);
        }
        if (ticketItem == null) {
            ticketItem = new TicketItem();
            ticketItem.setTicket(ticket);
        }
        ticketItem.setItemIsGiftCard(giftCard.getCardNumber(), balance);
        instance.getTicketView().addTicketItem(ticketItem);
        instance.getOrderController().fireTicketItemUpdated(ticket, ticketItem);
    }

    private GiftCard getGiftCard() {
        String cardNo = this.getGiftCardNumber();
        if (StringUtils.isEmpty((String)cardNo)) {
            return null;
        }
        GiftCard giftCard = this.giftCardProcessor.getCard(cardNo);
        if (giftCard == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardNotFound"));
            return null;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return null;
        }
        if (!giftCard.isActive().booleanValue()) {
            int value = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardAddBalanceAction.3"), Messages.getString("GiftCardExplorer.31"));
            if (value == 0) {
                return this.doActivateGiftCard(giftCard);
            }
            return null;
        }
        if (giftCard.isExpried()) {
            POSMessageDialog.showError(Messages.getString("GiftCardAddBalanceView.0"));
            return null;
        }
        return giftCard;
    }

    private String getGiftCardNumber() {
        GlobalInputDialog inputDialog = new GlobalInputDialog();
        inputDialog.setCaption(Messages.getString("GiftCardManagementView.1"));
        inputDialog.setBlankErrorMessage(Messages.getString("GiftCardAddBalanceAction.4"));
        inputDialog.open();
        if (inputDialog.isCanceled()) {
            return null;
        }
        String giftCardNumber = inputDialog.getInput();
        return giftCardNumber;
    }

    private GiftCard doActivateGiftCard(GiftCard selectedGiftCard) {
        GiftCardActivateView dialog = new GiftCardActivateView(this.giftCardProcessor, selectedGiftCard);
        dialog.setTitle(Messages.getString("Activate"));
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(900, 450));
        dialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return null;
        }
        return dialog.getGiftCard();
    }
}

