/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PrinterIsNotConfiguredException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;

public class StaffBankCloseAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private CashDrawer staffBank;
    private User closedByUser;

    public StaffBankCloseAction(CashDrawer staffBank, User closedByUser) {
        super(Messages.getString("CloseStaffBank"));
        this.staffBank = staffBank;
        this.closedByUser = closedByUser;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("StaffBankCloseAction.1"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return;
            }
            this.performCloseStaffBank();
        }
        catch (PrinterIsNotConfiguredException option) {
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performCloseStaffBank() throws Exception {
        CashDrawerReportService reportService = new CashDrawerReportService(this.staffBank);
        reportService.populateReport();
        Double reconcileAmount = 0.0;
        DataProvider dataProvider = DataProvider.get();
        if (dataProvider.getStore().isUseDetailedReconciliation().booleanValue()) {
            CashReconciliationDialog dialog = new CashReconciliationDialog(this.staffBank);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            reconcileAmount = dialog.getTotalReconcilieAmount();
        } else if (dataProvider.getCurrentTerminal().isEnableMultiCurrency().booleanValue()) {
            MultiCurrencyAmountSelectionDialog multiCurrencyDialog = new MultiCurrencyAmountSelectionDialog(this.staffBank, this.staffBank.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            multiCurrencyDialog.setTitle(Messages.getString("StaffBankCloseAction.3"));
            multiCurrencyDialog.setCaption(Messages.getString("StaffBankCloseAction.4"));
            multiCurrencyDialog.setReconcile(true);
            multiCurrencyDialog.pack();
            multiCurrencyDialog.open();
            if (multiCurrencyDialog.isCanceled()) {
                return;
            }
            reconcileAmount = multiCurrencyDialog.getTotalAmount();
        } else {
            reconcileAmount = this.getReconcileAmount(this.staffBank);
            if (reconcileAmount.isNaN()) {
                return;
            }
        }
        this.staffBank.setCashToDeposit(reconcileAmount);
        TerminalDAO dao = new TerminalDAO();
        dao.resetStaffBank(this.closedByUser, this.staffBank);
        Application.getInstance().refreshCurrentUser();
        this.updateActionText();
        PosPrintService.printDrawerPullReport(this.staffBank);
    }

    public void performForceCloseStaffBank(User closedByUser) throws Exception {
        try {
            CashDrawerReportService reportService = new CashDrawerReportService(this.staffBank);
            reportService.populateReport();
            this.staffBank.setCashToDeposit(0.0);
            TerminalDAO dao = new TerminalDAO();
            dao.resetStaffBank(closedByUser, this.staffBank);
            Application.getInstance().refreshCurrentUser();
            this.updateActionText();
            PosPrintService.printDrawerPullReport(this.staffBank);
        }
        catch (PrinterIsNotConfiguredException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("StaffBankCloseAction.5") + e.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
    }

    private Double getReconcileAmount(CashDrawer staffBank) {
        double initialAmount;
        String dialogTitle;
        String title = Messages.getString("StaffBankCloseAction.6");
        Double reconcileAmount = NumberSelectionDialog2.takeDoubleInput(title, dialogTitle = Messages.getString("StaffBankCloseAction.7"), initialAmount = this.closedByUser.isBlindAccountableAmount() != false ? 0.0 : NumberUtil.roundToTwoDigit(staffBank.getDrawerAccountable()));
        if (Double.isNaN(reconcileAmount)) {
            return Double.NaN;
        }
        if (reconcileAmount < staffBank.getDrawerAccountable()) {
            String message = Messages.getString("StaffBankCloseAction.8");
            String title2 = Messages.getString("CONFIRM");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title2) == 0) {
                return reconcileAmount;
            }
            return this.getReconcileAmount(staffBank);
        }
        return reconcileAmount;
    }
}

