/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.StaleStateException;

public class TableSelectionAction
extends PosAction {
    private Ticket ticket;

    public TableSelectionAction() {
        this((OrderView)null);
    }

    public TableSelectionAction(OrderView listener) {
        super(listener);
    }

    @Override
    public void execute() {
        try {
            if (this.listener == null || !(this.listener instanceof OrderView)) {
                return;
            }
            Object selectedData = this.listener.getSelectedData();
            if (!(selectedData instanceof Ticket)) {
                return;
            }
            this.ticket = (Ticket)selectedData;
            if (this.ticket.getOrderType().isPropertyValueTrue("tableSelection.freeTextInput")) {
                this.setFreeTextTableToTicket();
            } else {
                this.setTablesToTicket();
            }
        }
        catch (PosException e0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e0.getMessage());
        }
        catch (Exception e0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e0.getMessage(), e0);
        }
    }

    private void setFreeTextTableToTicket() {
        if (this.ticket == null) {
            return;
        }
        OrderView orderView = (OrderView)this.listener;
        GlobalInputDialog dialog = new GlobalInputDialog();
        dialog.setInputLength(40);
        dialog.setInput(this.ticket.getProperty("freeTextTableName"));
        dialog.setTitle(VersionInfo.getAppName());
        dialog.setCaption(Messages.getString("PosGuiUtil.1"));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        String tableNumber = dialog.getInput();
        this.ticket.addProperty("freeTextTableName", tableNumber);
        orderView.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTablesToTicket() {
        if (this.ticket == null) {
            return;
        }
        OrderView orderView = (OrderView)this.listener;
        TableSelectorDialog dialog = null;
        try {
            String message;
            int option;
            boolean newTicket;
            dialog = TableSelectorFactory.createTableSelectorDialog(this.ticket.getOrderType());
            dialog.setTitle(Messages.getString("TableSelectionAction.0"));
            dialog.getTableSelector().setTicketTransferMode(true);
            dialog.setCreateNewTicket(false);
            dialog.getTableSelector().setHomeViewMode(Boolean.FALSE);
            dialog.updateView(Boolean.TRUE);
            this.ticket.setShouldUpdateTableStatus(true);
            if (this.ticket != null) {
                dialog.setTicket(this.ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            List<ShopTable> tables = dialog.getSelectedTables();
            if (tables.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableSelectionAction.1"));
                return;
            }
            boolean bl = newTicket = this.ticket.getId() == null && TicketDAO.getInstance().isNewTicket(this.ticket.getId());
            if (!newTicket && (option = POSMessageDialog.showYesNoQuestionDialog(orderView, message = Messages.getString("TableSelectionAction.2"), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    this.ticket.setSalesArea(salesArea);
                    this.ticket.setSalesAreaId(salesArea.getId());
                }
                tableNumbers.add(shopTable.getId());
            }
            this.updateTicketItemsSeat(tables);
            if (!newTicket) {
                ShopTableDAO.getInstance().transferTickets(this.ticket, tableNumbers);
            } else {
                this.ticket.setTableNumbers(tableNumbers);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
            orderView.updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), orderView);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        finally {
            if (dialog != null) {
                dialog.setCreateNewTicket(true);
            }
        }
    }

    private void updateTicketItemsSeat(List<ShopTable> tables) {
        OrderView orderView = (OrderView)this.listener;
        if (tables == null || tables.isEmpty()) {
            return;
        }
        ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
        HashMap<Integer, ShopTable> shopTableMap = new HashMap<Integer, ShopTable>();
        for (ShopTable shopTable : tables) {
            Integer tableId = shopTable.getId();
            shopTableMap.put(tableId, shopTable);
            tableNumbers.add(tableId);
        }
        List<ShopSeat> parentTableSeats = ShopSeatDAO.getInstance().getShopSeatsByTableIds(tableNumbers);
        HashMap<String, ShopSeat> equivalentSeatMap = new HashMap<String, ShopSeat>();
        TicketViewerTable ticketViewerTable = orderView.getTicketView().getTicketViewerTable();
        TicketViewerTableModel ticketViewerTableModel = ticketViewerTable.getModel();
        int rowCount = ticketViewerTableModel.getRowCount();
        int extraSeatsCount = 1;
        for (int i = 0; i < rowCount; ++i) {
            ShopSeat shopSeat;
            TicketItemSeat seat;
            Object e = ticketViewerTableModel.get(i);
            TicketItem ticketItem = null;
            if (e instanceof TicketItem) {
                ticketItem = (TicketItem)e;
            }
            if (ticketItem == null || (seat = ticketItem.getSeat()) == null || (shopSeat = seat.getShopSeat()) == null) continue;
            ShopSeat equivalentSeat = (ShopSeat)equivalentSeatMap.get(shopSeat.getId());
            if (equivalentSeat == null) {
                Integer shopTableId;
                ShopTable shopTable = shopSeat.getShopTable();
                if (shopTable == null || shopTableMap.get(shopTableId = shopTable.getId()) != null) continue;
                Integer seatNumber = seat.getSeatNumber();
                equivalentSeat = this.getEquivalentSeat(parentTableSeats, seatNumber);
                if (equivalentSeat == null) {
                    equivalentSeat = this.createExtraSeat(extraSeatsCount);
                    ++extraSeatsCount;
                }
                if (equivalentSeat != null) {
                    equivalentSeatMap.put(shopSeat.getId(), equivalentSeat);
                }
            }
            if (equivalentSeat == null) {
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    ticketItem.setName(Messages.getString("TableSelectionAction.3"));
                }
                ticketItem.setSeat(null);
                continue;
            }
            TicketItemSeat ticketItemSeat = equivalentSeat.convertTicketItemSeat();
            ticketItemSeat.setMember(seat.getMember());
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                ticketItem.setName(equivalentSeat.getSeatNumberWithTableName(ticketItem.getTicket()));
            }
            ticketItem.setSeat(ticketItemSeat);
        }
        ticketViewerTable.updateView();
    }

    private ShopSeat createExtraSeat(int seatNumber) {
        ShopSeat shopSeat = new ShopSeat();
        shopSeat.setId(GlobalIdGenerator.generateGlobalId());
        shopSeat.setSeatNumber(seatNumber);
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (extraSeats == null) {
            extraSeats = new ArrayList<ShopSeat>();
        }
        extraSeats.add(shopSeat);
        this.ticket.addExtraSeats(extraSeats);
        return shopSeat;
    }

    private ShopSeat getEquivalentSeat(List<ShopSeat> seats, Integer seatNumber) {
        if (seats == null || seats.isEmpty()) {
            return null;
        }
        for (ShopSeat seat : seats) {
            if (seat.getSeatNumber() != seatNumber) continue;
            return seat;
        }
        return null;
    }
}

