/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.hibernate.exception.JDBCConnectionException;

public abstract class ViewChangeAction
extends PosAction {
    private boolean visible = true;
    protected UserPermission requiredPermission;

    public ViewChangeAction() {
    }

    public ViewChangeAction(String name) {
        super(name);
    }

    public ViewChangeAction(String name, UserPermission requiredPermission) {
        super(name);
        this.requiredPermission = requiredPermission;
    }

    @Override
    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    @Override
    public void setRequiredPermission(UserPermission requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            OrderView orderView = OrderView.getInstance();
            Ticket currentTicket = orderView.getCurrentTicket();
            if (currentTicket == null || currentTicket.getId() == null && currentTicket.getTicketItems().isEmpty()) {
                this.doCancelOrder();
                this.execute();
                return;
            }
            boolean version = TerminalDAO.getInstance().isVersionEqual(Ticket.class, currentTicket.getId(), currentTicket.getVersion());
            if (!version) {
                this.execute();
                return;
            }
            User user = Application.getCurrentUser();
            if (user == null) {
                POSMessageDialog.showError(Messages.getString("ViewChangeAction.4"));
                return;
            }
            IView currentView = RootView.getInstance().getCurrentView();
            if (currentView != null && currentView.getViewName().equals("ORDER_VIEW") && !orderView.getTicketView().isAllowToLogOut()) {
                POSMessageDialog.showError(Messages.getString("ViewChangeAction.0"));
                return;
            }
            this.saveTicketIfNeeded();
            if (this.requiredPermission == null) {
                this.execute();
                return;
            }
            if (!user.hasPermission(this.requiredPermission)) {
                String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
                if (StringUtils.isEmpty((String)password)) {
                    return;
                }
                User user2 = UserDAO.getInstance().findUserBySecretKey(password);
                if (user2 == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
                    return;
                }
                if (!user2.hasPermission(this.requiredPermission)) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
                    return;
                }
            }
            this.execute();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (JDBCConnectionException e2) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ViewChangeAction.3"), POSConstants.CONFIRM) == 0) {
                this.execute();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void saveTicketIfNeeded() {
        OrderView orderView = OrderView.getInstance();
        if (!orderView.isVisible()) {
            return;
        }
        Ticket currentTicket = orderView.getCurrentTicket();
        if (currentTicket == null) {
            return;
        }
        if (!currentTicket.getTicketItems().isEmpty() && (this.hasNewItem(currentTicket) || this.hasNewProp(currentTicket))) {
            int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("ViewChangeAction.1"), Messages.getString("ViewChangeAction.2"));
            if (option == 0) {
                orderView.doHoldOrder(false);
            } else {
                this.doCancelOrder();
            }
        }
    }

    private boolean hasNewProp(Ticket currentTicket) {
        Ticket ticket = TicketDAO.getInstance().get(currentTicket.getId());
        return ticket.getNumberOfGuests() != currentTicket.getNumberOfGuests();
    }

    private boolean hasNewItem(Ticket currentTicket) {
        for (TicketItem item : currentTicket.getTicketItems()) {
            if (item.getId() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract void execute();

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    private void doCancelOrder() {
        OrderView orderView = OrderView.getInstance();
        if (!orderView.getTicketView().isCancelable()) {
            return;
        }
        orderView.getTicketView().doCancelOrder(false);
        orderView.getOrderController().fireTicketEditingFinish(orderView.getCurrentTicket());
    }
}

