/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.UserPermission;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.ExcelImportViewDialog;
import com.floreantpos.util.POSUtil;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class ImportFromExcelAction
extends PosAction {
    private String filePath = null;

    public ImportFromExcelAction() {
        super(Messages.getString("ImportMenusFromExcel"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        this.doSelectExcel();
    }

    private void doSelectExcel() {
        block5: {
            try {
                JFileChooser fileChooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                fileChooser.setDialogTitle(POSConstants.TITLE_OROPOS.toUpperCase());
                int option = fileChooser.showOpenDialog(POSUtil.getFocusedWindow());
                if (option == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    this.filePath = selectedFile.getAbsolutePath();
                    ExcelImportViewDialog dialog = new ExcelImportViewDialog(this.filePath);
                    dialog.setDefaultCloseOperation(2);
                    List<Object> itemsList = dialog.getItemsList();
                    if (itemsList == null || itemsList.isEmpty()) {
                        return;
                    }
                    dialog.openFullScreen();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    break block5;
                }
                return;
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage(), exp);
            }
        }
    }
}

