/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesigner;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class MenuPageExplorerAction
extends AbstractAction {
    public MenuPageExplorerAction() {
        super(Messages.getString("MenuPageExplorerAction.0"));
    }

    public MenuPageExplorerAction(String name) {
        super(name);
    }

    public MenuPageExplorerAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            MenuPageDesigner pageExplorer;
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            int index = tabbedPane.indexOfTab(Messages.getString("MenuPageExplorerAction.0"));
            if (index == -1) {
                pageExplorer = new MenuPageDesigner();
                tabbedPane.addTab(Messages.getString("MenuPageExplorerAction.0"), pageExplorer);
                pageExplorer.initData();
            } else {
                pageExplorer = (MenuPageDesigner)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(pageExplorer);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

