/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.CustomerSelectionChangeException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.UserPermission;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.util.POSUtil;

public class PromotionAction
extends PosAction {
    private PaymentView paymentView;
    private PaymentPlugin paymentPlugin;

    public PromotionAction(PaymentView paymentView, PaymentPlugin paymentPlugin) {
        super("PROMOTION", UserPermission.SETTLE_TICKET_WITH_PROMOTION);
        this.paymentView = paymentView;
        this.paymentPlugin = paymentPlugin;
    }

    @Override
    public void execute() {
        try {
            this.paymentView.doSelectCustomer();
            this.paymentView.doPaymentByPlugin(this.paymentPlugin);
        }
        catch (CustomerSelectionChangeException e) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage().toString(), e);
        }
    }
}

