/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.ReportViewer;
import com.floreantpos.report.ReturnItemReport;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ReturnItemReportAction
extends AbstractAction {
    private static final String RETURN_ITEM_REPORT = Messages.getString("ReturnItemReportAction.0");

    public ReturnItemReportAction() {
        super(RETURN_ITEM_REPORT);
    }

    public ReturnItemReportAction(String name) {
        super(name);
    }

    public ReturnItemReportAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            ReportViewer viewer = null;
            int index = tabbedPane.indexOfTab(RETURN_ITEM_REPORT);
            if (index == -1) {
                viewer = new ReportViewer(new ReturnItemReport());
                tabbedPane.addTab(RETURN_ITEM_REPORT, viewer);
            } else {
                viewer = (ReportViewer)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(viewer);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

