/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.SessionSummaryReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class SessionSummaryReportAction
extends AbstractAction {
    public SessionSummaryReportAction() {
        super(POSConstants.SESSION_SUMMARY_REPORT);
    }

    public SessionSummaryReportAction(String name) {
        super(name);
    }

    public SessionSummaryReportAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            SessionSummaryReportView reportView = null;
            int index = tabbedPane.indexOfTab(POSConstants.SESSION_SUMMARY_REPORT);
            if (index == -1) {
                reportView = new SessionSummaryReportView();
                tabbedPane.addTab(POSConstants.SESSION_SUMMARY_REPORT, reportView);
            } else {
                reportView = (SessionSummaryReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

