/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.AttributeEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class AttributeExplorer
extends TransparentPanel
implements ActionListener,
ListSelectionListener,
RefreshableView {
    private static final long serialVersionUID = 1L;
    private JXTreeTable treeTable;
    private InvGroupTreeTableModel noRootTreeTableModel;
    private List<AttributeGroup> rootGroupList;

    public AttributeExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.treeTable = new JXTreeTable();
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setRootVisible(false);
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.loadTreeTable();
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = AttributeExplorer.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    AttributeExplorer.this.treeTable.expandPath(AttributeExplorer.this.treeTable.getPathForRow(AttributeExplorer.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    AttributeExplorer.this.editSelectedRow();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTable), "Center");
        this.createButtonPanel();
        this.add((Component)this.buildActionForm(), "North");
    }

    private JPanel buildActionForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]10[]"));
        JButton btnRefresh = new JButton(Messages.getString("AttributeExplorer.1"));
        panel.add(btnRefresh);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("AttributeExplorer.3"));
        title.setTitleJustification(1);
        panel.setBorder(title);
        btnRefresh.addActionListener(event -> this.loadTreeTable());
        return panel;
    }

    private void createTree() {
        if (this.rootGroupList != null) {
            AttributeGroup demo = new AttributeGroup();
            demo.setId("0");
            demo.setName("Root");
            DefaultMutableTreeTableNode rootNode = new DefaultMutableTreeTableNode((Object)demo);
            rootNode.setUserObject((Object)demo);
            for (AttributeGroup inventoryGroup : this.rootGroupList) {
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryGroup);
                rootNode.add((MutableTreeTableNode)node);
                this.buildAttributeTree(node);
            }
            this.noRootTreeTableModel = new InvGroupTreeTableModel(rootNode);
            this.treeTable.setTreeTableModel((TreeTableModel)this.noRootTreeTableModel);
        }
    }

    private void buildAttributeTree(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        AttributeGroup attributeGroup = (AttributeGroup)defaultMutableTreeTableNode.getUserObject();
        if (attributeGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<Attribute> attributeList = attributeGroup.getAttributes();
        for (Attribute inventoryUnit : attributeList) {
            DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)inventoryUnit);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)node);
        }
    }

    private void createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btn_newGroup = new JButton(Messages.getString("AttributeExplorer.8"));
        JButton btn_newAttribute = new JButton(Messages.getString("AttributeExplorer.9"));
        JButton editButton = explorerButton.getEditButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        btn_newGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("AttributeExplorer.10"));
                    if (groupName == null) {
                        return;
                    }
                    if (groupName.length() > 30) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.11"));
                        return;
                    }
                    AttributeGroup inventoryGroup = new AttributeGroup();
                    GenericDAO.getInstance().checkIdOrNameExists(inventoryGroup.getId(), groupName, AttributeGroup.class);
                    inventoryGroup.setName(groupName);
                    AttributeGroupDAO inventoryGroupDAO = new AttributeGroupDAO();
                    inventoryGroupDAO.saveOrUpdate(inventoryGroup);
                    if (inventoryGroup != null) {
                        MutableTreeTableNode root = (MutableTreeTableNode)AttributeExplorer.this.noRootTreeTableModel.getRoot();
                        AttributeExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)inventoryGroup), root, root.getChildCount());
                    }
                    AttributeExplorer.this.treeTable.expandAll();
                }
                catch (PosException exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        btn_newAttribute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Attribute att = new Attribute();
                att.setGroup(AttributeExplorer.this.getSelectedAtrributeGroup());
                AttributeEntryForm inventoryUnitFormTree = new AttributeEntryForm(att);
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryUnitFormTree);
                dialog.setPreferredSize(PosUIManager.getSize(500, 400));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                Attribute newAtt = (Attribute)inventoryUnitFormTree.getBean();
                AttributeGroup parentOfNewAtt = newAtt.getGroup();
                if (newAtt != null) {
                    MutableTreeTableNode root = (MutableTreeTableNode)AttributeExplorer.this.noRootTreeTableModel.getRoot();
                    if (parentOfNewAtt != null) {
                        MutableTreeTableNode parentNode = AttributeExplorer.this.findTreeNodeForAttribute(root, parentOfNewAtt.getId());
                        if (parentNode != null) {
                            AttributeExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newAtt), parentNode, parentNode.getChildCount());
                        }
                    } else {
                        MutableTreeTableNode parentNode = AttributeExplorer.this.findTreeNodeForAttribute(root, "0");
                        if (parentNode != null) {
                            AttributeExplorer.this.noRootTreeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newAtt), parentNode, parentNode.getChildCount());
                        }
                    }
                }
                AttributeExplorer.this.treeTable.expandAll();
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.deleteInventoryAttribute();
            }

            private void deleteInventoryAttribute() {
                try {
                    int index = AttributeExplorer.this.treeTable.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    TreePath treePath = AttributeExplorer.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    if (lastPathComponent.getUserObject() instanceof AttributeGroup) {
                        AttributeGroup attributeGroup = (AttributeGroup)lastPathComponent.getUserObject();
                        if (POSMessageDialog.showYesNoQuestionDialog(AttributeExplorer.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                            return;
                        }
                        AttributeGroupDAO groupDaoInstance = AttributeGroupDAO.getInstance();
                        AttributeGroup currentAttributeGroup = groupDaoInstance.get(attributeGroup.getId());
                        groupDaoInstance.delete(currentAttributeGroup);
                        MutableTreeTableNode tableNode = AttributeExplorer.this.findTreeNodeForAttribute((MutableTreeTableNode)AttributeExplorer.this.noRootTreeTableModel.getRoot(), attributeGroup.getId());
                        if (tableNode.getParent() != null) {
                            AttributeExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    } else if (lastPathComponent.getUserObject() instanceof Attribute) {
                        Attribute attribute = (Attribute)lastPathComponent.getUserObject();
                        if (POSMessageDialog.showYesNoQuestionDialog(AttributeExplorer.this.getRootPane(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                            return;
                        }
                        AttributeDAO attributeDaoInstance = AttributeDAO.getInstance();
                        Attribute currentAttribute = attributeDaoInstance.get(attribute.getId());
                        attributeDaoInstance.delete(currentAttribute);
                        MutableTreeTableNode tableNode = AttributeExplorer.this.findTreeNodeForAttribute((MutableTreeTableNode)AttributeExplorer.this.noRootTreeTableModel.getRoot(), attribute.getId());
                        if (tableNode.getParent() != null) {
                            AttributeExplorer.this.noRootTreeTableModel.removeNodeFromParent(tableNode);
                        }
                    }
                    AttributeExplorer.this.treeTable.repaint();
                    AttributeExplorer.this.treeTable.revalidate();
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(btn_newGroup);
        panel.add(btn_newAttribute);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof AttributeGroup) {
                try {
                    AttributeGroup attributeGroup = (AttributeGroup)lastPathComponent.getUserObject();
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.15"), attributeGroup.getName());
                    if (groupName == null) {
                        return;
                    }
                    if (StringUtils.isBlank((String)groupName)) {
                        POSMessageDialog.showError(Messages.getString("AttributeExplorer.0"));
                        return;
                    }
                    if ((groupName = groupName.trim()).length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.16"));
                        return;
                    }
                    GenericDAO.getInstance().checkIdOrNameExists(attributeGroup.getId(), groupName, AttributeGroup.class);
                    attributeGroup.setName(groupName);
                    AttributeGroupDAO.getInstance().saveOrUpdate(attributeGroup);
                }
                catch (PosException exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            } else if (lastPathComponent.getUserObject() instanceof Attribute) {
                Attribute attribute = (Attribute)lastPathComponent.getUserObject();
                AttributeEntryForm inventoryUnitFormTree = new AttributeEntryForm(attribute);
                BeanEditorDialog dialog = new BeanEditorDialog(inventoryUnitFormTree);
                dialog.setPreferredSize(PosUIManager.getSize(500, 400));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
            }
            this.loadTreeTable();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void loadTreeTable() {
        this.rootGroupList = AttributeGroupDAO.getInstance().findAll();
        this.createTree();
        this.treeTable.expandAll();
    }

    public Attribute getSelectedAtrribute() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                return null;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof AttributeGroup) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("AttributeExplorer.17"));
                return null;
            }
            if (lastPathComponent.getUserObject() instanceof Attribute) {
                return (Attribute)lastPathComponent.getUserObject();
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return null;
    }

    public AttributeGroup getSelectedAtrributeGroup() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                return null;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (lastPathComponent.getUserObject() instanceof AttributeGroup) {
                return (AttributeGroup)lastPathComponent.getUserObject();
            }
            if (lastPathComponent.getUserObject() instanceof Attribute) {
                return ((Attribute)lastPathComponent.getUserObject()).getGroup();
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return null;
    }

    public MutableTreeTableNode findTreeNodeForAttribute(MutableTreeTableNode attributeNode, String attributeId) {
        block5: {
            block4: {
                if (!(((DefaultMutableTreeTableNode)attributeNode).getUserObject() instanceof AttributeGroup)) break block4;
                AttributeGroup groupAttribute = (AttributeGroup)attributeNode.getUserObject();
                if (attributeId.equals(groupAttribute.getId())) {
                    return attributeNode;
                }
                Enumeration children = attributeNode.children();
                while (children.hasMoreElements()) {
                    MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                    MutableTreeTableNode findAttById = this.findTreeNodeForAttribute(treeTableNode, attributeId);
                    if (findAttById == null) continue;
                    return findAttById;
                }
                break block5;
            }
            if (!(((DefaultMutableTreeTableNode)attributeNode).getUserObject() instanceof Attribute)) break block5;
            Attribute attributeAttribute = (Attribute)attributeNode.getUserObject();
            if (attributeId.equals(attributeAttribute.getId())) {
                return attributeNode;
            }
            Enumeration children = attributeNode.children();
            while (children.hasMoreElements()) {
                MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
                MutableTreeTableNode findAttById = this.findTreeNodeForAttribute(treeTableNode, attributeId);
                if (findAttById == null) continue;
                return findAttById;
            }
        }
        return null;
    }

    @Override
    public void refresh() {
        this.loadTreeTable();
    }

    class InvGroupTreeTableModel
    extends DefaultTreeTableModel {
        private final String[] COLUMN_NAMES;

        public InvGroupTreeTableModel(DefaultMutableTreeTableNode rootAttribute) {
            super((TreeTableNode)rootAttribute);
            this.COLUMN_NAMES = new String[]{Messages.getString("AttributeExplorer.2"), Messages.getString("NAME"), Messages.getString("AttributeExplorer.4"), Messages.getString("AttributeExplorer.5")};
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof AttributeGroup) {
                    AttributeGroup inventoryAttribute = (AttributeGroup)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (inventoryAttribute == null) {
                        return "";
                    }
                    switch (column) {
                        case 0: {
                            return inventoryAttribute.getName();
                        }
                    }
                } else if (((DefaultMutableTreeTableNode)node).getUserObject() instanceof Attribute) {
                    Attribute inventoryUnit = (Attribute)((DefaultMutableTreeTableNode)node).getUserObject();
                    if (inventoryUnit == null) {
                        return "";
                    }
                    switch (column) {
                        case 1: {
                            return inventoryUnit.getName();
                        }
                        case 2: {
                            return inventoryUnit.getSortOrder();
                        }
                        case 3: {
                            return inventoryUnit.isDefaultAttribute();
                        }
                    }
                }
            }
            return null;
        }
    }
}

