/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private JXTable table;
    private BeanTableModel<MenuGroup> tableModel;
    private JTextField tfNameField;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JComboBox cbCategory;

    public MenuGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuGroup.class);
        this.tableModel.addColumn(POSConstants.NAME, "name");
        this.tableModel.addColumn(POSConstants.TRANSLATED_NAME, "translatedName");
        this.tableModel.addColumn(POSConstants.VISIBLE, "visible");
        this.tableModel.addColumn(POSConstants.SORT_ORDER, "sortOrder");
        this.tableModel.addColumn(POSConstants.BUTTON_COLOR, "buttonColor");
        this.tableModel.addColumn(POSConstants.TEXT_COLOR, "textColor");
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuGroupExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)this.createSearchPanel(), "North");
        this.add(new JScrollPane((Component)this.table));
        this.createButtonPanel();
    }

    private JPanel createSearchPanel() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("", "[][]10[][]10[]", "[]10[]"));
        northPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("Search")));
        JLabel nameLabel = new JLabel(Messages.getString("NAME"));
        this.tfNameField = new JTextField(20);
        this.tfNameField.addKeyListener(this.doSearchByKeyListener());
        JLabel lblCategory = new JLabel(Messages.getString("MenuItemExplorer.4"));
        this.cbCategory = new JComboBox();
        this.cbCategory.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory category : categories) {
            this.cbCategory.addItem(category);
        }
        JButton btnSearch = new JButton(Messages.getString("Search"));
        btnSearch.addActionListener(this.doSearch());
        JButton btnRefresh = new JButton(POSConstants.REFRESH);
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroupExplorer.this.initData();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        northPanel.add((Component)nameLabel, "align label");
        northPanel.add(this.tfNameField);
        northPanel.add(lblCategory);
        northPanel.add(this.cbCategory);
        northPanel.add(btnSearch);
        northPanel.add(btnRefresh);
        return northPanel;
    }

    private KeyListener doSearchByKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (MenuGroupExplorer.this.tfNameField.getText().length() > 2) {
                    MenuGroupExplorer.this.showMenuGroups();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    MenuGroupExplorer.this.showMenuGroups();
                }
            }
        };
    }

    private ActionListener doSearch() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroupExplorer.this.showMenuGroups();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        };
    }

    private void showMenuGroups() {
        this.showMenuGroups(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMenuGroups(Integer index) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (index != null) {
                this.tableModel.setCurrentRowIndex(index);
            }
            String txName = this.tfNameField.getText();
            Object selectedCategory = this.cbCategory.getSelectedItem();
            MenuCategory category = null;
            if (selectedCategory instanceof MenuCategory) {
                category = (MenuCategory)selectedCategory;
            }
            MenuGroupDAO.getInstance().findGroups(this.tableModel, txName, category);
            this.lblNumberOfItem.setText(this.tableModel.getDisplayText());
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void createButtonPanel() {
        int iconSize = PosUIManager.getSize(16);
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupExplorer.this.showMenuGroups(MenuGroupExplorer.this.tableModel.getPreviousRowIndex());
            }
        });
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupExplorer.this.showMenuGroups(MenuGroupExplorer.this.tableModel.getNextRowIndex());
            }
        });
        this.lblNumberOfItem = new JLabel();
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupExplorer.this.editSelectedRow();
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuGroupForm editor = new MenuGroupForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuGroup foodGroup = (MenuGroup)editor.getBean();
                    MenuGroupExplorer.this.tableModel.addRow(foodGroup);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuGroupExplorer.this.doDeleteGroup();
            }
        });
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel btnPanel = new JPanel();
        JPanel paginationPanel = new JPanel();
        btnPanel.add(addButton);
        btnPanel.add(editButton);
        btnPanel.add(deleteButton);
        paginationPanel.add(this.lblNumberOfItem);
        paginationPanel.add(this.btnBack);
        paginationPanel.add(this.btnForward);
        bottomPanel.add(btnPanel);
        bottomPanel.add((Component)paginationPanel, "East");
        this.add((Component)bottomPanel, "South");
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuGroup menuGroup = this.tableModel.getRow(index);
            MenuGroupForm editor = new MenuGroupForm(menuGroup);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public void initData() {
        this.showMenuGroups();
    }

    private void doDeleteGroup() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuGroup group = this.tableModel.getRow(index);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            MenuItemDAO menuItemDao = new MenuItemDAO();
            boolean hasMenuItems = menuItemDao.existsMenuItem(group);
            if (hasMenuItems && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuGroupExplorer.0"), POSConstants.DELETE) != 0) {
                return;
            }
            MenuGroupDAO foodGroupDAO = new MenuGroupDAO();
            foodGroupDAO.delete(group);
            this.tableModel.removeRow(group);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

