/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;

public class SalesAreaExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<SalesArea> tableModel = new BeanTableModel(SalesArea.class);
    private JButton btnDelete;
    private JButton btnAdd;
    private JButton btnEdit;

    public SalesAreaExplorer() {
        this.tableModel.addColumn("NAME", "name");
        this.tableModel.addColumn(Messages.getString("SalesAreaExplorer.1"), "department");
        List<SalesArea> findAll = SalesAreaDAO.getInstance().findAll();
        this.tableModel.addRows(findAll);
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SalesAreaExplorer.this.table.getSelectedRow() < 0) {
                    // empty if block
                }
            }
        });
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void searchItem() {
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        this.btnAdd = explorerButton.getAddButton();
        this.btnEdit = explorerButton.getEditButton();
        this.btnDelete = explorerButton.getDeleteButton();
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SalesAreaExplorer.this.editSelectedRow();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SalesArea item = new SalesArea();
                    SalesAreaEntryForm editor = new SalesAreaEntryForm(item);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    SalesArea faObj = (SalesArea)editor.getBean();
                    SalesAreaExplorer.this.tableModel.addRow(faObj);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = SalesAreaExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = SalesAreaExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    SalesArea item = (SalesArea)SalesAreaExplorer.this.tableModel.getRow(index);
                    SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
                    salesAreaDAO.delete(item);
                    SalesAreaExplorer.this.tableModel.removeRow(index);
                }
                catch (PosException x) {
                    DetailsInfoDialog dialog = new DetailsInfoDialog(x.getMessage(), x.getDetails());
                    dialog.open();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(this.btnAdd);
        panel.add(this.btnEdit);
        panel.add(this.btnDelete);
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(150);
        columnWidth.add(100);
        columnWidth.add(70);
        columnWidth.add(230);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(85);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(70);
        columnWidth.add(50);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            SalesArea item = this.tableModel.getRow(index);
            item = SalesAreaDAO.getInstance().find(item);
            this.tableModel.setRow(index, item);
            SalesAreaEntryForm editor = new SalesAreaEntryForm(item);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }
}

