/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.explorer.TaxExplorer;
import com.floreantpos.bo.ui.explorer.TaxGroupExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TaxTab
extends JPanel {
    private JTabbedPane tabbedPane;
    private TaxExplorer taxExplorer;
    private TaxGroupExplorer taxGroupExplorer;

    public TaxTab() {
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TaxTab.this.doStateChangeEvent(e);
            }
        });
        this.taxExplorer = new TaxExplorer();
        this.taxGroupExplorer = new TaxGroupExplorer();
        this.tabbedPane.addTab(Messages.getString("TaxTab.0"), this.taxExplorer);
        this.tabbedPane.addTab(Messages.getString("TaxTab.1"), this.taxGroupExplorer);
        this.add(this.tabbedPane);
    }

    private void doStateChangeEvent(ChangeEvent e) {
        try {
            JTabbedPane tPane = (JTabbedPane)e.getSource();
            if (tPane.getSelectedComponent() instanceof TaxExplorer) {
                this.taxExplorer.doRefresh();
            } else if (tPane.getSelectedComponent() instanceof TaxGroupExplorer) {
                this.taxGroupExplorer.doRefreshTree();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
        }
    }
}

