/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesignView;
import com.floreantpos.bo.ui.menudesigner.MenuPageListRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuPageForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.SerializationUtils;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;

public class MenuPageDesigner
extends TransparentPanel
implements RefreshableView {
    private JList<MenuCategory> cbCategory;
    private JList<MenuGroup> cbGroup;
    private MenuPageDesignView menuPageDesignView;
    private JList<MenuPage> listMenuPages;
    private ComboBoxModel menuPageListModel;
    private JButton btnAutoBuildPages;
    private JButton btnHidePage;
    private JButton btnNewPage;
    private JButton btnEditPage;
    private JButton btnRemoveAllPage;
    private JButton btnRemovePage;
    private JButton btnNewCategory;
    private JButton btnNewGroup;
    private JButton btnCopyPage;
    private boolean isPromptToSave = true;

    public MenuPageDesigner() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel topActionPanel = new JPanel(new GridLayout(0, 1));
        JPanel lefQuickAccessPanel = new JPanel(new BorderLayout());
        lefQuickAccessPanel.setPreferredSize(PosUIManager.getSize(300, 0));
        lefQuickAccessPanel.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.0")));
        JPanel rightCategroyPanel = new JPanel();
        rightCategroyPanel.setPreferredSize(PosUIManager.getSize(130, 82));
        this.add((Component)rightCategroyPanel, "East");
        this.cbCategory = new JList(new ComboBoxModel());
        this.cbCategory.addListSelectionListener(e -> this.doRenderSelectedCategory(e));
        this.cbGroup = new JList(new ComboBoxModel());
        this.cbGroup.addListSelectionListener(e -> this.doRenderSelectedGroup(e));
        this.menuPageListModel = new ComboBoxModel();
        this.listMenuPages = new JList(this.menuPageListModel);
        this.listMenuPages.setCellRenderer(new MenuPageListRenderer());
        this.listMenuPages.addListSelectionListener(e -> this.doRenderSelectedPage(e));
        this.listMenuPages.setFocusable(false);
        this.btnNewCategory = new JButton(Messages.getString("MenuPageDesigner.1"));
        this.btnNewGroup = new JButton(Messages.getString("MenuPageDesigner.1"));
        this.btnNewPage = new JButton(Messages.getString("MenuPageDesigner.3"));
        this.btnEditPage = new JButton(Messages.getString("MenuPageDesigner.4"));
        this.btnHidePage = new JButton(Messages.getString("MenuPageDesigner.5"));
        this.btnRemovePage = new JButton(Messages.getString("MenuPageDesigner.6"));
        this.btnCopyPage = new JButton(Messages.getString("MenuPageDesigner.2"));
        this.btnCopyPage.addActionListener(e -> this.doCopyMenuPage());
        this.btnRemovePage.addActionListener(e -> this.doRemovePage());
        this.btnRemoveAllPage = new JButton(Messages.getString("MenuPageDesigner.7"));
        this.btnRemoveAllPage.addActionListener(e -> this.doRemoveAllPage());
        this.btnHidePage.addActionListener(e -> this.doHidePage());
        this.btnNewCategory.addActionListener(e -> this.doAddNewCategory());
        this.btnNewGroup.addActionListener(e -> this.doAddNewGroup());
        this.btnNewPage.addActionListener(e -> this.doAddNewMenuPage());
        this.btnEditPage.addActionListener(e -> this.doEditMenuPage());
        this.btnAutoBuildPages = new JButton(Messages.getString("MenuPageDesigner.10"));
        this.btnAutoBuildPages.addActionListener(e -> this.doGenenateMenuPages());
        JScrollPane categoryScroller = new JScrollPane(this.cbCategory);
        categoryScroller.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.11")));
        topActionPanel.add((Component)categoryScroller, String.format("grow, h %s", 200));
        JScrollPane groupScroller = new JScrollPane(this.cbGroup);
        groupScroller.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.13")));
        topActionPanel.add((Component)groupScroller, String.format("newline, grow, h %s", 200));
        JScrollPane pageScroller = new JScrollPane(this.listMenuPages);
        pageScroller.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.15")));
        topActionPanel.add((Component)pageScroller, String.format("newline, grow, wrap", new Object[0]));
        lefQuickAccessPanel.add(topActionPanel);
        JPanel leftButtonPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        leftButtonPanel.add((Component)this.btnAutoBuildPages, "growx");
        leftButtonPanel.add((Component)this.btnNewPage, "growx");
        leftButtonPanel.add((Component)this.btnEditPage, "growx,wrap");
        leftButtonPanel.add((Component)this.btnHidePage, "growx");
        leftButtonPanel.add((Component)this.btnRemovePage, "growx");
        leftButtonPanel.add((Component)this.btnRemoveAllPage, "growx,wrap");
        leftButtonPanel.add((Component)this.btnCopyPage, "growx,span 3");
        this.btnRemoveAllPage.setEnabled(false);
        lefQuickAccessPanel.add((Component)leftButtonPanel, "South");
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.menuPageDesignView = new MenuPageDesignView();
        JPanel orderTypeSelectionPanel = new JPanel((LayoutManager)new MigLayout("center"));
        orderTypeSelectionPanel.add((Component)new JLabel(POSConstants.ORDER_TYPE), "split 2");
        JPanel itemViewContainer = new JPanel(new BorderLayout());
        itemViewContainer.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        itemViewContainer.add(this.menuPageDesignView);
        contentPanel.add(itemViewContainer);
        this.add((Component)lefQuickAccessPanel, "West");
        this.add(contentPanel);
        this.enableDisablePageButtons(false);
    }

    private void doRenderSelectedPage(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.doSaveChanges();
            this.renderSelectedPage();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void doSaveChanges() {
        if (!this.isPromptToSave) {
            return;
        }
        if (this.menuPageDesignView.isEnabledSaveButton()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.31"), Messages.getString("CONFIRM")) == 0) {
                this.doSaveMenuPage();
            } else {
                this.menuPageDesignView.resetPage();
            }
        }
    }

    protected void doSaveMenuPage() {
        try {
            this.menuPageDesignView.save();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    private void doRemovePage() {
        try {
            this.isPromptToSave = false;
            MenuPage menuPage = this.menuPageDesignView.getMenuPage();
            if (menuPage == null) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.33"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            int selectedIndex = this.listMenuPages.getSelectedIndex();
            MenuPageDAO.getInstance().delete(menuPage);
            this.menuPageListModel.removeElement(menuPage);
            if (this.menuPageListModel.getSize() > 0) {
                this.listMenuPages.setSelectedIndex(selectedIndex - 1);
            } else {
                this.renderSelectedPage();
            }
        }
        catch (StaleStateException ex) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage());
        }
        finally {
            this.isPromptToSave = true;
        }
    }

    private void doCopyMenuPage() {
        MenuPage selectedMenuPage = this.listMenuPages.getSelectedValue();
        MenuPageDAO menuPageDAO = MenuPageDAO.getInstance();
        menuPageDAO.refresh(selectedMenuPage);
        MenuPage newMenuPage = (MenuPage)SerializationUtils.clone((Serializable)selectedMenuPage);
        newMenuPage.setId(null);
        newMenuPage.setVersion(0L);
        newMenuPage.setPageItems(null);
        menuPageDAO.save(newMenuPage);
        menuPageDAO.initialize(selectedMenuPage);
        List<MenuPageItem> pageItems = selectedMenuPage.getPageItems();
        newMenuPage.setPageItems(null);
        if (pageItems != null && pageItems.size() > 0) {
            for (MenuPageItem menuPageItem : pageItems) {
                MenuPageItem newMenuPageItem = (MenuPageItem)SerializationUtils.clone((Serializable)menuPageItem);
                newMenuPageItem.setId(null);
                newMenuPageItem.setMenuPage(newMenuPage);
                newMenuPage.addTopageItems(newMenuPageItem);
            }
        }
        newMenuPage.setName(POSUtil.doDuplicateName(selectedMenuPage.getName()));
        menuPageDAO.saveOrUpdate(newMenuPage);
        this.menuPageListModel.addElement(newMenuPage);
        this.listMenuPages.setSelectedValue(newMenuPage, true);
    }

    private void doRemoveAllPage() {
        try {
            this.isPromptToSave = false;
            List menuPageList = this.menuPageListModel.getDataList();
            if (menuPageList == null || menuPageList.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.35") + this.cbGroup.getSelectedValue() + Messages.getString("MenuPageDesigner.36"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            MenuPageDAO.getInstance().deleteAll(menuPageList);
            this.menuPageListModel.removeAllElements();
            this.btnRemoveAllPage.setEnabled(false);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage());
        }
        finally {
            this.isPromptToSave = true;
        }
    }

    public void initData() {
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
        ComboBoxModel categoryListModel = (ComboBoxModel)this.cbCategory.getModel();
        categoryListModel.setDataList(categories);
    }

    private void renderSelectedPage() {
        try {
            MenuPage menuPage = null;
            if (this.menuPageListModel.getSize() > 0) {
                menuPage = this.listMenuPages.getSelectedValue();
                if (menuPage != null) {
                    this.btnHidePage.setText(menuPage.isVisible() != false ? Messages.getString("MenuPageDesigner.38") : Messages.getString("MenuPageDesigner.39"));
                    this.btnRemoveAllPage.setEnabled(true);
                    this.enableDisablePageButtons(true);
                } else {
                    this.enableDisablePageButtons(false);
                }
            } else {
                this.enableDisablePageButtons(false);
            }
            this.menuPageDesignView.setMenuPage(menuPage);
            this.menuPageDesignView.setEnabledSaveAndCancel(false);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void enableDisablePageButtons(boolean enable) {
        this.btnEditPage.setEnabled(enable);
        this.btnCopyPage.setEnabled(enable);
        this.btnHidePage.setEnabled(enable);
        this.btnRemovePage.setEnabled(enable);
        this.menuPageDesignView.getDetachAllButton().setEnabled(enable);
    }

    public void doCreateNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.40"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        int pageQuatity = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("MenuPageDesigner.42"));
        if (pageQuatity < 1) {
            return;
        }
        ArrayList<MenuPage> menuPages = new ArrayList<MenuPage>();
        for (int i = 0; i < pageQuatity; ++i) {
            MenuPage page = new MenuPage();
            page.setName("Page " + (i + 1));
            menuPages.add(page);
        }
        try {
            MenuPageDAO.getInstance().saveOrUpdatePages(menuPages);
            this.menuPageListModel.setDataList(menuPages);
            this.listMenuPages.setSelectedIndex(0);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    protected List<MenuItem> getSelectedMenuItems(List<MenuItem> selectedItems) {
        MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
        dialog.setSelectionMode(1);
        dialog.setSize(PosUIManager.getSize(750, 515));
        dialog.open();
        if (dialog.isCanceled()) {
            return null;
        }
        List<MenuItem> items = dialog.getSelectedItems();
        MenuPage page = this.listMenuPages.getSelectedValue();
        int pageSize = page.getCols() * page.getRows();
        if (items != null && items.size() > pageSize) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.44") + pageSize);
            return this.getSelectedMenuItems(items);
        }
        return items;
    }

    private void doAddNewCategory() {
        try {
            MenuCategoryForm editor = new MenuCategoryForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuCategory foodCategory = (MenuCategory)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbCategory.getModel();
            model.addElement(foodCategory);
            this.cbCategory.setSelectedValue(foodCategory, true);
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, e2);
        }
    }

    private void doAddNewGroup() {
        try {
            MenuGroup group = new MenuGroup();
            MenuCategory menuCategory = this.cbCategory.getSelectedValue();
            if (menuCategory != null) {
                group.setMenuCategoryId(menuCategory.getId());
            } else {
                group.setMenuCategoryId(null);
            }
            MenuGroupForm editor = new MenuGroupForm(group);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuGroup foodGroup = (MenuGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbGroup.getModel();
            model.addElement(foodGroup);
            this.cbCategory.setSelectedValue(foodGroup, true);
        }
        catch (Exception x) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doGenenateMenuPages() {
        MenuGroup menuGroup = this.cbGroup.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.46"));
            return;
        }
        List<MenuItem> items = MenuItemDAO.getInstance().findByParent(null, menuGroup, false);
        if (items == null || items.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.47"));
            return;
        }
        MenuPageForm editor = new MenuPageForm(new MenuPage(), true);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        MenuPage menuPageWithInfo = (MenuPage)editor.getBean();
        int cols = menuPageWithInfo.getCols();
        int rows = menuPageWithInfo.getRows();
        int totalItemSize = items.size();
        int devideCount = (int)Math.ceil((double)totalItemSize / (double)(cols * rows));
        int loop = devideCount == 0 ? 1 : devideCount;
        ArrayList<MenuPageItem> pageItems = new ArrayList<MenuPageItem>();
        int index = 0;
        int count = 0;
        for (int i = 0; i < loop; ++i) {
            try {
                int totalItemPerPage;
                int size = this.menuPageListModel.getSize();
                MenuPage menuPage = null;
                if (menuPage == null) {
                    menuPage = new MenuPage();
                    menuPage.setMenuGroupId(menuGroup.getId());
                    menuPage.setName(Messages.getString("MenuPageDesigner.48") + (size + 1));
                    menuPage.setRows(rows);
                    menuPage.setCols(cols);
                    menuPage.setSortOrder(i);
                    menuPage.setFlixibleButtonSize(menuPageWithInfo.isFlixibleButtonSize());
                    menuPage.setButtonHeight(menuPageWithInfo.getButtonHeight());
                    menuPage.setButtonWidth(menuPageWithInfo.getButtonWidth());
                    MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                    this.menuPageListModel.addElement(menuPage);
                }
                if (totalItemSize < (totalItemPerPage = cols * rows)) {
                    while (index < items.size()) {
                        MenuPageItem pageItem = new MenuPageItem();
                        pageItem.setMenuPage(menuPage);
                        pageItem.setMenuItem(items.get(index));
                        pageItems.add(pageItem);
                        menuPage.addTopageItems(pageItem);
                        ++index;
                    }
                } else {
                    int sub = 0;
                    while (sub < totalItemPerPage) {
                        MenuPageItem pageItem = new MenuPageItem();
                        pageItem.setMenuPage(menuPage);
                        pageItem.setMenuItem(items.get(index));
                        pageItems.add(pageItem);
                        menuPage.addTopageItems(pageItem);
                        ++sub;
                        ++index;
                    }
                }
                totalItemSize -= totalItemPerPage;
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols && count <= pageItems.size() - 1 && pageItems.get(count) != null; ++count, ++col) {
                        ((MenuPageItem)pageItems.get(count)).setRow(row);
                        ((MenuPageItem)pageItems.get(count)).setCol(col);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                this.listMenuPages.setSelectedValue(menuPage, true);
                continue;
            }
            catch (Exception ex) {
                POSMessageDialog.showError(ex.getMessage());
            }
        }
        this.menuPageDesignView.repaint();
        this.menuPageDesignView.revalidate();
    }

    private void doAddNewMenuPage() {
        this.doSaveChanges();
        MenuGroup selectedGroup = this.cbGroup.getSelectedValue();
        if (selectedGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.49"));
            return;
        }
        try {
            MenuPage page = new MenuPage();
            page.setMenuGroupId(selectedGroup.getId());
            page.setCols(4);
            page.setRows(4);
            int lastNum = this.getRandomNumber();
            page.setName("Page " + lastNum);
            page.setSortOrder(lastNum);
            MenuPageDAO.getInstance().saveOrUpdate(page);
            this.menuPageListModel.addElement(page);
            this.listMenuPages.setSelectedValue(page, true);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private int getRandomNumber() {
        String in = "";
        if (this.menuPageListModel.getSize() > 0) {
            MenuPage lastPage = (MenuPage)this.menuPageListModel.getElementAt(this.menuPageListModel.getSize() - 1);
            in = lastPage.getName();
        }
        Pattern p = Pattern.compile(".* ([0-9]+)");
        Matcher m = p.matcher(in);
        int nextNumber = this.menuPageListModel.getSize() + 1;
        if (m.find()) {
            try {
                int previousNumber = Integer.parseInt(m.group(1));
                if (previousNumber + 1 > nextNumber) {
                    nextNumber = previousNumber + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nextNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEditMenuPage() {
        try {
            this.doSaveChanges();
            this.setCursor(Cursor.getPredefinedCursor(3));
            MenuPage menuPage = this.menuPageDesignView.getMenuPage();
            if (menuPage == null) {
                return;
            }
            MenuPageForm editor = new MenuPageForm(menuPage, false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            menuPage = (MenuPage)editor.getBean();
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            MenuPageDAO.getInstance().refresh(this.listMenuPages.getSelectedValue());
            this.renderSelectedPage();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void refresh() {
        this.menuPageDesignView.refresh();
    }

    private void doHidePage() throws HibernateException {
        try {
            MenuPage selectedPage = this.listMenuPages.getSelectedValue();
            if (selectedPage == null) {
                return;
            }
            selectedPage.setVisible(selectedPage.isVisible() == false);
            MenuPageDAO.getInstance().saveOrUpdate(selectedPage);
            this.btnHidePage.setText(selectedPage.isVisible() != false ? Messages.getString("MenuPageDesigner.8") : Messages.getString("MenuPageDesigner.9"));
            this.listMenuPages.repaint();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void doRenderSelectedGroup(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MenuGroup selectedGroup = this.cbGroup.getSelectedValue();
            this.menuPageListModel.removeAllElements();
            this.listMenuPages.clearSelection();
            if (selectedGroup == null) {
                this.btnRemoveAllPage.setEnabled(false);
                return;
            }
            List<MenuPage> menuPages = MenuPageDAO.getInstance().findByGroup(selectedGroup);
            if (menuPages != null && menuPages.size() > 0) {
                this.menuPageListModel.setDataList(menuPages);
                this.btnRemoveAllPage.setEnabled(true);
            }
            if (this.menuPageListModel.getSize() > 0) {
                this.listMenuPages.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void doRenderSelectedCategory(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MenuCategory selectedCategory = this.cbCategory.getSelectedValue();
            ComboBoxModel groupModel = (ComboBoxModel)this.cbGroup.getModel();
            groupModel.removeAllElements();
            if (selectedCategory == null) {
                return;
            }
            List<MenuGroup> groupList = MenuGroupDAO.getInstance().findByParent(selectedCategory);
            if (groupList != null) {
                groupModel.setDataList(groupList);
                if (groupList.size() > 0) {
                    this.cbGroup.setSelectedValue(groupList.get(0), true);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

