/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.modifierdesigner.DefaultModifierSelectionDialog;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesignView;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageForm;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierPageDesigner
extends TransparentPanel
implements PageSelectionListener {
    private ModifierPageDesignView itemView;
    private MenuItemModifierSpec menuItemModifierSpec;
    private ModifierGroup selectedGroup;
    private MenuItemModifierPage selectedModifierSpecPage;
    private JButton btnEditPage;
    private MenuItem menuItem;
    private PosButton btnNext;
    private PosButton btnPrev;
    private PaginatedListModel dataModel = new PaginatedListModel(1);
    private PosButton btnPageNum;
    private JLabel lblNumberOfItem;
    private JButton btnAddNewPage;
    private JButton btnDeletePage;
    private JButton btnDetachedAll;
    private JButton btnAutoBuild;
    private JButton btnDefaultModifiers;

    public ModifierPageDesigner(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.initComponents();
    }

    public void setMenuItemModifierSpec(MenuItemModifierSpec menuItemModifierSpec) {
        this.menuItemModifierSpec = menuItemModifierSpec;
        if (menuItemModifierSpec.getModifierPages() == null) {
            menuItemModifierSpec.setModifierPages(new HashSet<MenuItemModifierPage>());
        }
        this.dataModel.setCurrentRowIndex(0);
        this.initDataModel();
        this.setDataModel(this.dataModel);
        this.disableAllButton(!menuItemModifierSpec.isEnableModifierGroupSettings());
    }

    public void disableAllButton(boolean enableModifierGroupSettings) {
        this.btnAddNewPage.setEnabled(enableModifierGroupSettings);
        this.btnDeletePage.setEnabled(enableModifierGroupSettings);
        this.btnPageNum.setEnabled(enableModifierGroupSettings);
        this.btnDefaultModifiers.setEnabled(enableModifierGroupSettings);
        this.btnEditPage.setEnabled(enableModifierGroupSettings);
        this.btnAutoBuild.setEnabled(enableModifierGroupSettings);
        this.btnDetachedAll.setEnabled(enableModifierGroupSettings);
        this.itemView.setEnabled(enableModifierGroupSettings);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 0));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.itemView = new ModifierPageDesignView();
        this.itemView.setPageListener(this);
        if (this.menuItem != null) {
            this.itemView.setPizzaItem(this.menuItem.isPizzaType());
        }
        JPanel southItemActionPanel = new JPanel((LayoutManager)new MigLayout("center,fillx, ins 5 5 0 0", "[33%][33%][33%]", ""));
        this.btnDefaultModifiers = new JButton(Messages.getString("ModifierPageDesigner.3"));
        this.btnDefaultModifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModifierPageDesigner.this.menuItemModifierSpec == null) {
                    return;
                }
                ArrayList<MenuModifier> items = new ArrayList<MenuModifier>(ModifierPageDesigner.this.menuItemModifierSpec.getModifiers());
                if (items == null || items.isEmpty()) {
                    return;
                }
                ArrayList<DefaultMenuModifier> modifierList = new ArrayList<DefaultMenuModifier>();
                List<DefaultMenuModifier> defaultModifierList = ModifierPageDesigner.this.menuItemModifierSpec.getDefaultModifierList();
                if (defaultModifierList != null) {
                    modifierList.addAll(defaultModifierList);
                }
                DefaultModifierSelectionDialog dialog = new DefaultModifierSelectionDialog(items, modifierList, (boolean)ModifierPageDesigner.this.menuItem.isPizzaType());
                dialog.setSize(600, 500);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                List<DefaultMenuModifier> selectedModifierList = dialog.getSelectedDefaultModifierList();
                if (defaultModifierList != null) {
                    defaultModifierList.clear();
                    defaultModifierList.addAll(selectedModifierList);
                } else {
                    ModifierPageDesigner.this.menuItemModifierSpec.setDefaultModifierList(selectedModifierList);
                }
            }
        });
        this.btnDetachedAll = new JButton(Messages.getString("ModifierPageDesigner.4"));
        this.btnDetachedAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.doDetachAllItems();
            }
        });
        this.btnAutoBuild = new JButton(Messages.getString("ModifierPageDesigner.5"));
        this.btnAutoBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.doGenenateMenuItemModifierPageItems();
            }
        });
        this.btnEditPage = new JButton(Messages.getString("ModifierPageDesigner.6"));
        this.btnEditPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.editPage();
            }
        });
        southItemActionPanel.add((Component)new JLabel(""), "grow");
        southItemActionPanel.add((Component)this.btnDefaultModifiers, "split 5");
        southItemActionPanel.add(this.btnEditPage);
        southItemActionPanel.add(this.btnAutoBuild);
        southItemActionPanel.add(this.btnDetachedAll);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "", ""));
        int btnSize = PosUIManager.getSize(16);
        this.lblNumberOfItem = new JLabel();
        paginationButtonPanel.add(this.lblNumberOfItem);
        this.btnPrev = new PosButton();
        this.btnPrev.setToolTipText(POSConstants.CAPITAL_PREV);
        this.btnPrev.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_LEFT, (float)btnSize));
        paginationButtonPanel.add((Component)this.btnPrev, "split 5,w 30!, h 24!");
        this.btnPageNum = new PosButton();
        this.btnPageNum.setToolTipText(Messages.getString("EditPage"));
        this.btnPageNum.setBorder(null);
        this.btnPageNum.setOpaque(false);
        this.btnPageNum.setContentAreaFilled(false);
        this.btnPageNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModifierPageDesigner.this.btnPageNum.isEnabled()) {
                    ModifierPageDesigner.this.editPage();
                }
            }
        });
        paginationButtonPanel.add((Component)this.btnPageNum, "h 35!");
        this.btnPageNum.setVisible(false);
        this.btnNext = new PosButton();
        this.btnNext.setToolTipText(POSConstants.CAPITAL_NEXT);
        this.btnNext.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_RIGHT, (float)btnSize));
        paginationButtonPanel.add((Component)this.btnNext, "w 30!,h 24!");
        this.btnAddNewPage = new JButton(IconFontSwing.buildIcon((IconCode)FontAwesome.PLUS_CIRCLE, (float)btnSize));
        this.btnAddNewPage.setToolTipText(Messages.getString("AddNewPage"));
        paginationButtonPanel.add((Component)this.btnAddNewPage, "w 30!,h 24!");
        this.btnDeletePage = new JButton(IconFontSwing.buildIcon((IconCode)FontAwesome.TRASH, (float)btnSize));
        this.btnDeletePage.setToolTipText(Messages.getString("DeletePage"));
        paginationButtonPanel.add((Component)this.btnDeletePage, "w 30!,h 24!");
        JPanel southButtonPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 3 3"));
        southButtonPanel.add((Component)southItemActionPanel, "center, wrap");
        southButtonPanel.add((Component)paginationButtonPanel, "center");
        this.add((Component)southButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == ModifierPageDesigner.this.btnPrev) {
                        ModifierPageDesigner.this.scrollUp();
                    } else if (source == ModifierPageDesigner.this.btnNext) {
                        ModifierPageDesigner.this.scrollDown();
                    } else if (source == ModifierPageDesigner.this.btnAddNewPage) {
                        ModifierPageDesigner.this.createNewPage();
                    } else if (source == ModifierPageDesigner.this.btnDeletePage) {
                        ModifierPageDesigner.this.deletePage();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnAddNewPage.addActionListener(action);
        this.btnDeletePage.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
        TitledBorder border = new TitledBorder(POSConstants.MODIFIERS);
        border.setTitleJustification(2);
        this.itemView.setBorder(new CompoundBorder(border, null));
        contentPanel.add(this.itemView);
        this.add(contentPanel);
    }

    public void rendererSelectedGroup() {
        this.initDataModel();
        if (this.selectedGroup != null) {
            if (this.selectedModifierSpecPage.getModifierSpec() == null) {
                this.selectedModifierSpecPage.setModifierSpec(this.menuItemModifierSpec);
            }
            this.itemView.setMenuItemModifierPage(this.selectedModifierSpecPage);
        }
    }

    private void doDetachAllItems() {
        if (this.selectedModifierSpecPage == null || this.selectedModifierSpecPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.18"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.19"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        if (this.selectedModifierSpecPage.getPageItems() != null) {
            this.selectedModifierSpecPage.getPageItems().clear();
        }
        this.itemView.setMenuItemModifierPage(this.selectedModifierSpecPage);
    }

    public void doGenenateMenuItemModifierPageItems() {
        if (this.selectedGroup == null) {
            return;
        }
        List<MenuModifier> items = this.selectedGroup.getModifiers();
        if (items == null || items.isEmpty()) {
            return;
        }
        try {
            if (this.selectedModifierSpecPage == null) {
                this.doCreateNewPage();
            }
            int pageItemCount = this.selectedModifierSpecPage.getRows() * this.selectedModifierSpecPage.getCols();
            int itemSize = items.size();
            ArrayList<MenuItemModifierPageItem> pageItems = new ArrayList<MenuItemModifierPageItem>();
            if (items.size() > 0) {
                Collections.sort(items, (O1, O2) -> O1.getSortOrder().compareTo(O2.getSortOrder()));
                int count = 1;
                for (MenuModifier modifier : items) {
                    if (this.modifierAlreadyExist(modifier)) continue;
                    MenuItemModifierPageItem pageItem = new MenuItemModifierPageItem();
                    pageItem.setMenuModifier(modifier);
                    pageItem.setParentPage(this.selectedModifierSpecPage);
                    pageItems.add(pageItem);
                    if (count == pageItemCount || itemSize == count) {
                        this.itemView.fillSelectedPageItems(pageItems);
                        if (itemSize == count) break;
                        this.doCreateNewPage();
                        pageItems = new ArrayList();
                        itemSize -= count;
                        count = 1;
                        this.setDataModel(this.dataModel);
                        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
                        continue;
                    }
                    ++count;
                }
                this.setDataModel(this.dataModel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BOMessageDialog.showError(ex.getMessage());
        }
    }

    private boolean modifierAlreadyExist(MenuModifier menuModifier) {
        List<MenuItemModifierPageItem> pageItems;
        if (this.selectedModifierSpecPage != null && (pageItems = this.selectedModifierSpecPage.getPageItems()) != null && pageItems.size() != 0) {
            for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                String modifierId = menuItemModifierPageItem.getMenuModifierId();
                if (modifierId == null || !modifierId.equals(menuModifier.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void doCreateNewPage() {
        this.selectedModifierSpecPage = new MenuItemModifierPage();
        this.selectedModifierSpecPage.setName(Messages.getString("ModifierPageDesigner.21") + (this.menuItemModifierSpec.getModifierPages().size() + 1));
        this.selectedModifierSpecPage.setButtonHeight(100);
        this.selectedModifierSpecPage.setButtonWidth(100);
        this.selectedModifierSpecPage.setRows(4);
        this.selectedModifierSpecPage.setCols(4);
        this.selectedModifierSpecPage.setVisible(true);
        this.selectedModifierSpecPage.setSortOrder(this.menuItemModifierSpec.getModifierPages().size() + 1);
        this.selectedModifierSpecPage.setFlixibleButtonSize(false);
        this.selectedModifierSpecPage.setModifierSpecId(this.menuItemModifierSpec.getId());
        this.menuItemModifierSpec.addTomodifierPages(this.selectedModifierSpecPage);
        this.dataModel.getDataList().add(this.selectedModifierSpecPage);
        this.dataModel.setNumRows(this.menuItemModifierSpec.getModifierPages().size());
    }

    public void setDataModel() {
        this.setDataModel(this.dataModel);
    }

    private void setDataModel(PaginatedListModel dataModel) {
        this.rendererSelectedGroup();
        this.selectedModifierSpecPage.setName(Messages.getString("ModifierPageDesigner.21") + (dataModel.getCurrentRowIndex() + 1));
        this.btnPageNum.setText(this.selectedModifierSpecPage.getName());
        this.btnPageNum.setVisible(StringUtils.isNotEmpty((String)this.selectedModifierSpecPage.getName()));
        int startNumber = dataModel.getCurrentRowIndex() + 1;
        int endNumber = dataModel.getNextRowIndex();
        int totalNumber = dataModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MenuItemExplorer.40"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(dataModel.hasPrevious());
        this.btnNext.setEnabled(dataModel.hasNext());
    }

    private void initDataModel() {
        this.selectedGroup = this.menuItemModifierSpec.getModifierGroup();
        Set<MenuItemModifierPage> modifierPages = this.menuItemModifierSpec.getModifierPages();
        if (modifierPages == null) {
            modifierPages = new HashSet<MenuItemModifierPage>();
        }
        ArrayList<MenuItemModifierPage> pages = new ArrayList<MenuItemModifierPage>();
        for (MenuItemModifierPage page : modifierPages) {
            page.setModifierSpec(this.menuItemModifierSpec);
            pages.add(page);
        }
        Collections.sort(pages, new Comparator<MenuItemModifierPage>(){

            @Override
            public int compare(MenuItemModifierPage o1, MenuItemModifierPage o2) {
                return o1.getSortOrder() - o2.getSortOrder();
            }
        });
        this.dataModel.setNumRows(pages.size());
        this.dataModel.setData(pages);
        int size = this.dataModel.getSize();
        if (size > 0) {
            if (size <= this.dataModel.getCurrentRowIndex()) {
                this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(0);
                this.dataModel.setCurrentRowIndex(0);
            } else {
                this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
            }
        } else {
            this.doCreateNewPage();
        }
    }

    private void createNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.22"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        this.doCreateNewPage();
        this.itemSelected(this.selectedModifierSpecPage);
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void deletePage() {
        if (this.dataModel.getSize() <= 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.100"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageDesigner.99"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        int nextFocusIndex = this.dataModel.getCurrentRowIndex();
        if (this.dataModel.hasPrevious()) {
            nextFocusIndex = this.dataModel.getPreviousRowIndex();
        } else if (this.dataModel.hasNext()) {
            nextFocusIndex = this.dataModel.getNextRowIndex() - 1;
        }
        this.menuItemModifierSpec.getModifierPages().remove(this.selectedModifierSpecPage);
        this.dataModel.getDataList().remove(this.selectedModifierSpecPage);
        int rows = this.menuItemModifierSpec.getModifierPages().size();
        this.dataModel.setNumRows(rows);
        this.dataModel.setCurrentRowIndex(nextFocusIndex);
        if (rows >= 1) {
            this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
            this.setDataModel(this.dataModel);
        }
    }

    public MenuItemModifierSpec getMenuItemModifierSpec() {
        return this.menuItemModifierSpec;
    }

    public void reset() {
        this.itemView.reset();
        this.itemView.revalidate();
        this.itemView.repaint();
    }

    public void editPage() {
        if (this.selectedModifierSpecPage == null) {
            POSMessageDialog.showMessage(this, Messages.getString("ModifierPageDesigner.24"));
            return;
        }
        ModifierPageForm form = new ModifierPageForm(this.selectedModifierSpecPage);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.rendererSelectedGroup();
    }

    @Override
    public void itemSelected(Object item) {
    }

    @Override
    public void uiUpdate() {
    }
}

