/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AddPrinterGroupDialog
extends POSDialog {
    private static final String EMPTY_SPACE_STRING = " ";
    private FixedLengthTextField tfName = new FixedLengthTextField(60);
    private CheckBoxList<VirtualPrinter> printerList;
    private JCheckBox chkDefault;
    private PrinterGroup printerGroup;
    private List<VirtualPrinter> printers;

    public AddPrinterGroupDialog() throws HeadlessException {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle(Messages.getString("AddPrinterGroupDialog.0"));
        this.init();
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        this.add(new JLabel(Messages.getString("AddPrinterGroupDialog.4")));
        this.add((Component)this.tfName, "grow, wrap");
        this.chkDefault = new JCheckBox(Messages.getString("AddPrinterGroupDialog.1"));
        this.add((Component)new JLabel(), "grow");
        this.add((Component)this.chkDefault, "wrap");
        this.printers = VirtualPrinterDAO.getInstance().findKitchenPrinters();
        this.printerList = new CheckBoxList<VirtualPrinter>(new Vector<VirtualPrinter>(this.printers));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(new TitledBorder(Messages.getString("AddPrinterGroupDialog.6")));
        listPanel.add(new JScrollPane(this.printerList));
        this.add((Component)listPanel, "newline, span 2, grow");
        JPanel panel = new JPanel();
        contentPane.add((Component)panel, "cell 0 4 3 1,grow");
        JButton btnOk = new JButton(Messages.getString("OK"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = AddPrinterGroupDialog.this.tfName.getText();
                if (StringUtils.isEmpty((String)name)) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("AddPrinterGroupDialog.10"));
                    return;
                }
                List checkedValues = AddPrinterGroupDialog.this.printerList.getCheckedValues();
                if (checkedValues == null || checkedValues.size() == 0) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("AddPrinterGroupDialog.11"));
                    return;
                }
                PrinterGroup printerGroupFromDB = PrinterGroupDAO.getInstance().findByName(name);
                if (AddPrinterGroupDialog.this.printerGroup == null && printerGroupFromDB != null && !printerGroupFromDB.isDeleted().booleanValue()) {
                    String message = name + AddPrinterGroupDialog.EMPTY_SPACE_STRING + Messages.getString("AddPrinterGroupDialog.3");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                    return;
                }
                AddPrinterGroupDialog.this.setCanceled(false);
                AddPrinterGroupDialog.this.dispose();
            }
        });
        panel.add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("CANCEL"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddPrinterGroupDialog.this.setCanceled(true);
                AddPrinterGroupDialog.this.dispose();
            }
        });
        panel.add(btnCancel);
    }

    public PrinterGroup getPrinterGroup() {
        String name = this.tfName.getText().trim();
        PrinterGroup printerGroup = PrinterGroupDAO.getInstance().findByName(name);
        if (this.printerGroup == null && printerGroup != null && printerGroup.isDeleted().booleanValue()) {
            this.printerGroup = printerGroup;
        }
        if (this.printerGroup == null) {
            this.printerGroup = new PrinterGroup();
            this.printerGroup.setPrinterNames(new ArrayList<String>());
        } else {
            this.printerGroup.setDeleted(Boolean.FALSE);
            this.printerGroup.getPrinterNames().clear();
        }
        this.printerGroup.setName(name);
        this.printerGroup.setIsDefault(this.chkDefault.isSelected());
        List<VirtualPrinter> checkedValues = this.printerList.getCheckedValues();
        if (checkedValues != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (VirtualPrinter p : checkedValues) {
                names.add(p.getName());
            }
            this.printerGroup.getPrinterNames().addAll(names);
        }
        return this.printerGroup;
    }

    public void setPrinterGroup(PrinterGroup group) {
        this.printerGroup = group;
        this.tfName.setText(group.getName());
        this.chkDefault.setSelected(group.isIsDefault());
        Vector<VirtualPrinter> selectedPrinters = new Vector<VirtualPrinter>();
        for (VirtualPrinter printer : this.printers) {
            if (!this.printerGroup.getPrinterNames().contains(printer.getName())) continue;
            selectedPrinters.add(printer);
        }
        this.printerList.selectItems(selectedPrinters);
    }
}

