/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.CardReader;
import com.floreantpos.swing.POSTextField;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import net.miginfocom.swing.MigLayout;

public class DefaultPosGiftCardConfigurationView
extends ConfigurationView {
    private POSTextField tfMerchantAccount;
    private JComboBox cbCardReader;
    private JPasswordField tfMerchantPass;
    private JCheckBox chckbxAllowMagneticSwipe;
    private JCheckBox chckbxAllowCardManual;

    public DefaultPosGiftCardConfigurationView() {
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        JLabel lblMagneticCardReader = new JLabel(Messages.getString("CardConfigurationView.9"));
        this.add((Component)lblMagneticCardReader, "cell 0 3,alignx leading");
        this.cbCardReader = new JComboBox();
        this.cbCardReader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPosGiftCardConfigurationView.this.updateCheckBoxes();
            }
        });
        this.add((Component)this.cbCardReader, "cell 1 3,growx");
        JLabel lblMerchantAccount = new JLabel(Messages.getString("CardConfigurationView.19"));
        this.add((Component)lblMerchantAccount, "cell 0 5,alignx leading");
        this.tfMerchantAccount = new POSTextField();
        this.add((Component)this.tfMerchantAccount, "cell 1 5,growx");
        JLabel lblSecretCode = new JLabel(Messages.getString("CardConfigurationView.22"));
        this.add((Component)lblSecretCode, "cell 0 6,alignx leading");
        this.cbCardReader.setModel(new DefaultComboBoxModel<CardReader>(CardReader.values()));
        this.tfMerchantPass = new JPasswordField();
        this.add((Component)this.tfMerchantPass, "cell 1 6,growx");
        this.chckbxAllowMagneticSwipe = new JCheckBox(Messages.getString("CardConfigurationView.3"));
        this.chckbxAllowMagneticSwipe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPosGiftCardConfigurationView.this.updateCardList();
            }
        });
        this.add((Component)this.chckbxAllowMagneticSwipe, "skip 1, newline");
        this.chckbxAllowCardManual = new JCheckBox(Messages.getString("CardConfigurationView.5"));
        this.chckbxAllowCardManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultPosGiftCardConfigurationView.this.updateCardList();
            }
        });
        this.add((Component)this.chckbxAllowCardManual, "skip 1, newline");
    }

    private void openBrowser(String link) throws Exception {
        URI uri = new URI(link);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(uri);
        }
    }

    @Override
    public void initialize() throws Exception {
        String merchantPass;
        this.chckbxAllowMagneticSwipe.setSelected(GiftCardConfig.isSwipeCardSupported());
        this.chckbxAllowCardManual.setSelected(GiftCardConfig.isManualEntrySupported());
        CardReader card = GiftCardConfig.getCardReader();
        this.cbCardReader.setSelectedItem((Object)card);
        String merchantAccount = GiftCardConfig.getMerchantAccount();
        if (merchantAccount != null) {
            this.tfMerchantAccount.setText(merchantAccount);
        }
        if ((merchantPass = GiftCardConfig.getMerchantPass()) != null) {
            this.tfMerchantPass.setText(merchantPass);
        }
        this.updateCardList();
    }

    public void setMerchantDefaultValue(String accountNo, String pass) {
        this.tfMerchantAccount.setText(accountNo);
        this.tfMerchantPass.setText(pass);
    }

    protected void updateCheckBoxes() {
        CardReader selectedItem = (CardReader)((Object)this.cbCardReader.getSelectedItem());
        if (selectedItem == CardReader.SWIPE) {
            this.chckbxAllowMagneticSwipe.setSelected(true);
        } else if (selectedItem == CardReader.MANUAL) {
            this.chckbxAllowCardManual.setSelected(true);
        }
    }

    private DefaultComboBoxModel<CardReader> createComboBoxModel(Vector items) {
        DefaultComboBoxModel<CardReader> model = new DefaultComboBoxModel<CardReader>();
        for (Object object : items) {
            model.addElement((CardReader)((Object)object));
        }
        return model;
    }

    protected void updateCardList() {
        boolean swipeSupported = this.chckbxAllowMagneticSwipe.isSelected();
        boolean manualSupported = this.chckbxAllowCardManual.isSelected();
        CardReader currentReader = (CardReader)((Object)this.cbCardReader.getSelectedItem());
        Vector<CardReader> readers = new Vector<CardReader>(3);
        if (swipeSupported) {
            readers.add(CardReader.SWIPE);
        }
        if (manualSupported) {
            readers.add(CardReader.MANUAL);
        }
        this.cbCardReader.setModel(this.createComboBoxModel(readers));
        if (readers.contains((Object)currentReader)) {
            this.cbCardReader.setSelectedItem((Object)currentReader);
        }
        if (!swipeSupported && !manualSupported) {
            this.cbCardReader.setEnabled(false);
            this.tfMerchantAccount.setEnabled(false);
            this.tfMerchantPass.setEnabled(false);
        } else {
            this.cbCardReader.setEnabled(true);
            this.tfMerchantAccount.setEnabled(true);
            this.tfMerchantPass.setEnabled(true);
        }
        if (swipeSupported || manualSupported) {
            this.tfMerchantAccount.setEnabled(true);
            this.tfMerchantPass.setEnabled(true);
        } else {
            this.tfMerchantAccount.setEnabled(false);
            this.tfMerchantPass.setEnabled(false);
        }
    }

    @Override
    public boolean save() throws Exception {
        GiftCardConfig.setSwipeCardSupported(this.chckbxAllowMagneticSwipe.isSelected());
        GiftCardConfig.setManualEntrySupported(this.chckbxAllowCardManual.isSelected());
        CardReader cardReader = (CardReader)((Object)this.cbCardReader.getSelectedItem());
        GiftCardConfig.setCardReader(cardReader);
        GiftCardConfig.setMerchantAccount(this.tfMerchantAccount.getText());
        GiftCardConfig.setMerchantPass(new String(this.tfMerchantPass.getPassword()));
        return true;
    }

    @Override
    public String getName() {
        return "";
    }
}

