/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class StoreBrandingConfigurationView
extends ConfigurationView {
    private Store store;
    private JLabel lblLogoPreview = new JLabel("");
    private JButton btnClearLogoImage = new JButton(POSConstants.CLEAR);
    private ImageResource logoImageResource;
    private JLabel lblImagePreview = new JLabel("");
    private JButton btnClearImage = new JButton(POSConstants.CLEAR);
    private ImageResource imageResource;

    public StoreBrandingConfigurationView(Store store) {
        this.store = store;
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][][]", ""));
        JPanel tabBrandingForLogoPanel = new JPanel((LayoutManager)new MigLayout("fillx", "grow"));
        TitledBorder border = BorderFactory.createTitledBorder(null, Messages.getString("StoreBrandingConfigurationView.4"), 2, 0);
        tabBrandingForLogoPanel.setBorder(border);
        this.lblLogoPreview.setBorder(border);
        this.lblLogoPreview.setHorizontalAlignment(0);
        this.lblLogoPreview.setBorder(new EtchedBorder(1, null, null));
        this.lblLogoPreview.setPreferredSize(PosUIManager.getSize(128, 128));
        JButton btnSelectLogoImage = new JButton("...");
        tabBrandingForLogoPanel.add((Component)this.lblLogoPreview, "center");
        btnSelectLogoImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreBrandingConfigurationView.this.doSelectLogoImageFile();
            }
        });
        this.btnClearLogoImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreBrandingConfigurationView.this.doClearLogoImage();
            }
        });
        JPanel tabBrandingForLogingScreenPanel = new JPanel();
        tabBrandingForLogingScreenPanel.setLayout((LayoutManager)new MigLayout("fillx", "grow"));
        TitledBorder border1 = BorderFactory.createTitledBorder(null, Messages.getString("StoreBrandingConfigurationView.8"), 2, 0);
        tabBrandingForLogingScreenPanel.setBorder(border1);
        this.lblImagePreview.setBorder(border1);
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(new EtchedBorder(1, null, null));
        this.lblImagePreview.setPreferredSize(PosUIManager.getSize(400, 250));
        JButton btnSelectImage = new JButton("...");
        tabBrandingForLogingScreenPanel.add((Component)this.lblImagePreview, "center");
        btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreBrandingConfigurationView.this.doSelectImageFile();
            }
        });
        this.btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreBrandingConfigurationView.this.doClearImage();
            }
        });
        contentPanel.add((Component)tabBrandingForLogoPanel, "grow");
        contentPanel.add((Component)this.btnClearLogoImage, "split 2");
        contentPanel.add((Component)btnSelectLogoImage, "wrap");
        contentPanel.add((Component)tabBrandingForLogingScreenPanel, "grow");
        contentPanel.add((Component)this.btnClearImage, "split 2");
        contentPanel.add(btnSelectImage);
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle(Messages.getString("StoreBrandingConfigurationView.15"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.setSelectBtnVisible(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getButtonBigImage());
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    protected void doSelectLogoImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setSelectBtnVisible(true);
        dialog.setTitle(Messages.getString("StoreBrandingConfigurationView.16"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.logoImageResource = dialog.getImageResource();
        if (this.logoImageResource != null) {
            this.lblLogoPreview.setIcon(this.logoImageResource.getButtonBigImage());
        }
    }

    protected void doClearLogoImage() {
        this.lblLogoPreview.setIcon(null);
        this.logoImageResource = null;
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        if (this.logoImageResource != null) {
            this.store.addProperty("logo.imageid", this.logoImageResource.getId());
            ImageIcon storeLogo = new ImageIcon(this.logoImageResource.getImage());
            if (storeLogo.getIconWidth() > 128 || storeLogo.getIconHeight() > 128) {
                storeLogo = new ImageIcon(POSUtil.getScaledImage(this.logoImageResource.getImage(), 128, 128));
            }
            this.store.setStoreLogo(storeLogo);
        } else {
            this.store.addProperty("logo.imageid", null);
        }
        if (this.imageResource != null) {
            this.store.setLoginScreenBackgroundId(this.imageResource.getId());
        } else {
            this.store.addProperty("loginscreen.background", null);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.logoImageResource = ImageResourceDAO.getInstance().findById(this.store.getImageId());
        if (this.logoImageResource != null) {
            this.lblLogoPreview.setIcon(this.logoImageResource.getButtonBigImage());
        }
        this.imageResource = ImageResourceDAO.getInstance().findById(this.store.getProperty("loginscreen.background"));
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getButtonBigImage());
        }
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return Messages.getString("StoreBrandingConfigurationView.17");
    }
}

