/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.customer.clubmember.MemberHistoryDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class CustomerExplorer
extends TransparentPanel {
    private PosTable table;
    private BeanTableModel<Customer> tableModel;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JTextField tfSearch;

    public CustomerExplorer() {
        this.initComponents();
        this.updateCustomer();
    }

    private void initComponents() {
        this.tableModel = new BeanTableModel(Customer.class, 50);
        this.tableModel.addColumn("MEMBER ID", "memberId");
        this.tableModel.addColumn("NAME", "name");
        this.tableModel.addColumn("TELEPHONE", "mobileNo");
        this.tableModel.addColumn("EMAIL", "email");
        this.tableModel.addColumn("DOB", "formattedDob");
        this.tableModel.addColumn("CREDIT LIMIT", "creditLimit", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("CREDIT SPENT", "creditSpent", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("BALANCE", "balance", 11, BeanTableModel.DataType.MONEY);
        this.table = new PosTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, new CustomCellRenderer());
        PosGuiUtil.setColumnWidth((JTable)((Object)this.table), 0, 40);
        this.setLayout(new BorderLayout(5, 5));
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 10"));
        JLabel lblSearchTxt = new JLabel(POSConstants.NAME + ": ");
        this.tfSearch = new JTextField(20);
        this.tfSearch.addActionListener(e -> this.updateCustomer());
        JButton btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        btnSearch.addActionListener(e -> this.updateCustomer());
        JButton btnClear = new JButton(POSConstants.CLEAR);
        btnClear.addActionListener(e -> {
            this.tfSearch.setText("");
            this.updateCustomer();
        });
        searchPanel.add((Component)lblSearchTxt, "split 4");
        searchPanel.add((Component)this.tfSearch, "");
        searchPanel.add(btnSearch);
        searchPanel.add(btnClear);
        this.add((Component)searchPanel, "North");
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        JButton btnHistory = new JButton(Messages.getString("CustomerExplorer.7"));
        btnHistory.addActionListener(e -> this.showMemberHistory());
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(e -> this.doAddMember());
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(e -> this.doEditMember());
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(e -> this.doDeleteMember());
        JButton btnDeleteAll = new JButton(POSConstants.DELETE_ALL);
        btnDeleteAll.addActionListener(e -> this.doDeleteAllMember());
        this.btnBack = new JButton("<<< " + Messages.getString("CustomerExplorer.9"));
        this.btnForward = new JButton(Messages.getString("CustomerExplorer.10") + " >>>");
        this.lblNumberOfItem = new JLabel();
        this.btnBack.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
            this.updateCustomer();
        });
        this.btnForward.addActionListener(e -> {
            this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
            this.updateCustomer();
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        panel.add((Component)editButton, "right, split 2");
        panel.add(deleteButton);
        panel.add((Component)this.lblNumberOfItem, "right, split 3");
        panel.add(this.btnBack);
        panel.add(this.btnForward);
        this.add((Component)panel, "South");
    }

    private void updateCustomer() {
        String searchString = this.tfSearch.getText();
        CustomerDAO.getInstance().findByPhoneOrName(searchString, this.tableModel);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("CustomerExplorer.0"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    protected void showMemberHistory() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("CustomerExplorer.16"));
                return;
            }
            Customer customer = this.tableModel.getRow(index);
            MemberHistoryDialog historyDialog = new MemberHistoryDialog(customer.getId(), false);
            historyDialog.open();
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doAddMember() {
        try {
            boolean setKeyPad = true;
            CustomerForm editor = new CustomerForm(setKeyPad);
            editor.enableCustomerFields(true);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog dialog = new BeanEditorDialog(windowAncestor, (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(960, 720));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            Customer customer = (Customer)editor.getBean();
            this.tableModel.addRow(customer);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doEditMember() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            Customer customer = this.tableModel.getRow(index);
            boolean setKeyPad = true;
            CustomerForm editor = new CustomerForm(setKeyPad);
            editor.enableCustomerFields(true);
            editor.setBean(customer);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog dialog = new BeanEditorDialog(windowAncestor, (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(960, 720));
            editor.addExtraButton();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteMember() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Customer customer = this.tableModel.getRow(index);
                CustomerDAO dao = new CustomerDAO();
                dao.delete(customer);
                this.tableModel.removeRow(customer);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doDeleteAllMember() {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                List<Customer> customerList = this.tableModel.getRows();
                if (customerList == null) {
                    return;
                }
                CustomerDAO dao = new CustomerDAO();
                boolean isDeleted = dao.deleteAll(customerList);
                if (isDeleted) {
                    this.tableModel.removeAll();
                }
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

