/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.CustomerTicketListView;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.DefaultOrderServiceExtension;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class MemberHistoryView
extends JPanel
implements ITicketList,
TicketListUpdateListener {
    private OrderServiceExtension orderServiceExtension;
    private PosButton btnOrderInfo = new PosButton(POSConstants.ORDER_INFO_BUTTON_TEXT);
    private CustomerTicketListView ticketList;
    private TitledBorder ticketsListPanelBorder;
    private String memberId;
    private boolean ticketReordered;

    public MemberHistoryView(String memberId) {
        this.memberId = memberId;
        this.ticketList = new CustomerTicketListView(memberId);
        this.initComponents();
        this.btnOrderInfo.addActionListener(e -> this.doShowOrderInfo());
        this.orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (this.orderServiceExtension == null) {
            this.orderServiceExtension = new DefaultOrderServiceExtension();
        }
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.ticketList.updateTicketList();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        JPanel centerPanel = new JPanel(new BorderLayout(5, 5));
        JPanel ticketsAndActivityPanel = new JPanel(new BorderLayout(5, 5));
        this.ticketsListPanelBorder = BorderFactory.createTitledBorder(null, "Tickets", 2, 0);
        JPanel activityPanel = this.createActivityPanel();
        ticketsAndActivityPanel.setBorder(new CompoundBorder(this.ticketsListPanelBorder, new EmptyBorder(2, 2, 2, 2)));
        ticketsAndActivityPanel.add((Component)this.ticketList, "Center");
        ticketsAndActivityPanel.add((Component)activityPanel, "South");
        centerPanel.add((Component)ticketsAndActivityPanel, "Center");
        this.add((Component)centerPanel, "Center");
    }

    private JPanel createActivityPanel() {
        JPanel activityPanel = new JPanel(new BorderLayout(5, 5));
        JPanel innerActivityPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fill, ins 0", "fill, grow", ""));
        JPanel firstRowButtonPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, center, ins 0"));
        if (Application.getInstance().getTerminal().isHasCashDrawer().booleanValue()) {
            firstRowButtonPanel.add((Component)this.btnOrderInfo, "grow");
        } else {
            firstRowButtonPanel.add(this.btnOrderInfo);
        }
        innerActivityPanel.add(firstRowButtonPanel);
        PosButton btnCancel = new PosButton(POSConstants.CLOSE.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemberHistoryView.this.closeDialog(false);
            }
        });
        firstRowButtonPanel.add(btnCancel);
        activityPanel.add(innerActivityPanel);
        return activityPanel;
    }

    private void doShowOrderInfo() {
        try {
            Ticket selectedTicket = this.ticketList.getFirstSelectedTicket();
            if (selectedTicket == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a ticket first.");
                return;
            }
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            ticketsToShow.add(TicketDAO.getInstance().loadFullTicket(selectedTicket.getId()));
            OrderInfoView view = new OrderInfoView(ticketsToShow);
            OrderInfoDialog dialog = new OrderInfoDialog(view);
            dialog.setSize(500, 600);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
            this.ticketReordered = dialog.isReorder();
            if (this.ticketReordered) {
                this.closeDialog(true);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(false);
            windowAncestor.dispose();
        }
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            POSMessageDialog.showMessage(this, Messages.getString("SwitchboardView.22"));
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    @Override
    public Ticket getSelectedTicket() {
        List<Ticket> selectedTickets = this.ticketList.getSelectedTickets();
        if (selectedTickets.size() == 0 || selectedTickets.size() > 1) {
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    @Override
    public void ticketListUpdated() {
        String title = POSConstants.OPEN_TICKETS_AND_ACTIVITY;
        this.ticketsListPanelBorder.setTitle(title);
    }

    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public void updateTicketList() {
        this.ticketList.updateTicketList();
    }

    public boolean isTicketReordered() {
        return this.ticketReordered;
    }
}

