/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Customer;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class MemberPreferenceDialog
extends POSDialog {
    private HashMap<String, Set<String>> preferenceMap;
    private JTabbedPane jtpPreference = new JTabbedPane();
    private Customer member;

    public MemberPreferenceDialog(Customer member) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.member = member;
        this.setTitle(Messages.getString("MemberPreferenceDialog.0"));
        this.initComponents();
        this.initData();
    }

    private void initData() {
        String[][] prefCategories;
        for (String[] category : prefCategories = new String[][]{{"allergy", Messages.getString("MemberPreferenceDialog.1")}, {"foodPref", Messages.getString("MemberPreferenceDialog.2")}, {"drinkPref", Messages.getString("MemberPreferenceDialog.3")}, {"specialPref", Messages.getString("MemberPreferenceDialog.4")}}) {
            String property = this.member.getProperty(category[0]);
            JTextArea textArea = new JTextArea(property);
            textArea.setEditable(false);
            textArea.setWrapStyleWord(true);
            this.jtpPreference.add(category[1], new PosScrollPane(textArea));
        }
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        centerPanel.add((Component)this.jtpPreference, "grow");
        this.add((Component)centerPanel, "Center");
        PosButton btnClose = new PosButton(POSConstants.CLOSE);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemberPreferenceDialog.this.setCanceled(true);
                MemberPreferenceDialog.this.dispose();
            }
        });
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center"));
        footerPanel.add((Component)btnClose, "grow");
        this.add((Component)footerPanel, "South");
    }

    private class PreferenceTab
    extends JPanel {
        private PreferenceTab() {
        }
    }

    public class PreferencePanel
    extends JPanel {
        private Set<String> preferences;
        private DefaultListModel<String> model;

        public PreferencePanel(Set<String> preferences) {
            this.preferences = preferences;
            this.initGui();
            this.initData();
        }

        private void initData() {
            for (String pre : this.preferences) {
                this.model.addElement(pre);
            }
        }

        private void initGui() {
            this.setLayout(new BorderLayout());
            JList<String> list = new JList<String>();
            list.setFixedCellHeight(40);
            this.model = new DefaultListModel();
            list.setModel(this.model);
            this.add(new PosScrollPane(list));
        }
    }
}

