/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer.clubmember;

import com.floreantpos.PosException;
import com.floreantpos.customer.TransactionListTableModel;
import com.floreantpos.customer.clubmember.ClubMemberSelectionView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.foretees.salesforce.sync.SFConnectionException;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.json.JSONArray;
import org.json.JSONObject;

public class MemberTransactionHistoryDialog
extends POSDialog {
    private JXTable table;
    private TransactionListTableModel tableModel;
    private List<JSONObject> transactions = new ArrayList<JSONObject>();

    public MemberTransactionHistoryDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle("Member Transaction History");
        this.initUI();
    }

    public MemberTransactionHistoryDialog(String customerId, ClubMemberSelectionView memberselection) {
        this.setTitle("Member Transaction History");
        this.initUI();
        customerId = "'" + customerId + "'";
        this.setTickets(customerId);
        Dimension size = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
        this.setSize(size);
    }

    @Override
    protected void initUI() {
        this.getContentPane().setLayout((LayoutManager)new MigLayout("ins 0 30 0 30", "[549px,grow]", "[300px,grow][][shrink 0,fill][grow][grow]"));
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.tableModel = new TransactionListTableModel();
        this.table = new JXTable();
        this.table.setModel((TableModel)this.tableModel);
        this.table.setFocusable(false);
        this.table.setRowHeight(60);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(60, 60));
        scrollPane.setFocusable(false);
        scrollPane.setViewportView((Component)this.table);
        JPanel headerPanel = new JPanel((LayoutManager)new MigLayout("ins 10 0 10 0", "sg,fill", ""));
        POSToggleButton btnOpen = new POSToggleButton("Open");
        POSToggleButton btnAll = new POSToggleButton("All");
        btnAll.setSelected(true);
        btnAll.setPreferredSize(new Dimension(100, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(btnOpen);
        group.add(btnAll);
        headerPanel.add((Component)btnOpen, "grow");
        headerPanel.add((Component)btnAll, "grow");
        btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<JSONObject> openTransaction = new ArrayList<JSONObject>();
                for (JSONObject obj : MemberTransactionHistoryDialog.this.transactions) {
                    Object object = obj.get("Status__c");
                    if (object.toString().equals("Paid")) continue;
                    openTransaction.add(obj);
                }
                MemberTransactionHistoryDialog.this.tableModel.setRows(openTransaction);
            }
        });
        btnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList memberRecords = new ArrayList();
                memberRecords.addAll(MemberTransactionHistoryDialog.this.transactions);
                MemberTransactionHistoryDialog.this.tableModel.setRows(memberRecords);
            }
        });
        contentPanel.add((Component)headerPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)contentPanel, "cell 0 1,grow, gapright 2px");
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("al center center,insets 0", "sg,fill", ""));
        PosButton btnEdit = new PosButton("Edit");
        PosButton btnSettle = new PosButton("Settle");
        PosButton btnInfo = new PosButton("Info");
        PosButton btnClose = new PosButton("CLOSE");
        btnEdit.setPreferredSize(new Dimension(100, 0));
        footerPanel.add((Component)btnEdit, "grow");
        footerPanel.add((Component)btnSettle, "grow");
        footerPanel.add((Component)btnInfo, "grow");
        footerPanel.add((Component)btnClose, "grow");
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemberTransactionHistoryDialog.this.doEditTicket();
            }
        });
        btnSettle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSONObject selectedTransactionObj = MemberTransactionHistoryDialog.this.getSelectedTransaction();
                if (selectedTransactionObj == null) {
                    return;
                }
                Object obj = selectedTransactionObj.get("POS_Order_Id__c");
                if (obj.equals(null)) {
                    POSMessageDialog.showMessage("Ticket Number is empty");
                    return;
                }
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(obj.toString());
                MemberTransactionHistoryDialog.this.doSetteleTicket(ticket);
            }
        });
        btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Ticket> ticketList = new ArrayList<Ticket>();
                List<JSONObject> selectedTransactionObjs = MemberTransactionHistoryDialog.this.getSelectedTicketObjects();
                if (selectedTransactionObjs.isEmpty()) {
                    POSMessageDialog.showMessage("Select a ticket first");
                    return;
                }
                for (JSONObject jsonObject : selectedTransactionObjs) {
                    Ticket ticket;
                    Object obj = jsonObject.get("POS_Order_Id__c");
                    if (obj.equals(null) || (ticket = TicketDAO.getInstance().loadFullTicket(obj.toString())) == null) continue;
                    ticketList.add(ticket);
                }
                if (ticketList.isEmpty()) {
                    POSMessageDialog.showMessage("Ticket not found");
                    return;
                }
                try {
                    OrderInfoView view = new OrderInfoView(ticketList);
                    OrderInfoDialog dialog = new OrderInfoDialog(view);
                    dialog.setSize(400, 600);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setLocationRelativeTo(Application.getPosWindow());
                    dialog.setVisible(true);
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(e2.getMessage());
                }
            }
        });
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemberTransactionHistoryDialog.this.setCanceled(true);
                MemberTransactionHistoryDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)footerPanel, "cell 0 2,grow, gapright 2px");
    }

    private void doSetteleTicket(Ticket ticket) {
        if (ticket == null) {
            POSMessageDialog.showMessage("Ticket not found");
            return;
        }
    }

    private void doEditTicket() {
        try {
            Ticket ticket = null;
            JSONObject selectedTransactionObj = this.getSelectedTransaction();
            if (selectedTransactionObj == null) {
                return;
            }
            Object obj = selectedTransactionObj.get("POS_Order_Id__c");
            if (obj.equals(null)) {
                POSMessageDialog.showMessage("Ticket Number is empty");
                return;
            }
            ticket = TicketDAO.getInstance().loadFullTicket(obj.toString());
            this.editTicket(ticket);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private JSONObject getSelectedTransaction() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showMessage("Select a ticket first");
            return null;
        }
        JSONObject jObj = (JSONObject)this.tableModel.getRowData(selectedRow);
        return jObj;
    }

    private void editTicket(Ticket ticket) {
        if (ticket == null) {
            POSMessageDialog.showMessage("Ticket not found");
            return;
        }
        if (ticket.isPaid().booleanValue()) {
            POSMessageDialog.showMessage(this, "Paid ticket cannot be edited");
            return;
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
        this.closeAll();
    }

    public void closeAll() {
        this.setCanceled(true);
        this.dispose();
    }

    public List<JSONObject> getSelectedTicketObjects() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<JSONObject> ticketObjs = new ArrayList<JSONObject>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            JSONObject ticketObj = (JSONObject)this.tableModel.getRowData(this.table.convertRowIndexToModel(selectedRows[i]));
            ticketObjs.add(ticketObj);
        }
        return ticketObjs;
    }

    private void setTickets(String customerId) {
        this.transactions.clear();
        ArrayList<JSONObject> memberRecords = new ArrayList<JSONObject>();
        this.transactions = this.getAllTransaction("", customerId);
        memberRecords.addAll(this.transactions);
        this.tableModel.setRows(memberRecords);
    }

    private List<JSONObject> getAllTransaction(String name, String searchField) {
        ArrayList<JSONObject> transactionList = new ArrayList<JSONObject>();
        try {
            JSONArray members = SFUtil.getMemberTransaction(name, searchField);
            for (int i = 0; i < members.length(); ++i) {
                Object object = members.get(i);
                if (object == null) continue;
                JSONObject jsObject = (JSONObject)object;
                transactionList.add(jsObject);
            }
        }
        catch (SFConnectionException | SFException exception) {
            // empty catch block
        }
        return transactionList;
    }
}

