/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosLog;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DateUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class UpdateDBTo224 {
    public void update() throws Exception {
        ArrayList<String> duplicateVoidItemTicketItemIds = new ArrayList<String>();
        ArrayList<String> duplicateVoidItemIds = new ArrayList<String>();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(1, 2019);
            calendar.set(2, 9);
            calendar.set(5, 1);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            List<Ticket> tickets = this.getVoidedTicketItemTickets(DateUtil.startOfDay(calendar.getTime()));
            if (tickets == null || tickets.isEmpty()) {
                return;
            }
            HashSet<VoidItem> duplicateVoidItems = new HashSet<VoidItem>();
            for (Ticket ticket : tickets) {
                List<VoidItem> voidItems;
                TicketDAO.getInstance().loadFullTicket(ticket);
                ArrayList<String> voidItemIds = new ArrayList<String>();
                for (TicketItem ticketItem : ticket.getTicketItems()) {
                    String voidItemId = ticketItem.getProperty("voidId");
                    if (StringUtils.isBlank((String)voidItemId)) continue;
                    voidItemIds.add(voidItemId);
                    duplicateVoidItemTicketItemIds.add(ticketItem.getId());
                }
                if (voidItemIds.isEmpty() || (voidItems = VoidItemDAO.getInstance().getVoidItems(ticket.getId())) == null || voidItems.size() <= 0) continue;
                for (VoidItem voidItem : voidItems) {
                    if (voidItemIds.contains(voidItem.getId())) continue;
                    duplicateVoidItems.add(voidItem);
                    duplicateVoidItemIds.add(voidItem.getId());
                }
            }
            this.removeDuplicateVoidItems(duplicateVoidItems);
            this.printLog(duplicateVoidItemTicketItemIds, duplicateVoidItemIds);
        }
        catch (Exception e) {
            String errMsg = "Could not delete duplicate voided items...\nVoid item id list: " + duplicateVoidItemIds;
            PosLog.error(this.getClass(), this.encode(errMsg));
        }
    }

    private List<Ticket> getVoidedTicketItemTickets(Date fromDate) {
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.createAlias("ticketItems", "items");
            criteria.add((Criterion)Restrictions.eq((String)("items." + TicketItem.PROP_VOIDED), (Object)true));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)fromDate));
            List list = criteria.list();
            return list;
        }
    }

    private void removeDuplicateVoidItems(Set<VoidItem> duplicateVoidItems) {
        block17: {
            Transaction transaction = null;
            try (Session session = VoidItemDAO.getInstance().createNewSession();){
                transaction = session.beginTransaction();
                for (VoidItem voidItem : duplicateVoidItems) {
                    VoidItemDAO.getInstance().delete(voidItem, session);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction == null) break block17;
                try {
                    transaction.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void printLog(List<String> duplicateVoidItemTicketItemIds, List<String> duplicateVoidItemIds) throws UnsupportedEncodingException {
        String format = String.format("Removed %s duplicate void items: \nVoid item id list: %s", duplicateVoidItemIds.size(), duplicateVoidItemIds.toString());
        PosLog.error(this.getClass(), this.encode(format));
        String format2 = String.format("Found %s resolved ticket items: \nVoided ticket item id list: %s", duplicateVoidItemTicketItemIds.size(), duplicateVoidItemTicketItemIds.toString());
        PosLog.error(this.getClass(), this.encode(format2));
    }

    private String encode(String s) throws UnsupportedEncodingException {
        return new String(Base64.getEncoder().encode(s.getBytes("utf-8")));
    }
}

