/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.dao.GiftCardDAO;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class GiftCardCheckerJob
extends CronJob {
    public GiftCardCheckerJob() {
        this.setId("giftcard-validation-checker");
        this.setFrequency("HOURLY");
        PosLog.debug(GiftCardCheckerJob.class, "Gift card checker job initiating...");
    }

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Transaction tx;
        Throwable throwable;
        Session session;
        GiftCardDAO giftCardDAO = GiftCardDAO.getInstance();
        PosLog.debug(GiftCardCheckerJob.class, "Gift card checker job running...");
        try {
            session = giftCardDAO.createNewSession();
            throwable = null;
            try {
                List<GiftCard> giftCardsWithoutExpireDate = giftCardDAO.findAllWithoutExpireDate(session);
                tx = session.beginTransaction();
                for (GiftCard giftCard : giftCardsWithoutExpireDate) {
                    giftCard.setExpiryDate(giftCard.prepareExpireDate(giftCard.getIssueDate()));
                    giftCardDAO.saveOrUpdate(giftCard, session);
                }
                tx.commit();
            }
            catch (Throwable giftCardsWithoutExpireDate) {
                throwable = giftCardsWithoutExpireDate;
                throw giftCardsWithoutExpireDate;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable giftCardsWithoutExpireDate) {
                            throwable.addSuppressed(giftCardsWithoutExpireDate);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosLog.error(GiftCardCheckerJob.class, e.getMessage());
        }
        try {
            session = giftCardDAO.createNewSession();
            throwable = null;
            try {
                List<GiftCard> expiredGiftcards = giftCardDAO.findAllExpiredGiftcard(session);
                tx = session.beginTransaction();
                Date deActivationDate = new Date();
                for (GiftCard giftCard : expiredGiftcards) {
                    giftCard.setActive(Boolean.FALSE);
                    giftCard.setDeActivationDate(deActivationDate);
                    giftCardDAO.saveOrUpdate(giftCard, session);
                }
                tx.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosLog.error(GiftCardCheckerJob.class, e.getMessage());
        }
    }
}

