/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class AddTableBookingView
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected BeanEditor beanEditor;
    protected JPanel buttonPanel;
    protected PosButton btnSave = new PosButton(Messages.getString("AddTableBookingView.1"));
    private PosButton btnBookingCancel = new PosButton(Messages.getString("AddTableBookingView.0"));
    private POSDialog dialog;
    private QwertyKeyPad qwertyKeyPad;

    public AddTableBookingView(POSDialog dialog, BeanEditor beanEditor) {
        this.dialog = dialog;
        this.beanEditor = beanEditor;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(true);
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTableBookingView.this.qwertyKeyPad.setCollapsed(!AddTableBookingView.this.qwertyKeyPad.isCollapsed());
            }
        });
        this.buttonPanel.add((Component)this.btnSave, "split 2,right, gapleft 100");
        this.buttonPanel.add(this.btnBookingCancel);
        this.buttonPanel.add((Component)btnKeyboard, "span, right");
        this.beanEditor.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddTableBookingView.6")));
        this.add((Component)this.beanEditor, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)((Object)this.qwertyKeyPad), "North");
        southPanel.add((Component)this.buttonPanel, "Center");
        this.add((Component)southPanel, "South");
        this.btnSave.addActionListener(this);
        this.btnBookingCancel.addActionListener(this);
        this.beanEditor.setFieldsEnable(true);
        this.btnSave.setEnabled(true);
        this.beanEditor.setFieldsEnable(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = Command.fromString(e.getActionCommand());
        try {
            switch (command) {
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.beanEditor.save()) break;
                    this.beanEditor.setFieldsEnable(false);
                    this.btnSave.setEnabled(false);
                    this.dialog.setCanceled(false);
                    this.dialog.dispose();
                    break;
                }
            }
            if (e.getSource() == this.btnBookingCancel) {
                this.dialog.setCanceled(true);
                this.dialog.dispose();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(Application.getPosWindow(), e2.getMessage(), e2);
        }
    }

    private void doCancelEditing() {
        this.beanEditor.setFieldsEnable(false);
        this.btnSave.setEnabled(false);
        this.btnBookingCancel.setEnabled(true);
        this.beanEditor.cancel();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
    }

    public void setModels(List models) {
    }

    public BeanEditor getBeanEditor() {
        return this.beanEditor;
    }

    public void refreshButtonPanel() {
        this.beanEditor.clearFields();
        this.btnSave.setEnabled(false);
    }
}

