/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.FloorConfigurationFloorView;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopFloorTemplateDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class FloorConfigurationView
extends ConfigurationView {
    private DefaultListModel<ShopFloor> listModel = new DefaultListModel();
    private JList<ShopFloor> floorsList = new JList<ShopFloor>(this.listModel);
    private FloorConfigurationFloorView floorView = new FloorConfigurationFloorView(this.floorsList);
    private DefaultListModel<ShopFloorTemplate> listTemplateModel = new DefaultListModel();
    private JList<ShopFloorTemplate> floorTemplatesList = new JList<ShopFloorTemplate>(this.listTemplateModel);
    private JButton btnAddFloor;
    private JButton btnRemoveTemplate;
    private long newFloorCount = 1L;

    public FloorConfigurationView() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout(10, 10));
        this.renderFloorsList();
        this.add(this.floorView);
    }

    public FloorConfigurationFloorView getFloorView() {
        return this.floorView;
    }

    private void renderFloorTemplates(ShopFloor selectedValue) {
        if (selectedValue == null) {
            return;
        }
        List<ShopFloorTemplate> templates = ShopFloorTemplateDAO.getInstance().findByParent(selectedValue);
        this.listTemplateModel.clear();
        if (templates != null && !templates.isEmpty()) {
            ShopFloorTemplate defaultTemplate = null;
            for (ShopFloorTemplate template : templates) {
                if (template.isDefaultFloor().booleanValue()) {
                    defaultTemplate = template;
                }
                this.listTemplateModel.addElement(template);
            }
            this.floorTemplatesList.setSelectedValue(defaultTemplate, true);
        }
    }

    private void renderFloorsList() {
        JPanel floorListPanel = new JPanel(new BorderLayout(5, 5));
        floorListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorConfigurationView.0")));
        JScrollPane listScrollPane = new JScrollPane(this.floorsList);
        listScrollPane.setPreferredSize(new Dimension(150, 100));
        floorListPanel.add(listScrollPane);
        this.floorsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ShopFloor selectedValue = (ShopFloor)FloorConfigurationView.this.floorsList.getSelectedValue();
                if (selectedValue == null || selectedValue == FloorConfigurationView.this.floorView.getFloor()) {
                    return;
                }
                if (selectedValue.getId() != null) {
                    ShopFloorDAO.getInstance().refresh(selectedValue);
                }
                FloorConfigurationView.this.floorView.setFloor(selectedValue);
                FloorConfigurationView.this.renderFloorTemplates(selectedValue);
            }
        });
        JPanel buttonPanel = new JPanel();
        JButton btnAddFloor = new JButton(Messages.getString("FloorConfigurationView.1"));
        btnAddFloor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorConfigurationView.this.addNewFloor();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                }
            }
        });
        buttonPanel.add(btnAddFloor);
        JButton btnRemoveFloor = new JButton(Messages.getString("FloorConfigurationView.2"));
        btnRemoveFloor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorConfigurationView.this.clearTemplates();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                }
            }
        });
        buttonPanel.add(btnRemoveFloor);
        JPanel leftPanel = new JPanel(new BorderLayout(5, 5));
        floorListPanel.add((Component)buttonPanel, "South");
        leftPanel.add((Component)floorListPanel, "Center");
        this.renderFloorTemplatesList(leftPanel);
        this.add((Component)leftPanel, "West");
    }

    private void renderFloorTemplatesList(JPanel leftPanel) {
        JPanel floorTemplateListPanel = new JPanel(new BorderLayout(5, 5));
        floorTemplateListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("FloorConfigurationView.3")));
        JScrollPane listScrollPane = new JScrollPane(this.floorTemplatesList);
        listScrollPane.setPreferredSize(new Dimension(150, 100));
        floorTemplateListPanel.add(listScrollPane);
        this.floorTemplatesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ShopFloorTemplate selectedValue = (ShopFloorTemplate)FloorConfigurationView.this.floorTemplatesList.getSelectedValue();
                if (selectedValue == null) {
                    FloorConfigurationView.this.btnAddFloor.setEnabled(false);
                    FloorConfigurationView.this.btnRemoveTemplate.setEnabled(false);
                    return;
                }
                FloorConfigurationView.this.floorView.setFloorTemplate(FloorConfigurationView.this.floorTemplatesList, selectedValue);
                FloorConfigurationView.this.btnAddFloor.setEnabled(true);
                FloorConfigurationView.this.btnRemoveTemplate.setEnabled(true);
            }
        });
        JPanel buttonPanel = new JPanel();
        this.btnAddFloor = new JButton(Messages.getString("FloorConfigurationView.4"));
        this.btnAddFloor.setEnabled(false);
        this.btnAddFloor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorConfigurationView.this.saveAsFloorScreen();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                }
            }
        });
        buttonPanel.add(this.btnAddFloor);
        this.btnRemoveTemplate = new JButton(Messages.getString("FloorConfigurationView.2"));
        this.btnRemoveTemplate.setEnabled(false);
        this.btnRemoveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window window = SwingUtilities.getWindowAncestor(FloorConfigurationView.this);
                ShopFloorTemplate selectedValue = (ShopFloorTemplate)FloorConfigurationView.this.floorTemplatesList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                int option = JOptionPane.showOptionDialog(window, Messages.getString("FloorConfigurationView.6"), Messages.getString("FloorConfigurationView.7"), 0, 3, null, null, null);
                if (option != 0) {
                    return;
                }
                FloorConfigurationView.this.listTemplateModel.removeElement(selectedValue);
                ShopFloorTemplateDAO.getInstance().delete(selectedValue);
                FloorConfigurationView.this.floorTemplatesList.setSelectedIndex(FloorConfigurationView.this.listTemplateModel.getSize() - 1);
            }
        });
        buttonPanel.add(this.btnRemoveTemplate);
        floorTemplateListPanel.add((Component)buttonPanel, "South");
        leftPanel.add((Component)floorTemplateListPanel, "South");
    }

    protected void saveAsFloorScreen() {
        ShopFloorTemplate template = this.floorTemplatesList.getSelectedValue();
        this.copyAndSaveAsScreen(template);
        ShopFloor selectedValue = this.floorsList.getSelectedValue();
        this.renderFloorTemplates(selectedValue);
    }

    private void copyAndSaveAsScreen(ShopFloorTemplate template) {
        ShopFloor selectedFloor = this.floorsList.getSelectedValue();
        if (selectedFloor.getTables() == null) {
            POSMessageDialog.showError(this, Messages.getString("FloorConfigurationView.8"));
            return;
        }
        ShopFloorDAO.getInstance().refresh(selectedFloor);
        this.copyTablePositionFromTemplate(selectedFloor, template);
        ShopFloorTemplateDAO.getInstance().setDefaultTemplate(template, selectedFloor);
    }

    private void copyTablePositionFromTemplate(ShopFloor floor, ShopFloorTemplate template) {
        if (floor.getTables() == null) {
            return;
        }
        for (ShopTable table : floor.getTables()) {
            String position = template.getProperty(String.valueOf(table.getId()));
            if (position == null) continue;
            String[] split = position.split(",");
            table.setX(Integer.valueOf(split[0]));
            table.setY(Integer.valueOf(split[1]));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save() throws Exception {
        ShopFloorDAO dao = ShopFloorDAO.getInstance();
        Transaction tx = null;
        try (Session session = dao.createNewSession();){
            tx = session.beginTransaction();
            int size = this.listModel.getSize();
            for (int i = 0; i < size; ++i) {
                ShopFloor shopFloor = this.listModel.get(i);
                ShopFloorDAO.getInstance().saveOrUpdate(shopFloor, session);
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            tx.rollback();
            POSMessageDialog.showError(SwingUtilities.windowForComponent(this), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.listModel.clear();
        List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
        for (ShopFloor shopFloor : shopFloors) {
            this.listModel.addElement(shopFloor);
        }
        if (this.listModel.getSize() > 0) {
            this.floorsList.setSelectedIndex(0);
        }
        this.floorView.setFloorTemplate(this.floorTemplatesList, null);
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return Messages.getString("FloorConfigurationView.10");
    }

    private void addNewFloor() {
        ShopFloor floor = new ShopFloor();
        floor.setName("Floor " + this.newFloorCount++);
        ShopFloorDAO.getInstance().saveOrUpdate(floor);
        this.listModel.addElement(floor);
        this.floorsList.setSelectedIndex(this.listModel.getSize() - 1);
        this.floorView.setFloor(floor);
    }

    private void clearTemplates() {
        Window window = SwingUtilities.getWindowAncestor(this);
        ShopFloor floor = this.floorsList.getSelectedValue();
        if (floor == null) {
            POSMessageDialog.showError(window, Messages.getString("FloorConfigurationView.12"));
            return;
        }
        ShopFloorDAO.getInstance().refresh(floor);
        if (this.isTableBookedOrServing(floor)) {
            POSMessageDialog.showError(floor.getName() + Messages.getString("FloorConfigurationView.5"));
            this.floorView.setFloor(floor);
            return;
        }
        ArrayList<ShopFloorTemplate> templateList = new ArrayList<ShopFloorTemplate>();
        Enumeration<ShopFloorTemplate> elements = this.listTemplateModel.elements();
        while (elements.hasMoreElements()) {
            ShopFloorTemplate item = elements.nextElement();
            templateList.add(item);
        }
        int option = JOptionPane.showOptionDialog(window, Messages.getString("FloorConfigurationView.13"), Messages.getString("FloorConfigurationView.7"), 0, 3, null, null, null);
        if (option == 0) {
            this.listTemplateModel.clear();
            ShopFloorTemplateDAO.getInstance().deleteTemplates(templateList);
            this.removeSelectedFloor();
        }
    }

    private boolean isTableBookedOrServing(ShopFloor floor) {
        if (floor == null) {
            return false;
        }
        Set<ShopTable> tables = floor.getTables();
        if (tables != null) {
            for (ShopTable shopTable : tables) {
                TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
                if (!tableStatus.equals((Object)TableStatus.Booked) && !tableStatus.equals((Object)TableStatus.Serving)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeSelectedFloor() {
        ShopFloor floor = this.floorsList.getSelectedValue();
        ShopFloorDAO dao = ShopFloorDAO.getInstance();
        int selectedIndex = -1;
        if (floor != null) {
            dao.delete(floor);
            this.floorView.setSaveRequired(false);
            selectedIndex = this.floorsList.getSelectedIndex();
            this.listModel.remove(selectedIndex);
        }
        if (this.listModel.isEmpty()) {
            this.floorView.setFloor(null);
        } else {
            selectedIndex = --selectedIndex < 0 ? 0 : selectedIndex;
            this.floorView.setFloor(this.listModel.get(selectedIndex));
            this.floorsList.setSelectedIndex(selectedIndex);
        }
        this.floorView.setSaveRequired(Boolean.FALSE);
    }
}

