/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.floorplan.ui.FloorPlanView;
import com.floreantpos.floorplan.ui.FloorView;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.ui.floorplan.UiRenderer;
import com.floreantpos.ui.tableselection.BarTabSelectionView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;

public class MultiFloorTabPane
extends JPanel {
    private static final String BAR_TAB = "Bar tab";
    private HorizontalTouchScrollPanel tabButtonsPanel;
    private JPanel tabContainer;
    private FloorPlanView floorPlanView;
    private BartabButton bartabButton;
    private ButtonGroup buttonGroup;
    private UiRenderer selectedFloorView;
    private OrderType orderType;

    public MultiFloorTabPane(FloorPlanView floorPlanView) {
        this.floorPlanView = floorPlanView;
        this.setLayout(new BorderLayout());
        this.buttonGroup = new ButtonGroup();
        this.tabButtonsPanel = new HorizontalTouchScrollPanel(new FlowLayout(3));
        this.tabContainer = new JPanel(new BorderLayout());
        this.bartabButton = new BartabButton();
        this.bartabButton.setActionCommand(BAR_TAB);
        this.bartabButton.setVisible(false);
        this.tabButtonsPanel.add(this.bartabButton);
        this.buttonGroup.add(this.bartabButton);
        this.add((Component)this.tabButtonsPanel, "North");
        this.add(this.tabContainer);
    }

    public void selectFirstFloor() {
        Component[] components;
        this.tabContainer.removeAll();
        this.tabContainer.revalidate();
        this.tabContainer.repaint();
        if (this.orderType.isBarTab().booleanValue()) {
            this.bartabButton.setSelected(true);
            this.bartabButton.render();
            return;
        }
        for (Component component : components = this.tabButtonsPanel.getComponents()) {
            FloorButton floorButton;
            if (!(component instanceof FloorButton) || !(floorButton = (FloorButton)component).isVisible()) continue;
            if (floorButton.isSelected()) {
                return;
            }
            floorButton.setSelected(true);
            floorButton.renderFloor();
            break;
        }
    }

    public void setBarTabVisible(boolean visible) {
        this.bartabButton.setVisible(visible);
    }

    public void addFloor(ShopFloor floor) {
        FloorButton floorButton = new FloorButton(floor);
        this.tabButtonsPanel.add(floorButton);
        this.buttonGroup.add(floorButton);
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
        if (orderType != null) {
            Component[] components;
            this.setBarTabVisible(orderType.isBarTab());
            for (Component component : components = this.tabButtonsPanel.getComponents()) {
                if (!(component instanceof FloorButton)) continue;
                FloorButton floorButton = (FloorButton)component;
                List<OrderType> orderTypes = floorButton.floor.getOrderTypes();
                if (!orderTypes.isEmpty() && !orderTypes.contains(orderType)) {
                    floorButton.setVisible(false);
                    if (!floorButton.isSelected()) continue;
                    this.selectedFloorView = null;
                    floorButton.setSelected(false);
                    continue;
                }
                floorButton.setVisible(orderType.isShowTableSelection());
            }
        }
    }

    public UiRenderer getSelectedFloorView() {
        return this.selectedFloorView;
    }

    public boolean isBartabMode() {
        return this.bartabButton != null && this.bartabButton.isSelected();
    }

    public class BartabButton
    extends POSToggleButton
    implements ActionListener {
        public BartabButton() {
            this.setText(MultiFloorTabPane.BAR_TAB);
            this.setPrefWidth(60);
            this.setPrefHeight(35);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.render();
        }

        public void render() {
            BarTabSelectionView bartabView = new BarTabSelectionView(MultiFloorTabPane.this.floorPlanView);
            bartabView.setName(MultiFloorTabPane.BAR_TAB);
            MultiFloorTabPane.this.selectedFloorView = bartabView;
            MultiFloorTabPane.this.tabContainer.removeAll();
            MultiFloorTabPane.this.tabContainer.add(bartabView);
            MultiFloorTabPane.this.tabContainer.revalidate();
            MultiFloorTabPane.this.tabContainer.repaint();
            bartabView.updateView(MultiFloorTabPane.this.orderType);
            MultiFloorTabPane.this.floorPlanView.clearSelection();
        }
    }

    public class FloorButton
    extends POSToggleButton
    implements ActionListener {
        private ShopFloor floor;

        public FloorButton(ShopFloor floor) {
            this.floor = floor;
            this.setText(this.floor.getName());
            this.setPrefWidth(60);
            this.setPrefHeight(35);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.renderFloor();
        }

        private void renderFloor() {
            FloorView floorView = new FloorView(MultiFloorTabPane.this.floorPlanView, this.floor);
            MultiFloorTabPane.this.selectedFloorView = floorView;
            MultiFloorTabPane.this.tabContainer.removeAll();
            MultiFloorTabPane.this.tabContainer.add(floorView);
            MultiFloorTabPane.this.tabContainer.revalidate();
            MultiFloorTabPane.this.tabContainer.repaint();
            floorView.renderFloor();
        }
    }
}

