/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.booking.BookingRequestUpdateForm;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.tablebooking.model.BookingRequest;
import com.orocube.tablebooking.model.UpdateInfo;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.ws.rs.core.GenericEntity;
import net.miginfocom.swing.MigLayout;

public class OnlineTableBookingBrowser
extends TransparentPanel {
    private JTable table;
    private OnlineTableBookingModel tableModel;
    private String SERVICE_URL = "http://localhost:8080/service/data/";
    private List<BookingRequest> bookingReqList;

    public OnlineTableBookingBrowser() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new OnlineTableBookingModel();
        this.table = new JTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.add(new JScrollPane(this.table));
        try {
            this.bookingReqList = this.getBookingReq();
            if (!this.bookingReqList.isEmpty()) {
                this.tableModel.setRows(this.bookingReqList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("filly,align center", "", ""));
        JButton btnSync = new JButton(Messages.getString("OnlineTableBookingBrowser.4"));
        JButton btnUpdate = new JButton(Messages.getString("OnlineTableBookingBrowser.5"));
        btnSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OnlineTableBookingBrowser.this.tableModel.removeAll();
                    OnlineTableBookingBrowser.this.bookingReqList = OnlineTableBookingBrowser.this.getBookingReq();
                    if (!OnlineTableBookingBrowser.this.bookingReqList.isEmpty()) {
                        OnlineTableBookingBrowser.this.tableModel.setRows(OnlineTableBookingBrowser.this.bookingReqList);
                    }
                }
                catch (Exception es) {
                    es.printStackTrace();
                }
            }
        });
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineTableBookingBrowser.this.updateRow();
            }
        });
        bottomPanel.add(btnSync);
        bottomPanel.add(btnUpdate);
        this.add((Component)bottomPanel, "South");
    }

    private void getAllRequest() {
    }

    public List<BookingRequest> getBookingReq() throws Exception {
        Client client = Client.create();
        client.getProperties();
        WebResource webResource = client.resource(this.SERVICE_URL + "getBookingRequests");
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        GenericType<List<BookingRequest>> listType = new GenericType<List<BookingRequest>>(){};
        this.updateInfoUpdate();
        return (List)response.getEntity((GenericType)listType);
    }

    private void updateRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            BookingRequest bookingRequest = (BookingRequest)this.tableModel.getRowData(index);
            BookingRequestUpdateForm editor = new BookingRequestUpdateForm(bookingRequest);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
            if (this.uploadTableBooking(this.bookingReqList)) {
                POSMessageDialog.showMessage(this, Messages.getString("OnlineTableBookingBrowser.11"));
            } else {
                POSMessageDialog.showError(Messages.getString("OnlineTableBookingBrowser.12"));
            }
            if (editor.getBookingInfo() != null) {
                BookingInfo bookingInfo = editor.getBookingInfo();
                POSMessageDialog.showMessage(this, Messages.getString("OnlineTableBookingBrowser.13") + bookingInfo.getBookingId());
            }
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public boolean uploadTableBooking(List<BookingRequest> bookingRequestList) throws Exception {
        Client client = Client.create();
        client.getProperties();
        WebResource webResource = client.resource(this.SERVICE_URL + "updateBookingRequest");
        GenericEntity<List<BookingRequest>> entity = new GenericEntity<List<BookingRequest>>(bookingRequestList){};
        try {
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)entity);
            if (response.getStatus() == 200) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateInfoUpdate() {
        Client client = Client.create();
        client.getProperties();
        UpdateInfo updateInfo = this.updateInfo();
        updateInfo.setUpdateAvailable(Boolean.valueOf(false));
        updateInfo.setCount(Integer.valueOf(0));
        WebResource webResource = client.resource(this.SERVICE_URL + "updateBookingRequestsUpdateInfo");
        GenericEntity<UpdateInfo> entity = new GenericEntity<UpdateInfo>(updateInfo){};
        try {
            ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)entity);
            if (response.getStatus() != 200) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private UpdateInfo updateInfo() {
        Client client = Client.create();
        client.getProperties();
        WebResource webResource = client.resource(this.SERVICE_URL + "getBookingRequestsUpdateInfo");
        ClientResponse response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        GenericType<UpdateInfo> updateInfo = new GenericType<UpdateInfo>(){};
        UpdateInfo ui = (UpdateInfo)response.getEntity((GenericType)updateInfo);
        return ui;
    }

    private class OnlineTableBookingModel
    extends ListTableModel {
        public OnlineTableBookingModel() {
            super(new String[]{Messages.getString("OnlineTableBookingBrowser.0"), Messages.getString("OnlineTableBookingBrowser.1"), Messages.getString("OnlineTableBookingBrowser.2"), Messages.getString("OnlineTableBookingBrowser.3"), Messages.getString("OnlineTableBookingBrowser.6"), Messages.getString("OnlineTableBookingBrowser.7")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List bookingRequestList = this.getRows();
            BookingRequest bookingRequest = (BookingRequest)bookingRequestList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    return bookingRequest.getNumberOfGuest();
                }
                case 2: {
                    Date date = bookingRequest.getDate();
                    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy");
                    return formatter.format(date);
                }
                case 3: {
                    return bookingRequest.getDate();
                }
                case 4: {
                    return bookingRequest.isIsProcessed();
                }
                case 5: {
                    return bookingRequest.getStatus();
                }
            }
            return null;
        }

        public void addModifier(BookingRequest category) {
            int size = this.getRows().size();
            this.getRows().add(category);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteModifier(BookingRequest category, int index) {
            this.getRows().remove(category);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeAll() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        public void addRows(List<BookingRequest> rows) {
            if (rows == null) {
                return;
            }
            for (BookingRequest row : rows) {
                this.addModifier(row);
            }
            this.fireTableDataChanged();
        }
    }
}

