/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.FloorPlanView;
import com.floreantpos.floorplan.ui.TableBookingForm;
import com.floreantpos.floorplan.ui.booking.BookingTableSelectionDialog;
import com.floreantpos.floorplan.ui.booking.DelaySelectionDialog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.BookingStatus;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.StaleStateException;

public class StatusManagementDialog
extends POSDialog
implements RefreshableView {
    private BookingInfo tableBookingInfo;
    private FloorPlanView mapTableSelectionView;

    public StatusManagementDialog(BookingInfo tableBookingInfo, FloorPlanView mapTableSelectionView) {
        this.tableBookingInfo = tableBookingInfo;
        this.mapTableSelectionView = mapTableSelectionView;
        this.setTitle(Messages.getString("StatusManagementDialog.0") + tableBookingInfo.getBookingId());
        this.setDefaultCloseOperation(2);
        this.setSize(PosUIManager.getSize(500, 170));
        this.setLocationRelativeTo(POSUtil.getFocusedWindow());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        int width = 220;
        int height = 120;
        PosButton btnBookingSeat = new PosButton(Messages.getString("StatusManagementDialog.2"));
        PosButton btnBookingComplete = new PosButton(BookingStatus.Complete.toString());
        PosButton btnNoAppear = new PosButton(Messages.getString("StatusManagementDialog.3"));
        PosButton btnDelay = new PosButton(Messages.getString("StatusManagementDialog.4"));
        PosButton btnCancel = new PosButton(Messages.getString("StatusManagementDialog.5"));
        PosButton btnClose = new PosButton(Messages.getString("StatusManagementDialog.6"));
        PosButton btnDetails = new PosButton(Messages.getString("StatusManagementDialog.7"));
        btnBookingSeat.setPreferredSize(PosUIManager.getSize(width, height));
        btnBookingComplete.setPreferredSize(PosUIManager.getSize(width, height));
        btnNoAppear.setPreferredSize(PosUIManager.getSize(width, height));
        btnDelay.setPreferredSize(PosUIManager.getSize(width, height));
        btnCancel.setPreferredSize(PosUIManager.getSize(width, height));
        btnClose.setPreferredSize(PosUIManager.getSize(width, height));
        btnDetails.setPreferredSize(PosUIManager.getSize(width, height));
        centerPanel.add(btnBookingSeat);
        centerPanel.add(btnNoAppear);
        centerPanel.add(btnDelay);
        centerPanel.add(btnCancel);
        centerPanel.add(btnClose);
        centerPanel.add((Component)btnDetails, "wrap");
        btnBookingSeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StatusManagementDialog.this.doAllocateTable();
                    StatusManagementDialog.this.publishOnMqtt();
                }
                catch (TicketAlreadyExistsException e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
                }
            }
        });
        btnNoAppear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusManagementDialog.this.doSetNoAppear();
                StatusManagementDialog.this.publishOnMqtt();
            }
        });
        btnDelay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusManagementDialog.this.doSetDelay();
                StatusManagementDialog.this.publishOnMqtt();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusManagementDialog.this.doSetCancel();
                StatusManagementDialog.this.publishOnMqtt();
            }
        });
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusManagementDialog.this.doSetStatusClose();
                StatusManagementDialog.this.publishOnMqtt();
            }
        });
        btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusManagementDialog.this.doShowDetails();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center, ins 0 5", "sg, fill", ""));
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("StatusManagementDialog.9"))));
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    private void doShowDetails() {
        try {
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.10"));
                return;
            }
            TableBookingForm bookingForm = new TableBookingForm(this.tableBookingInfo, true);
            BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)bookingForm);
            dialog.setOkButtonVisible(false);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.mapTableSelectionView.createCustomerBookingInfoPanel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    protected void doSetCancel() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.11"), Messages.getString("StatusManagementDialog.12"));
            if (option != 0) {
                return;
            }
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            this.tableBookingInfo.setStatus("cancel");
            this.tableBookingInfo.setClosed(true);
            this.setStatusAndBookingInfo();
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    protected void doSetStatusClose() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.14"), Messages.getString("StatusManagementDialog.15"));
            if (option != 0) {
                return;
            }
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            this.tableBookingInfo.setStatus("close");
            this.tableBookingInfo.setClosed(true);
            this.setStatusAndBookingInfo();
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    protected void doSetDelay() {
        try {
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            DelaySelectionDialog dialog = new DelaySelectionDialog(this.tableBookingInfo);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.setStatusAndBookingInfo();
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void setStatusAndBookingInfo() throws Exception {
        List<ShopTable> shopTables = ShopTableDAO.getInstance().findByBookingInfo(this.tableBookingInfo.getId());
        for (ShopTable shopTable : shopTables) {
            ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
            if (shopTableStatus == null) continue;
            shopTableStatus.setTableStatus(TableStatus.Available);
            shopTableStatus.removeProperty("seat.time");
            this.resetShopTable(shopTable);
            ShopTableStatusDAO.getInstance().update(shopTableStatus);
        }
        BookingInfoDAO.getInstance().saveOrUpdate(this.tableBookingInfo);
        this.refresh();
    }

    protected void doSetNoAppear() {
        try {
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.19"), Messages.getString("StatusManagementDialog.20"));
            if (option != 0) {
                return;
            }
            this.tableBookingInfo.setStatus("no appear");
            this.tableBookingInfo.setClosed(true);
            this.setStatusAndBookingInfo();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    protected void doSetSeat() {
        try {
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.22"), Messages.getString("StatusManagementDialog.23"));
            if (option != 0) {
                return;
            }
            this.tableBookingInfo.setStatus("seat");
            this.setStatusAndBookingInfo();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doAllocateTable() throws TicketAlreadyExistsException {
        try {
            if (this.tableBookingInfo == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.13"));
                return;
            }
            List<ShopTable> selectedTables = this.tableBookingInfo.getTables();
            int numberOfGuest = this.tableBookingInfo.getGuestCount();
            if (numberOfGuest == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StatusManagementDialog.25"));
                return;
            }
            Date fromDate = this.tableBookingInfo.getFromDate();
            Date toDate = this.tableBookingInfo.getToDate();
            if (fromDate == null || toDate == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.30"));
                return;
            }
            Date today = new Date();
            if (fromDate.getTime() < today.getTime()) {
                Calendar calendar = Calendar.getInstance();
                int hourOfTheDay = calendar.get(10);
                calendar.set(10, hourOfTheDay);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                fromDate = calendar.getTime();
                int setHour = hourOfTheDay + 1;
                calendar.set(10, setHour);
                toDate = calendar.getTime();
                this.tableBookingInfo.setFromDate(fromDate);
                this.tableBookingInfo.setToDate(toDate);
            }
            this.dispose();
            BookingTableSelectionDialog tableSelectionDialog = BookingTableSelectionDialog.getInstance();
            tableSelectionDialog.setBookingInfo(this.tableBookingInfo);
            tableSelectionDialog.clearAllFloorSelection(false);
            tableSelectionDialog.updateView();
            tableSelectionDialog.openFullScreen();
            if (tableSelectionDialog.isCanceled()) {
                return;
            }
            List<ShopTable> shopTables = tableSelectionDialog.getPreviousTables();
            List subtractTables = (List)CollectionUtils.subtract(selectedTables, shopTables);
            shopTables.addAll(subtractTables);
            this.tableBookingInfo.setTables(shopTables);
            for (ShopTable shopTable : selectedTables) {
                if (shopTable.getTableStatus().equals((Object)TableStatus.Seat) || shopTable.getTableStatus().equals((Object)TableStatus.Serving)) continue;
                ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
                shopTableStatus.setTableStatus(TableStatus.Seat);
                shopTableStatus.addProperty("seat.time", ShopTable.bookingDateFormat.format(new Date()));
                shopTable.setCurrentBookingId(this.tableBookingInfo.getId());
                shopTable.setCustomerName(this.tableBookingInfo.getCustomerName());
                shopTable.addProperty("RES_NO", this.tableBookingInfo.getBookingId());
                ShopTableStatusDAO.getInstance().update(shopTableStatus);
                ShopTableDAO.getInstance().update(shopTable);
            }
            int dialog = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("StatusManagementDialog.26"), Messages.getString("StatusManagementDialog.27"));
            if (dialog == 1) {
                this.tableBookingInfo.setStatus("seat");
                List<ShopTable> tables = this.tableBookingInfo.getTables();
                if (tables != null && !tables.isEmpty()) {
                    for (ShopTable shopTable : tables) {
                        if (!shopTable.getShopTableStatus().getTableStatus().equals((Object)TableStatus.Booked)) continue;
                        shopTable.getShopTableStatus().setTableStatus(TableStatus.Available);
                    }
                }
            }
            BookingInfoDAO.getInstance().update(this.tableBookingInfo);
            this.refresh();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void resetShopTable(ShopTable shopTable) {
        try {
            shopTable.setCurrentBookingId(null);
            shopTable.setCustomerName(null);
            shopTable.removeProperty("RES_NO");
            ShopTableDAO.getInstance().update(shopTable);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void refresh() {
        if (this.mapTableSelectionView == null) {
            return;
        }
        this.mapTableSelectionView.refresh();
        this.dispose();
    }

    private void publishOnMqtt() {
        OroMqttClient oroMqttClient = OroMqttClient.getInstance();
        oroMqttClient.publishOnThread("MQTT-COMMAND", "1");
        oroMqttClient.publishOnThread("MQTT-COMMAND", "2");
    }
}

