/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.dao.FloorplanDAO;
import com.floreantpos.floorplan.ui.TableBookingForm;
import com.floreantpos.floorplan.ui.booking.DelaySelectionDialog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jdesktop.swingx.JXDatePicker;

public class TableBookingBrowser
extends TransparentPanel
implements ActionListener {
    private PosButton btnNew;
    private PosButton btnEdit;
    private PosButton btnDelete;
    private PosButton btnSeat;
    private PosButton btnNoAppear;
    private PosButton btnDelay;
    private PosButton btnBookingClose;
    private PosButton btnBookingCancel;
    private PosButton btnCloseWindow;
    private JButton btnBack;
    private JButton btnForward;
    private BeanTableModel<BookingInfo> tableModel;
    private JToggleButton btnTodaysView;
    private JXDatePicker tbStartDate;
    private JXDatePicker tbEndDate;
    private PosTable bookingInfoTable;
    private POSComboBox cbStatus;
    private POSTextField tfSearchText;
    private QwertyKeyPad qwertyKeyPad;
    private PosButton btnKeyboard;
    private PosButton btnDeleteAll;

    public TableBookingBrowser() {
        this.initComponents();
        this.doSearchTodaysView();
    }

    private void initComponents() {
        this.tableModel = new BeanTableModel(BookingInfo.class, 20);
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.3"), BookingInfo.PROP_BOOKING_ID);
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.4"), BookingInfo.PROP_FROM_DATE);
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.5"), BookingInfo.PROP_TO_DATE);
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.6"), "customerName");
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.8"), "customerPhone");
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.10"), "bookedTableNumbers");
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.12"), BookingInfo.PROP_GUEST_COUNT);
        this.tableModel.addColumn(Messages.getString("TableBookingBrowser.13"), BookingInfo.PROP_STATUS);
        this.bookingInfoTable = new PosTable(this.tableModel);
        this.bookingInfoTable.setRowHeight(50);
        this.bookingInfoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                TableBookingBrowser.this.updateButtonStatus();
            }
        });
        this.doFormatDateCellRenderer(1);
        this.doFormatDateCellRenderer(2);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createBookingInfoSearchPanel(), "North");
        this.add(new PosScrollPane((Component)((Object)this.bookingInfoTable)));
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(true);
        JPanel southPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        southPanel.add((Component)((Object)this.qwertyKeyPad), "wrap, grow");
        southPanel.add((Component)this.createBottomPanel(), "grow");
        this.add((Component)southPanel, "South");
    }

    private void doFormatDateCellRenderer(int column) {
        this.bookingInfoTable.getColumn(column).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Date) {
                    String valueStr = DateUtil.formatFullDateAndTimeAsString((Date)value);
                    return super.getTableCellRendererComponent(table, valueStr, isSelected, hasFocus, row, column);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
    }

    private void updateButtonStatus() {
        int index = this.bookingInfoTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        BookingInfo tableBookingBean = this.tableModel.getRow(index = this.bookingInfoTable.convertRowIndexToModel(index));
        if (tableBookingBean == null) {
            return;
        }
        if (tableBookingBean.getStatus().equals("cancel")) {
            this.btnNew.setEnabled(true);
            this.btnDelete.setEnabled(true);
            this.btnSeat.setEnabled(false);
            this.btnDelay.setEnabled(false);
            this.btnNoAppear.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnBookingCancel.setEnabled(false);
            this.btnBookingClose.setEnabled(false);
            return;
        }
        if (tableBookingBean.getStatus().equals("seat")) {
            this.btnDelay.setEnabled(false);
            this.btnNoAppear.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnSeat.setEnabled(false);
            this.btnNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnBookingCancel.setEnabled(true);
            this.btnBookingClose.setEnabled(true);
            return;
        }
        if (tableBookingBean.getStatus().equals("close")) {
            this.btnDelay.setEnabled(false);
            this.btnNoAppear.setEnabled(false);
            this.btnDelete.setEnabled(true);
            this.btnSeat.setEnabled(false);
            this.btnNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnBookingCancel.setEnabled(false);
            this.btnBookingClose.setEnabled(false);
            return;
        }
        this.btnDelay.setEnabled(true);
        this.btnNoAppear.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnSeat.setEnabled(true);
        this.btnNew.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnBookingCancel.setEnabled(true);
        this.btnBookingClose.setEnabled(true);
    }

    private JPanel createBottomPanel() {
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][right]", ""));
        this.btnNew = new PosButton(Messages.getString("TableBookingBrowser.20"));
        this.btnEdit = new PosButton(Messages.getString("TableBookingBrowser.21"));
        this.btnDelete = new PosButton(Messages.getString("TableBookingBrowser.22"));
        this.btnDeleteAll = new PosButton(Messages.getString("TableBookingBrowser.23"));
        this.btnSeat = new PosButton(Messages.getString("TableBookingBrowser.24"));
        this.btnNoAppear = new PosButton(Messages.getString("TableBookingBrowser.25"));
        this.btnDelay = new PosButton(Messages.getString("TableBookingBrowser.26"));
        this.btnBookingCancel = new PosButton(Messages.getString("TableBookingBrowser.27"));
        this.btnBookingClose = new PosButton(Messages.getString("TableBookingBrowser.28"));
        this.btnCloseWindow = new PosButton(Messages.getString("TableBookingBrowser.29"));
        this.btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        this.btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingBrowser.this.qwertyKeyPad.setCollapsed(!TableBookingBrowser.this.qwertyKeyPad.isCollapsed());
            }
        });
        this.btnCloseWindow.setVisible(false);
        this.btnKeyboard.setVisible(false);
        this.btnNew.addActionListener(this);
        this.btnEdit.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.btnDeleteAll.addActionListener(this);
        this.btnSeat.addActionListener(this);
        this.btnNoAppear.addActionListener(this);
        this.btnDelay.addActionListener(this);
        this.btnBookingCancel.addActionListener(this);
        this.btnBookingClose.addActionListener(this);
        int iconSize = PosUIManager.getSize(16);
        this.btnBack = new JButton();
        this.btnBack.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)iconSize));
        this.btnForward = new JButton();
        this.btnForward.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)iconSize));
        bottomPanel.add((Component)this.btnNew, "right, split 9");
        bottomPanel.add(this.btnEdit);
        bottomPanel.add(this.btnDelete);
        bottomPanel.add(this.btnDeleteAll);
        bottomPanel.add(this.btnSeat);
        bottomPanel.add(this.btnNoAppear);
        bottomPanel.add(this.btnDelay);
        bottomPanel.add(this.btnBookingCancel);
        bottomPanel.add(this.btnBookingClose);
        bottomPanel.add((Component)this.btnCloseWindow, "right, growy, split 2");
        bottomPanel.add(this.btnKeyboard);
        this.btnCloseWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(TableBookingBrowser.this).dispose();
            }
        });
        return bottomPanel;
    }

    protected void doSeatBookingInfo() {
        try {
            int index = this.bookingInfoTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("TableBookingBrowser.34"));
                return;
            }
            BookingInfo tableBookingBean = this.tableModel.getRow(index = this.bookingInfoTable.convertRowIndexToModel(index));
            if (tableBookingBean == null) {
                return;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    protected void doEdit() {
        try {
            int index = this.bookingInfoTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("TableBookingBrowser.35"));
                return;
            }
            BookingInfo tableBookingBean = this.tableModel.getRow(index = this.bookingInfoTable.convertRowIndexToModel(index));
            if (tableBookingBean == null) {
                return;
            }
            TableBookingForm bookingForm = new TableBookingForm(tableBookingBean);
            BeanEditorDialog dialog = new BeanEditorDialog(bookingForm);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doCreateNewBookingInfo() {
        TableBookingForm bookingForm = new TableBookingForm(new BookingInfo());
        BeanEditorDialog dialog = new BeanEditorDialog(bookingForm);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        BookingInfo bookingInfo = (BookingInfo)bookingForm.getBean();
        this.tableModel.addRow(bookingInfo);
    }

    private void doDelete() {
        try {
            int index = this.bookingInfoTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("TableBookingBrowser.35"));
                return;
            }
            BookingInfo tableBookingBean = this.tableModel.getRow(index = this.bookingInfoTable.convertRowIndexToModel(index));
            if (tableBookingBean == null) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.18"), Messages.getString("TableBookingForm.19"));
            if (option != 0) {
                return;
            }
            List<ShopTable> shopTables = ShopTableDAO.getInstance().findByBookingInfo(tableBookingBean.getId());
            if (shopTables != null && !shopTables.isEmpty()) {
                for (ShopTable shopTable : shopTables) {
                    shopTable.setCurrentBookingId(null);
                    shopTable.removeProperty("RES_NO");
                    shopTable.setCustomerName(null);
                    ShopTableDAO.getInstance().update(shopTable);
                }
            }
            BookingInfoDAO.getInstance().delete(tableBookingBean);
            this.doSearch();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private JPanel createBookingInfoSearchPanel() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout((LayoutManager)new MigLayout("", "[][]20[]10[]10[]", "[][]"));
        this.tbStartDate = UiUtil.getCurrentMonthStart();
        this.tbEndDate = UiUtil.getCurrentMonthEnd();
        JLabel lblFromDate = new JLabel(Messages.getString("TableBookingBrowser.37"));
        JLabel lblToDate = new JLabel(Messages.getString("TableBookingBrowser.38"));
        JLabel lblStatus = new JLabel(Messages.getString("TableBookingBrowser.39"));
        this.btnTodaysView = new JToggleButton(Messages.getString("TableBookingBrowser.40"));
        this.btnTodaysView.setSelected(true);
        JButton btnSearch = new JButton(Messages.getString("TableBookingBrowser.41"));
        btnSearch.setPreferredSize(PosUIManager.getSize(60, 40));
        this.btnTodaysView.setPreferredSize(PosUIManager.getSize(60, 40));
        Object[] status = new String[]{Messages.getString("TableBookingBrowser.42"), Messages.getString("TableBookingBrowser.43"), Messages.getString("TableBookingBrowser.44"), Messages.getString("TableBookingBrowser.45"), Messages.getString("TableBookingBrowser.46"), Messages.getString("TableBookingBrowser.47")};
        this.cbStatus = new POSComboBox(status);
        this.cbStatus.setPreferredSize(PosUIManager.getSize(150, 40));
        JLabel lblSearchText = new JLabel(Messages.getString("TableBookingBrowser.48"));
        this.tfSearchText = new POSTextField(20);
        this.tfSearchText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingBrowser.this.doSearch();
            }
        });
        this.tfSearchText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                TableBookingBrowser.this.qwertyKeyPad.setCollapsed(true);
            }

            @Override
            public void focusGained(FocusEvent e) {
                TableBookingBrowser.this.qwertyKeyPad.setCollapsed(false);
            }
        });
        searchPanel.add((Component)lblFromDate, "cell 0 0");
        searchPanel.add((Component)this.tbStartDate, "cell 1 0");
        searchPanel.add((Component)lblToDate, "cell 0 1");
        searchPanel.add((Component)this.tbEndDate, "cell 1 1");
        searchPanel.add((Component)lblSearchText, "cell 2 0 0 2,aligny center");
        searchPanel.add((Component)this.tfSearchText, "cell 3 0 0 2,aligny center");
        searchPanel.add((Component)lblStatus, "cell 4 0 0 2,aligny center");
        searchPanel.add((Component)this.cbStatus, "cell 5 0 0 2,aligny center");
        searchPanel.add((Component)btnSearch, "cell 6 0 0 2");
        searchPanel.add((Component)new JSeparator(1), "cell 7 0 0 2,grow");
        searchPanel.add((Component)this.btnTodaysView, "cell 8 0 0 2,align center");
        searchPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("TableBookingBrowser.54")));
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingBrowser.this.doSearch();
            }
        });
        this.btnTodaysView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBookingBrowser.this.doShowTodaysView(e);
            }
        });
        return searchPanel;
    }

    private void doShowTodaysView(ActionEvent event) {
        try {
            JToggleButton toggleButton = (JToggleButton)event.getSource();
            if (toggleButton.isSelected()) {
                this.doSearchTodaysView();
                return;
            }
            this.doSearch();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doSearchTodaysView() {
        String selectedItem = (String)this.cbStatus.getSelectedItem();
        if ((selectedItem = selectedItem.toLowerCase()).equals("all")) {
            selectedItem = null;
        }
        String searchText = this.tfSearchText.getText();
        List<BookingInfo> todaysBookingList = FloorplanDAO.getInstance().getTodaysBooking(selectedItem, searchText);
        this.tableModel.setRows(todaysBookingList);
    }

    private void doSearch() {
        try {
            this.btnTodaysView.setSelected(false);
            if (this.tbStartDate.getDate() == null || this.tbEndDate.getDate() == null) {
                JOptionPane.showMessageDialog(null, Messages.getString("TableBookingBrowser.56"));
                return;
            }
            if (this.tbStartDate.getDate().getTime() > this.tbEndDate.getDate().getTime()) {
                JOptionPane.showMessageDialog(null, Messages.getString("TableBookingBrowser.57"));
                return;
            }
            this.tableModel.getRows().clear();
            Date startDate = DateUtil.startOfDay(this.tbStartDate.getDate());
            Date endDate = DateUtil.endOfDay(this.tbEndDate.getDate());
            String selectedItem = (String)this.cbStatus.getSelectedItem();
            selectedItem = selectedItem.toLowerCase();
            if (selectedItem.equals("all")) {
                selectedItem = null;
            }
            String searchTxt = this.tfSearchText.getText();
            List<BookingInfo> bookingList = FloorplanDAO.getInstance().getAllBookingInfoByDate(startDate, endDate, selectedItem, searchTxt);
            this.tableModel.setRows(bookingList);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void setBookingStatus(String status) {
        int index = this.bookingInfoTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(this, Messages.getString("TableBookingBrowser.59"));
            return;
        }
        BookingInfo bookingInfo = this.tableModel.getRow(index = this.bookingInfoTable.convertRowIndexToModel(index));
        if (bookingInfo == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.36"));
            return;
        }
        try {
            String bookingStatus = null;
            int dialogResult = -1;
            if (status.equals("seat")) {
                dialogResult = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.37") + bookingInfo.getBookingId() + Messages.getString("TableBookingForm.38"), Messages.getString("TableBookingForm.39"));
                bookingStatus = "seat";
                bookingInfo.setClosed(false);
            } else if (status.equals("cancel")) {
                dialogResult = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.42") + bookingInfo.getBookingId() + Messages.getString("TableBookingForm.50"), Messages.getString("TableBookingForm.52"));
                bookingStatus = "cancel";
                bookingInfo.setClosed(true);
            } else if (status.equals("delay")) {
                DelaySelectionDialog dialog = new DelaySelectionDialog(bookingInfo);
                dialog.open();
                BookingInfoDAO.getInstance().saveOrUpdate(bookingInfo);
            } else if (status.equals("no appear")) {
                dialogResult = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.45") + bookingInfo.getBookingId() + Messages.getString("TableBookingBrowser.60"), Messages.getString("TableBookingBrowser.61"));
                bookingStatus = "no appear";
                bookingInfo.setClosed(true);
            } else if (status.equals("close")) {
                dialogResult = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.45") + bookingInfo.getBookingId() + Messages.getString("TableBookingBrowser.62"), Messages.getString("TableBookingBrowser.63"));
                bookingStatus = "close";
                bookingInfo.setClosed(true);
            }
            if (dialogResult != 0) {
                return;
            }
            List<ShopTable> selectedTableList = bookingInfo.getTables();
            if (selectedTableList == null || selectedTableList.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingBrowser.64"));
                return;
            }
            ArrayList<ShopTableStatus> statusList = new ArrayList<ShopTableStatus>();
            boolean updateTables = bookingInfo.isClosed();
            for (ShopTable shopTable : selectedTableList) {
                ShopTableStatus tableStatus = shopTable.getStatus();
                if (tableStatus == null) continue;
                statusList.add(tableStatus);
                if (!updateTables) continue;
                shopTable.setCurrentBookingId(null);
                shopTable.removeProperty("RES_NO");
                shopTable.setCustomerName(null);
            }
            try (Session session = TerminalDAO.getInstance().createNewSession();){
                Transaction transaction;
                block38: {
                    FloorplanDAO.getInstance().setBookingStatus(bookingInfo, bookingStatus, statusList, session);
                    if (bookingStatus.equals("seat")) {
                        transaction = null;
                        try {
                            transaction = session.beginTransaction();
                            for (ShopTable shopTable : selectedTableList) {
                                String customerId = bookingInfo.getCustomerId();
                                if (StringUtils.isNotBlank((String)customerId)) {
                                    shopTable.addProperty("shop.table_customer.id", customerId);
                                }
                                shopTable.setCurrentBookingId(bookingInfo.getBookingId());
                                shopTable.setCustomerName(bookingInfo.getCustomerName());
                                ShopTableDAO.getInstance().saveOrUpdate(shopTable, session);
                            }
                            transaction.commit();
                        }
                        catch (Exception e) {
                            if (transaction == null) break block38;
                            transaction.rollback();
                        }
                    }
                }
                if (updateTables) {
                    transaction = null;
                    try {
                        transaction = session.beginTransaction();
                        for (ShopTable shopTable : selectedTableList) {
                            ShopTableDAO.getInstance().saveOrUpdate(shopTable, session);
                        }
                        transaction.commit();
                    }
                    catch (Exception e) {
                        if (transaction != null) {
                            transaction.rollback();
                        }
                    }
                }
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.64"));
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TableBookingForm.65"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnNew) {
            this.doCreateNewBookingInfo();
        } else if (e.getSource() == this.btnEdit) {
            this.doEdit();
        } else if (e.getSource() == this.btnDelete) {
            this.doDelete();
        } else if (e.getSource() == this.btnDeleteAll) {
            this.doDeleteAll();
        } else if (e.getSource() == this.btnSeat) {
            this.setBookingStatus("seat");
        } else if (e.getSource() == this.btnDelay) {
            this.setBookingStatus("delay");
        } else if (e.getSource() == this.btnNoAppear) {
            this.setBookingStatus("no appear");
        } else if (e.getSource() == this.btnBookingCancel) {
            this.setBookingStatus("cancel");
        } else if (e.getSource() == this.btnBookingClose) {
            this.setBookingStatus("close");
        }
        this.bookingInfoTable.clearSelection();
    }

    private void doDeleteAll() {
        int rowCount = this.bookingInfoTable.getRowCount();
        if (rowCount == 0) {
            POSMessageDialog.showMessage(Messages.getString("TableBookingBrowser.0"));
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TableBookingBrowser.65"), Messages.getString("TableBookingForm.19"));
        if (option != 0) {
            return;
        }
        boolean isDeleted = FloorplanDAO.getInstance().deleteAllReservations();
        if (isDeleted) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingBrowser.66"));
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableBookingBrowser.67"));
        }
        this.doSearch();
    }

    public void showButtonsForDialog() {
        this.btnCloseWindow.setVisible(true);
        this.btnKeyboard.setVisible(true);
    }
}

