/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.ShopTable;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.CheckBoxListModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableCheckBoxList<E>
extends CheckBoxList {
    public void setModel(List items) {
        this.setModel(new TableCheckBoxListModel(items));
        this.init();
    }

    public List getCheckedValues() {
        ArrayList values = new ArrayList();
        TableCheckBoxListModel model = (TableCheckBoxListModel)this.getModel();
        for (int i = 0; i < model.items.size(); ++i) {
            CheckBoxList.Entry entry = model.items.get(i);
            if (!entry.checked) continue;
            values.add(entry.value);
        }
        return values;
    }

    @Override
    public void unCheckAll() {
        TableCheckBoxListModel model = (TableCheckBoxListModel)this.getModel();
        for (int i = 0; i < model.items.size(); ++i) {
            CheckBoxList.Entry entry = model.items.get(i);
            entry.checked = false;
        }
        model.fireTableRowsUpdated(0, model.getRowCount());
    }

    @Override
    public void selectItems(List types) {
        TableCheckBoxListModel model = (TableCheckBoxListModel)this.getModel();
        if (types != null) {
            block0: for (int i = 0; i < model.items.size(); ++i) {
                CheckBoxList.Entry entry = model.items.get(i);
                for (int j = 0; j < types.size(); ++j) {
                    Object type = types.get(j);
                    if (!type.equals(entry.value)) continue;
                    entry.checked = true;
                    continue block0;
                }
            }
            model.fireTableRowsUpdated(0, model.getRowCount());
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == 0) {
            return super.getCellRenderer(row, column);
        }
        DefaultTableCellRenderer center = new DefaultTableCellRenderer();
        center.setHorizontalAlignment(0);
        this.getColumnModel().getColumn(column).setCellRenderer(center);
        return super.getCellRenderer(row, column);
    }

    @Override
    public void init() {
        this.getSelectionModel().setSelectionMode(0);
        this.setShowGrid(true);
        this.setAutoResizeMode(3);
        TableColumn column = this.getColumnModel().getColumn(0);
        int checkBoxWidth = new JCheckBox().getPreferredSize().width;
        column.setPreferredWidth(checkBoxWidth);
        column.setMinWidth(checkBoxWidth);
        column.setWidth(checkBoxWidth);
        column.setMaxWidth(checkBoxWidth);
        column.setResizable(false);
        this.setTableHeader(null);
    }

    public static class TableCheckBoxListModel<E>
    extends CheckBoxListModel<E> {
        List<CheckBoxList.Entry<E>> items;

        TableCheckBoxListModel(List<E> _items) {
            super(_items);
            this.items = new ArrayList<CheckBoxList.Entry<E>>(_items.size());
            for (int i = 0; i < _items.size(); ++i) {
                this.items.add(this.createEntry(_items.get(i)));
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 1: {
                    return Messages.getString("TableCheckBoxList.0");
                }
                case 2: {
                    return Messages.getString("TableCheckBoxList.1");
                }
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CheckBoxList.Entry<E> entry = this.items.get(row);
            switch (col) {
                case 0: {
                    return entry.checked;
                }
                case 1: {
                    return entry.value;
                }
                case 2: {
                    return ((ShopTable)entry.value).getCapacity();
                }
            }
            throw new InternalError();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                CheckBoxList.Entry<E> entry = this.items.get(row);
                entry.checked = value.equals(Boolean.TRUE);
                this.fireTableRowsUpdated(row, row);
            }
        }
    }
}

