/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui.configuration;

import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.ui.configuration.CustomColorChooserDialog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class GeneralConfigurationView
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton rbShowTableNumber;
    private JRadioButton rbShowTableName;
    private JCheckBox chkShowServerName;
    private JCheckBox chkShowTokenNum;
    private IntegerTextField tfPrimaryFontSize;
    private IntegerTextField tfSecondaryFontSize;
    private Color seatForeColor;
    private Color seatBgColor;
    private Map<String, JButton> buttonMap = new HashMap<String, JButton>();
    private String[] colArrays;
    private Color freeForeColor;
    private Color freeBgColor;
    private Color bookForeColor;
    private Color bookBgColor;
    private Color servingForeColor;
    private Color servingBgColor;
    private JCheckBox chkShowCustomerName;
    private JCheckBox chkShowResID;
    private JCheckBox chkShowTableStatus;

    public GeneralConfigurationView() {
        this.initComponents();
        this.updateView();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(null, Messages.getString("GeneralConfigurationView.0"), 2, 2, null, null));
        JPanel tableConfigurationPanel = new JPanel((LayoutManager)new MigLayout("", "[][][]", ""));
        this.rbShowTableNumber = new JRadioButton(Messages.getString("GeneralConfigurationView.4"));
        this.rbShowTableName = new JRadioButton(Messages.getString("GeneralConfigurationView.5"));
        this.chkShowServerName = new JCheckBox(Messages.getString("GeneralConfigurationView.6"));
        this.chkShowTokenNum = new JCheckBox(Messages.getString("GeneralConfigurationView.7"));
        this.chkShowCustomerName = new JCheckBox(Messages.getString("GeneralConfigurationView.1"));
        this.chkShowResID = new JCheckBox(Messages.getString("GeneralConfigurationView.9"));
        this.chkShowTableStatus = new JCheckBox(Messages.getString("GeneralConfigurationView.10"));
        ButtonGroup btntableOptionGroup = new ButtonGroup();
        btntableOptionGroup.add(this.rbShowTableNumber);
        btntableOptionGroup.add(this.rbShowTableName);
        this.tfPrimaryFontSize = new IntegerTextField(10);
        this.tfSecondaryFontSize = new IntegerTextField(10);
        tableConfigurationPanel.add((Component)this.rbShowTableNumber, "wrap");
        tableConfigurationPanel.add((Component)this.rbShowTableName, "wrap");
        tableConfigurationPanel.add((Component)new JSeparator(), "gapleft 20,grow,span, wrap");
        tableConfigurationPanel.add((Component)this.chkShowServerName, "wrap");
        tableConfigurationPanel.add((Component)this.chkShowTokenNum, "wrap");
        tableConfigurationPanel.add((Component)this.chkShowCustomerName, "wrap");
        tableConfigurationPanel.add((Component)new JSeparator(), "gapleft 20,grow,span, wrap");
        tableConfigurationPanel.add((Component)this.chkShowResID, "wrap");
        tableConfigurationPanel.add((Component)this.chkShowTableStatus, "wrap");
        tableConfigurationPanel.add((Component)new JSeparator(), "gapleft 20,grow,span, wrap");
        tableConfigurationPanel.add((Component)new JLabel(Messages.getString("GeneralConfigurationView.21")), "");
        tableConfigurationPanel.add((Component)this.tfPrimaryFontSize, "wrap");
        tableConfigurationPanel.add((Component)new JLabel(Messages.getString("GeneralConfigurationView.24")), "");
        tableConfigurationPanel.add((Component)this.tfSecondaryFontSize, "wrap");
        tableConfigurationPanel.add((Component)new JSeparator(), "gapleft 20,grow,span, wrap");
        this.colArrays = new String[]{Messages.getString("GeneralConfigurationView.28"), Messages.getString("GeneralConfigurationView.29"), Messages.getString("GeneralConfigurationView.30"), Messages.getString("GeneralConfigurationView.31")};
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSave = new PosButton(Messages.getString("GeneralConfigurationView.34"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralConfigurationView.this.updateModel();
            }
        });
        buttonPanel.add(btnSave);
        this.add((Component)new JScrollPane(tableConfigurationPanel), "Center");
        this.add((Component)buttonPanel, "South");
    }

    private JPanel createColCnfgPanel(String title) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "[][]20[][]20[]", ""));
        panel.setBorder(BorderFactory.createTitledBorder(title));
        JLabel lblForeColorTxt = new JLabel(Messages.getString("GeneralConfigurationView.38"));
        JButton btnForeColor = new JButton();
        btnForeColor.setEnabled(false);
        btnForeColor.setBorder(new EtchedBorder(1, null, null));
        JLabel lblBgColorTxt = new JLabel(Messages.getString("GeneralConfigurationView.39"));
        JButton btnBgColor = new JButton();
        btnBgColor.setEnabled(false);
        btnBgColor.setBorder(new EtchedBorder(1, null, null));
        JButton btnBrowse = new JButton(Messages.getString("GeneralConfigurationView.40"));
        btnBrowse.setActionCommand(title);
        btnBrowse.addActionListener(this);
        this.buttonMap.put(title + "FC", btnForeColor);
        this.buttonMap.put(title + "BC", btnBgColor);
        panel.add(lblForeColorTxt);
        panel.add((Component)btnForeColor, "w 30!, grow");
        panel.add(lblBgColorTxt);
        panel.add((Component)btnBgColor, "w 30!,grow");
        panel.add(btnBrowse);
        return panel;
    }

    private void updateView() {
        Store store = DataProvider.get().getStore();
        this.servingForeColor = store.getTableServingForeColor();
        this.servingBgColor = store.getTableServingBGColor();
        this.seatForeColor = store.getTableSeatForeColor();
        this.seatBgColor = store.getTableSeatBGColor();
        this.bookForeColor = store.getTableBookForeColor();
        this.bookBgColor = store.getTableBookBGColor();
        this.freeForeColor = store.getTableFreeForeColor();
        this.freeBgColor = store.getTableFreeBGColor();
        this.rbShowTableName.setSelected(store.isShowTableNameOnTable());
        this.rbShowTableNumber.setSelected(store.isShowTableNumberOnTable());
        this.chkShowServerName.setSelected(store.isShowServerNameOnTable());
        this.chkShowTokenNum.setSelected(store.isShowTokenNumberOnTable());
        this.chkShowCustomerName.setSelected(store.isShowCustomerNameOnTable());
        this.chkShowResID.setSelected(store.isShowResIdOnTable());
        this.chkShowTableStatus.setSelected(store.isShowTableStatusOnTable());
        this.tfPrimaryFontSize.setText("" + store.getTablePrimaryFontSize());
        this.tfSecondaryFontSize.setText("" + store.getTableSecondaryFontSize());
        for (String colTxt : this.colArrays) {
            JButton btnFC = this.buttonMap.get(colTxt + "FC");
            JButton btnBC = this.buttonMap.get(colTxt + "BC");
            if (btnFC == null || btnBC == null) continue;
            if (colTxt.equals(this.colArrays[0])) {
                if (this.freeForeColor == null && this.freeBgColor == null) continue;
                btnFC.setBackground(this.freeForeColor);
                btnBC.setBackground(this.freeBgColor);
                continue;
            }
            if (colTxt.equals(this.colArrays[1])) {
                if (this.bookForeColor == null && this.bookBgColor == null) continue;
                btnFC.setBackground(this.bookForeColor);
                btnBC.setBackground(this.bookBgColor);
                continue;
            }
            if (colTxt.equals(this.colArrays[2])) {
                if (this.seatForeColor == null && this.seatBgColor == null) continue;
                btnFC.setBackground(this.seatForeColor);
                btnBC.setBackground(this.seatBgColor);
                continue;
            }
            if (!colTxt.equals(this.colArrays[3]) || this.servingForeColor == null && this.servingBgColor == null) continue;
            btnFC.setBackground(this.servingForeColor);
            btnBC.setBackground(this.servingBgColor);
        }
    }

    private void updateModel() {
        if (this.tfPrimaryFontSize.getInteger() < 0 || this.tfSecondaryFontSize.getInteger() < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GeneralConfigurationView.49"));
            return;
        }
        Store store = DataProvider.get().getStore();
        store.setShowTableNameOnTable(this.rbShowTableName.isSelected());
        store.setShowTableNumberOnTable(this.rbShowTableNumber.isSelected());
        store.setShowServerNameOnTable(this.chkShowServerName.isSelected());
        store.setShowTokenNumberOnTable(this.chkShowTokenNum.isSelected());
        store.setShowCustomerNameOnTable(this.chkShowCustomerName.isSelected());
        store.setShowResIdOnTable(this.chkShowResID.isSelected());
        store.setShowTableStatusOnTable(this.chkShowTableStatus.isSelected());
        store.setTablePrimaryFontSize(this.tfPrimaryFontSize.getInteger());
        store.setTableSecondaryFontSize(this.tfSecondaryFontSize.getInteger());
        store.setTableServingBGColor(this.servingBgColor);
        store.setTableServingForeColor(this.servingForeColor);
        store.setTableFreeBGColor(this.freeBgColor);
        store.setTableFreeForeColor(this.freeForeColor);
        store.setTableSeatBGColor(this.seatBgColor);
        store.setTableSeatForeColor(this.seatForeColor);
        store.setTableBookBGColor(this.bookBgColor);
        store.setTableBookForeColor(this.bookForeColor);
        StoreDAO.getInstance().saveOrUpdate(store);
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GeneralConfigurationView.50"));
    }

    private CustomColorChooserDialog doOpenColorChooserDialog() {
        CustomColorChooserDialog dialog = new CustomColorChooserDialog();
        dialog.setSize(PosUIManager.getSize(800, 500));
        dialog.setLocationRelativeTo(POSUtil.getBackOfficeWindow());
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        return dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            JButton btn = (JButton)e.getSource();
            if (btn.getActionCommand().equals(this.colArrays[2])) {
                CustomColorChooserDialog dialog = this.doOpenColorChooserDialog();
                if (dialog.isCanceled()) {
                    return;
                }
                if (dialog.getForeColor() != null) {
                    this.seatForeColor = dialog.getForeColor();
                }
                if (dialog.getBgColor() != null) {
                    this.seatBgColor = dialog.getBgColor();
                }
                JButton btnFC = this.buttonMap.get(this.colArrays[2] + "FC");
                JButton btnBC = this.buttonMap.get(this.colArrays[2] + "BC");
                if (btnFC != null) {
                    btnFC.setBackground(this.seatForeColor);
                }
                if (btnBC != null) {
                    btnBC.setBackground(this.seatBgColor);
                }
            } else if (btn.getActionCommand().equals(this.colArrays[1])) {
                CustomColorChooserDialog dialog = this.doOpenColorChooserDialog();
                if (dialog.isCanceled()) {
                    return;
                }
                if (dialog.getForeColor() != null) {
                    this.bookForeColor = dialog.getForeColor();
                }
                if (dialog.getBgColor() != null) {
                    this.bookBgColor = dialog.getBgColor();
                }
                JButton btnFC = this.buttonMap.get(this.colArrays[1] + "FC");
                JButton btnBC = this.buttonMap.get(this.colArrays[1] + "BC");
                if (btnFC != null) {
                    btnFC.setBackground(this.bookForeColor);
                }
                if (btnBC != null) {
                    btnBC.setBackground(this.bookBgColor);
                }
            } else if (btn.getActionCommand().equals(this.colArrays[0])) {
                CustomColorChooserDialog dialog = this.doOpenColorChooserDialog();
                if (dialog.isCanceled()) {
                    return;
                }
                if (dialog.getForeColor() != null) {
                    this.freeForeColor = dialog.getForeColor();
                }
                if (dialog.getBgColor() != null) {
                    this.freeBgColor = dialog.getBgColor();
                }
                JButton btnFC = this.buttonMap.get(this.colArrays[0] + "FC");
                JButton btnBC = this.buttonMap.get(this.colArrays[0] + "BC");
                if (btnFC != null) {
                    btnFC.setBackground(this.freeForeColor);
                }
                if (btnBC != null) {
                    btnBC.setBackground(this.freeBgColor);
                }
            } else if (btn.getActionCommand().equals(this.colArrays[3])) {
                CustomColorChooserDialog dialog = this.doOpenColorChooserDialog();
                if (dialog.isCanceled()) {
                    return;
                }
                if (dialog.getForeColor() != null) {
                    this.servingForeColor = dialog.getForeColor();
                }
                if (dialog.getBgColor() != null) {
                    this.servingBgColor = dialog.getBgColor();
                }
                JButton btnFC = this.buttonMap.get(this.colArrays[3] + "FC");
                JButton btnBC = this.buttonMap.get(this.colArrays[3] + "BC");
                if (btnFC != null) {
                    btnFC.setBackground(this.servingForeColor);
                }
                if (btnBC != null) {
                    btnBC.setBackground(this.servingBgColor);
                }
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }
}

