/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.actions.ViewChangeAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutoLogOffAlertDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PosWindow
extends JFrame
implements WindowListener,
OroMqttDataListener {
    private static final String EXTENDEDSTATE = "extendedstate";
    private static final String WLOCY = "wlocy";
    private static final String WLOCX = "wlocx";
    private static final String WHEIGHT = "wheight";
    private static final String WWIDTH = "wwidth";
    private GlassPane glassPane;
    private JLabel statusLabel;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss aaa");
    private JLabel lblRestaurantName;
    private JLabel lblUser;
    private JLabel lblTerminal;
    private JLabel lblDatabase;
    private JLabel lblTime;
    private JLabel lblUpdateAvl;
    private PosBlinkButton btnNewOrderArrived;
    private Timer clockTimer;
    private Timer autoLogoffTimer;
    private Timer updateCheckTimer;
    private AutoLogoffHandler autoLogoffHandler;
    private JPanel updateMsgPanel;
    private JSeparator separator;

    public void initComponents() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.glassPane = new GlassPane();
        this.glassPane.setOpacity(0.6f);
        this.setGlassPane(this.glassPane);
        this.statusLabel = new JLabel();
        JPanel statusBarContainer = new JPanel(new BorderLayout());
        statusBarContainer.add((Component)new JSeparator(0), "North");
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5 3 5 5", "[][][]", "[]"));
        infoPanel.setOpaque(true);
        Font f = this.statusLabel.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.lblRestaurantName = new JLabel();
        this.lblTerminal = new JLabel(Messages.getString("PosWindow.3") + TerminalConfig.getTerminalId());
        this.lblUser = new JLabel();
        this.lblDatabase = new JLabel();
        this.lblTime = new JLabel("");
        this.lblTime.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.lblUpdateAvl = new JLabel("");
        this.lblUpdateAvl.setForeground(Color.RED);
        this.btnNewOrderArrived = new PosBlinkButton(Messages.getString("NewOrderReceived"));
        this.btnNewOrderArrived.setPreferredSize(PosUIManager.getSize(0, 20));
        this.lblRestaurantName.setFont(f);
        this.lblUser.setFont(f);
        this.lblTerminal.setFont(f);
        this.lblDatabase.setFont(f);
        this.lblTime.setFont(f);
        this.lblUpdateAvl.setFont(f);
        this.btnNewOrderArrived.setFont(f);
        infoPanel.add(this.lblRestaurantName);
        infoPanel.add(this.lblTerminal);
        infoPanel.add(this.lblUser);
        infoPanel.add((Component)this.lblDatabase, "grow");
        this.updateMsgPanel = new JPanel((LayoutManager)new MigLayout("right, filly,hidemode 3, ins 0 0 0 0"));
        this.updateMsgPanel.add(this.lblUpdateAvl);
        this.separator = new JSeparator(1);
        this.updateMsgPanel.add((Component)this.separator, "growy");
        statusBarContainer.add((Component)infoPanel, "West");
        statusBarContainer.add((Component)this.updateMsgPanel, "Center");
        statusBarContainer.add((Component)this.lblTime, "East");
        this.getContentPane().add((Component)statusBarContainer, "South");
        this.initActionHandlers();
    }

    public void initTimers() {
        this.clockTimer = new Timer(1000, new ClockTimerHandler());
        this.clockTimer.start();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.updateCheckTimer = new Timer(900000, new UpdateCheckHandler());
            this.updateCheckTimer.start();
        }
    }

    private void initActionHandlers() {
        this.addWindowListener(this);
        this.lblUpdateAvl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PosWindow.this.doShowUpdateDialog();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                super.mouseEntered(arg0);
                PosWindow.this.lblUpdateAvl.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                super.mouseExited(arg0);
                PosWindow.this.lblUpdateAvl.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.btnNewOrderArrived.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                new GotoSwitchboardView().actionPerformed(null);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                super.mouseEntered(arg0);
                PosWindow.this.btnNewOrderArrived.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                super.mouseExited(arg0);
                PosWindow.this.btnNewOrderArrived.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void rendererUserInfo() {
        User currentUser = Application.getCurrentUser();
        if (currentUser != null) {
            this.lblUser.setText(Messages.getString("PosWindow.6") + currentUser.getFullName() + " (" + currentUser.getType().getName() + ")");
        } else {
            this.lblUser.setText("");
        }
    }

    public void setRestaurantName(String name) {
        this.lblRestaurantName.setText(name);
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void setupSizeAndLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(AppConfig.getInt(WWIDTH, (int)screenSize.getWidth()), AppConfig.getInt(WHEIGHT, (int)screenSize.getHeight()));
        this.setLocation(AppConfig.getInt(WLOCX, screenSize.width - this.getWidth() >> 1), AppConfig.getInt(WLOCY, screenSize.height - this.getHeight() >> 1));
        this.setMinimumSize(new Dimension(1024, 724));
        this.setDefaultCloseOperation(0);
        int extendedState = AppConfig.getInt(EXTENDEDSTATE, -1);
        if (extendedState != -1) {
            this.setExtendedState(extendedState);
        }
    }

    public void enterFullScreenMode() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.setLocation(0, 0);
    }

    public void leaveFullScreenMode() {
        GraphicsDevice window = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        this.setUndecorated(false);
        window.setFullScreenWindow(null);
    }

    public void saveSizeAndLocation() {
        int width = this.getWidth();
        int height = this.getHeight();
        AppConfig.putInt(WWIDTH, width);
        AppConfig.putInt(WHEIGHT, height);
        Point locationOnScreen = this.getLocationOnScreen();
        AppConfig.putInt(WLOCX, locationOnScreen.x);
        AppConfig.putInt(WLOCY, locationOnScreen.y);
        AppConfig.putInt(EXTENDEDSTATE, this.getExtendedState());
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    private void startTimer() {
        if (this.clockTimer != null) {
            this.clockTimer.start();
        }
    }

    private void stopTimer() {
        if (this.clockTimer != null) {
            this.clockTimer.stop();
        }
    }

    public void startAutoLogoffTimer() {
        Terminal terminal;
        if (this.autoLogoffHandler == null) {
            this.autoLogoffHandler = new AutoLogoffHandler();
        }
        if ((terminal = Application.getInstance().getTerminal()) != null && terminal.isIsAutoLogOffEnabled().booleanValue()) {
            this.autoLogoffTimer = new Timer(terminal.getAutoLogOffSec() * 1000, this.autoLogoffHandler);
            this.autoLogoffTimer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.autoLogoffHandler, 131128L);
        }
    }

    public void stopAutoLogoffTimer() {
        if (this.autoLogoffTimer != null) {
            this.autoLogoffTimer.stop();
            this.autoLogoffTimer = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.autoLogoffHandler);
        }
    }

    private void showFooterTimer() {
        StringBuilder sb = new StringBuilder();
        String deafultDate = TerminalConfig.getTicketCreationDate();
        this.lblTime.setForeground(Color.BLACK);
        if (deafultDate != null) {
            sb.append(Messages.getString("PosWindow.2"));
            sb.append(deafultDate + " ");
            this.lblTime.setForeground(Color.RED);
        }
        sb.append(dateFormat.format(Calendar.getInstance().getTime()));
        this.lblTime.setText(sb.toString());
    }

    public void checkForUpdate() {
        UpdateManager updateManager = Application.getInstance().getUpdateManager();
        if (!updateManager.isUpdateAvailable()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.getString("PosWindow.0"));
        this.lblUpdateAvl.setText(sb.toString());
        if (this.updateCheckTimer != null) {
            this.updateCheckTimer.stop();
        }
    }

    public void setGlassPaneVisible(boolean b) {
        this.glassPane.setVisible(b);
    }

    public void updateView() {
        this.lblTerminal.setText(Messages.getString("PosWindow.10") + TerminalConfig.getTerminalId());
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (Application.getCurrentUser() != null) {
            new ShutDownAction().actionPerformed(null);
        } else {
            Application.getInstance().shutdownPOS();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void doShowUpdateDialog() {
        try {
            if (this.updateCheckTimer != null && this.updateCheckTimer.isRunning()) {
                this.updateCheckTimer.stop();
            }
            Application.getInstance().checkForUpdate(true);
            if (this.updateCheckTimer != null) {
                this.updateCheckTimer.start();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void ticketReceived() {
        this.updateMsgPanel.add(this.btnNewOrderArrived);
        this.updateMsgPanel.add((Component)this.separator, "growy");
        this.updateMsgPanel.revalidate();
        this.updateMsgPanel.repaint();
        this.btnNewOrderArrived.setBlinking(true);
    }

    class GotoSwitchboardView
    extends ViewChangeAction {
        GotoSwitchboardView() {
        }

        @Override
        public void execute() {
            try {
                if (Application.getCurrentUser() != null) {
                    RootView rootView = RootView.getInstance();
                    if (!rootView.getCurrentView().getViewName().equals(SwitchboardView.VIEW_NAME)) {
                        rootView.showView(SwitchboardView.getInstance());
                    }
                    SwitchboardView.getInstance().refresh();
                    PosWindow.this.btnNewOrderArrived.setBlinking(false);
                    PosWindow.this.updateMsgPanel.remove(PosWindow.this.btnNewOrderArrived);
                    PosWindow.this.updateMsgPanel.revalidate();
                    PosWindow.this.updateMsgPanel.repaint();
                } else {
                    PosWindow.this.btnNewOrderArrived.setBlinking(true);
                }
            }
            catch (Exception e1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
            }
        }
    }

    private class AutoLogoffHandler
    implements ActionListener,
    AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent event) {
            this.reset();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PosWindow.this.autoLogoffTimer != null) {
                PosWindow.this.autoLogoffTimer.stop();
            }
            if (!PosWindow.this.isShowing()) {
                return;
            }
            if (PosGuiUtil.isModalDialogShowing()) {
                this.reset();
                return;
            }
            AutoLogOffAlertDialog dialog = new AutoLogOffAlertDialog();
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                this.reset();
                return;
            }
            Application.getInstance().doAutoLogout();
        }

        public void reset() {
            if (PosWindow.this.autoLogoffTimer != null) {
                PosWindow.this.autoLogoffTimer.restart();
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(PosWindow.this.autoLogoffHandler);
            }
        }
    }

    private class UpdateCheckHandler
    implements ActionListener {
        private UpdateCheckHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PosWindow.this.checkForUpdate();
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PosWindow.this.isShowing()) {
                PosWindow.this.clockTimer.stop();
                return;
            }
            PosWindow.this.showFooterTimer();
        }
    }
}

